/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.vulnerabilities.ssc;

import com.hp.octane.integrations.dto.securityscans.OctaneIssue;
import com.hp.octane.integrations.exceptions.PermanentException;
import com.hp.octane.integrations.services.vulnerabilities.PackIssuesToOctaneUtils;
import com.hp.octane.integrations.services.vulnerabilities.ssc.SSCHandler;
import com.hp.octane.integrations.services.vulnerabilities.ssc.SSCToOctaneIssueUtil;
import com.hp.octane.integrations.services.vulnerabilities.ssc.dto.IssueDetails;
import com.hp.octane.integrations.services.vulnerabilities.ssc.dto.Issues;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PackSSCIssuesToSendToOctane {
    private static final Logger logger = LogManager.getLogger(PackSSCIssuesToSendToOctane.class);
    private List<Issues.Issue> sscIssues;
    private List<String> octaneIssues;
    private String remoteTag;
    private boolean considerMissing;
    private SSCHandler sscHandler;

    public List<OctaneIssue> packToOctaneIssues() {
        logger.debug("started packing");
        PackIssuesToOctaneUtils.SortedIssues<Issues.Issue> issueSortedIssues = PackIssuesToOctaneUtils.packToOctaneIssues(this.sscIssues, this.octaneIssues, this.considerMissing);
        Map<Integer, IssueDetails> issuesWithExtendedData = this.sscHandler.getIssuesExtendedData(issueSortedIssues.issuesRequiredExtendedData);
        logger.debug("before creating octane issues");
        List<OctaneIssue> openOctaneIssues = SSCToOctaneIssueUtil.createOctaneIssues(issueSortedIssues.issuesToUpdate, this.remoteTag, issuesWithExtendedData);
        logger.debug("after creating octane issues");
        ArrayList<OctaneIssue> total = new ArrayList<OctaneIssue>();
        total.addAll(openOctaneIssues);
        total.addAll(issueSortedIssues.issuesToClose);
        if (total.isEmpty()) {
            throw new PermanentException("This scan has no issues.");
        }
        return total;
    }

    public void setSscIssues(List<Issues.Issue> sscIssues) {
        this.sscIssues = sscIssues;
    }

    public void setOctaneIssues(List<String> octaneIssues) {
        this.octaneIssues = octaneIssues;
    }

    public void setRemoteTag(String remoteTag) {
        this.remoteTag = remoteTag;
    }

    public void setConsiderMissing(boolean considerMissing) {
        this.considerMissing = considerMissing;
    }

    public void setSscHandler(SSCHandler sscHandler) {
        this.sscHandler = sscHandler;
    }
}

