/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.vulnerabilities.fod.dto;

public abstract class FODConfig {
    public final String authURLApi;
    public final String entitiesURL;

    public abstract String getAuthBody();

    protected FODConfig(String baseURLApi) {
        String normanlizedURL = baseURLApi;
        if (!normanlizedURL.endsWith("/")) {
            normanlizedURL = normanlizedURL + "/";
        }
        this.authURLApi = normanlizedURL + "oauth/token";
        this.entitiesURL = normanlizedURL + "api/v3";
    }

    public static class CredentialsFODConfig
    extends FODConfig {
        static final String authBodyFormat = "grant_type=client_credentials&scope=api-tenant&client_id=%s&client_secret=%s";
        String client_id;
        String secret;

        public CredentialsFODConfig(String baseUrl, String clientID, String secret) {
            super(baseUrl);
            this.client_id = clientID;
            this.secret = secret;
        }

        @Override
        public String getAuthBody() {
            return String.format(authBodyFormat, this.client_id, this.secret);
        }
    }

    public static class PasswordFODConfig
    extends FODConfig {
        String username;
        String password;
        String tenant;
        static final String authPWDBodyFormat = "grant_type=client_credentials&scope=api-tenant&client_id=%s&client_secret=%s";

        public PasswordFODConfig(String baseUrl, String username, String password, String tenant) {
            super(baseUrl);
            this.password = password;
            this.username = username;
            this.tenant = tenant;
        }

        @Override
        public String getAuthBody() {
            return String.format(authPWDBodyFormat, this.tenant, this.username, this.password);
        }
    }
}

