/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.vulnerabilities;

import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.connectivity.HttpMethod;
import com.hp.octane.integrations.dto.connectivity.OctaneRequest;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.exceptions.OctaneSDKGeneralException;
import com.hp.octane.integrations.exceptions.PermanentException;
import com.hp.octane.integrations.exceptions.TemporaryException;
import com.hp.octane.integrations.services.WorkerPreflight;
import com.hp.octane.integrations.services.configuration.ConfigurationService;
import com.hp.octane.integrations.services.configuration.ConfigurationServiceImpl;
import com.hp.octane.integrations.services.configurationparameters.factory.ConfigurationParameterFactory;
import com.hp.octane.integrations.services.queueing.QueueingService;
import com.hp.octane.integrations.services.rest.OctaneRestClient;
import com.hp.octane.integrations.services.rest.RestService;
import com.hp.octane.integrations.services.vulnerabilities.DateUtils;
import com.hp.octane.integrations.services.vulnerabilities.ToolType;
import com.hp.octane.integrations.services.vulnerabilities.VulnerabilitiesQueueItem;
import com.hp.octane.integrations.services.vulnerabilities.VulnerabilitiesService;
import com.hp.octane.integrations.services.vulnerabilities.VulnerabilitiesToolService;
import com.hp.octane.integrations.services.vulnerabilities.fod.dto.FodConnectionFactory;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import com.squareup.tape.ObjectQueue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VulnerabilitiesServiceImpl
implements VulnerabilitiesService {
    private static final Logger logger = LogManager.getLogger(VulnerabilitiesServiceImpl.class);
    private static final String VULNERABILITIES_QUEUE_FILE = "vulnerabilities-queue.dat";
    private final ExecutorService vulnerabilitiesProcessingExecutor = Executors.newSingleThreadExecutor(new VulnerabilitiesPushWorkerThreadFactory());
    private final ObjectQueue<VulnerabilitiesQueueItem> vulnerabilitiesQueue;
    protected final RestService restService;
    protected final ConfigurationService configurationService;
    protected final OctaneSDK.SDKServicesConfigurer configurer;
    private final Map<String, VulnerabilitiesToolService> vulnerabilitiesServices;
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();
    private int TEMPORARY_ERROR_BREATHE_INTERVAL = 15000;
    private int SKIP_QUEUE_ITEM_INTERVAL = 5000;
    private Long DEFAULT_TIMEOUT_FOR_QUEUE_ITEM = 43200000L;
    private CompletableFuture<Boolean> workerExited;
    private final WorkerPreflight workerPreflight;

    public VulnerabilitiesServiceImpl(QueueingService queueingService, VulnerabilitiesToolService[] vulnerabilitiesToolServices, OctaneSDK.SDKServicesConfigurer configurer, RestService restService, ConfigurationService configurationService) {
        if (queueingService == null) {
            throw new IllegalArgumentException("queue Service MUST NOT be null");
        }
        if (restService == null) {
            throw new IllegalArgumentException("rest service MUST NOT be null");
        }
        if (configurer == null) {
            throw new IllegalArgumentException("configurer MUST NOT be null");
        }
        if (configurationService == null) {
            throw new IllegalArgumentException("configuration service MUST NOT be null");
        }
        this.restService = restService;
        this.configurationService = configurationService;
        this.configurer = configurer;
        this.workerPreflight = new WorkerPreflight(this, configurationService, logger);
        FodConnectionFactory.setConfigurer(this.configurer);
        this.vulnerabilitiesServices = new HashMap<String, VulnerabilitiesToolService>();
        for (VulnerabilitiesToolService vulnerabilitiesToolService : vulnerabilitiesToolServices) {
            this.vulnerabilitiesServices.put(vulnerabilitiesToolService.getVulnerabilitiesToolKey(), vulnerabilitiesToolService);
        }
        this.vulnerabilitiesQueue = queueingService.isPersistenceEnabled() ? queueingService.initFileQueue(VULNERABILITIES_QUEUE_FILE, VulnerabilitiesQueueItem.class) : queueingService.initMemoQueue();
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "starting background worker...");
        this.vulnerabilitiesProcessingExecutor.execute(this::worker);
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "initialized SUCCESSFULLY (backed by " + this.vulnerabilitiesQueue.getClass().getSimpleName() + ")");
    }

    @Override
    public void addVulnerabilitiesToolService(VulnerabilitiesToolService vulnerabilitiesToolService) {
        this.vulnerabilitiesServices.put(vulnerabilitiesToolService.getVulnerabilitiesToolKey(), vulnerabilitiesToolService);
    }

    @Override
    public void enqueueRetrieveAndPushVulnerabilities(String jobId, String buildId, ToolType toolType, long startRunTime, long queueItemTimeout, Map<String, String> additionalProperties, String rootJobId) {
        this.enqueueRetrieveAndPushVulnerabilities(jobId, buildId, toolType.name(), startRunTime, queueItemTimeout, additionalProperties, rootJobId);
    }

    @Override
    public void enqueueRetrieveAndPushVulnerabilities(String jobId, String buildId, String toolType, long startRunTime, long queueItemTimeout, Map<String, String> additionalProperties, String rootJobId) {
        if (this.configurer.octaneConfiguration.isDisabled()) {
            return;
        }
        if (!((ConfigurationServiceImpl)this.configurationService).isRelevantForOctane(rootJobId)) {
            return;
        }
        VulnerabilitiesQueueItem vulnerabilitiesQueueItem = new VulnerabilitiesQueueItem(jobId, buildId);
        vulnerabilitiesQueueItem.setStartTime(startRunTime);
        vulnerabilitiesQueueItem.setTimeout(queueItemTimeout <= 0L ? this.DEFAULT_TIMEOUT_FOR_QUEUE_ITEM : queueItemTimeout * 60L * 60L * 1000L);
        vulnerabilitiesQueueItem.setToolType(toolType);
        vulnerabilitiesQueueItem.setAdditionalProperties(additionalProperties);
        this.vulnerabilitiesQueue.add((Object)vulnerabilitiesQueueItem);
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + vulnerabilitiesQueueItem.getJobId() + ":" + vulnerabilitiesQueueItem.getBuildId() + " was added to vulnerabilities queue, currently : " + this.vulnerabilitiesQueue.size() + " items in queue");
        this.workerPreflight.itemAddedToQueue();
    }

    @Override
    public void shutdown() {
        this.workerExited = new CompletableFuture();
        this.vulnerabilitiesProcessingExecutor.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.vulnerabilitiesProcessingExecutor.isShutdown();
    }

    private void worker() {
        while (!this.vulnerabilitiesProcessingExecutor.isShutdown()) {
            if (!this.workerPreflight.preflight()) continue;
            VulnerabilitiesQueueItem queueItem = null;
            try {
                logger.debug("before vulnerabilitiesQueue.peek");
                queueItem = (VulnerabilitiesQueueItem)this.vulnerabilitiesQueue.peek();
                logger.debug("after vulnerabilitiesQueue.peek, queueItem: " + queueItem.toString());
                if (this.processPushVulnerabilitiesQueueItem(queueItem)) {
                    this.vulnerabilitiesQueueItemCleanUp(queueItem);
                    this.vulnerabilitiesQueue.remove();
                    continue;
                }
                this.reEnqueueItem(queueItem);
            }
            catch (TemporaryException tque) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "temporary error on " + queueItem + ", breathing " + this.TEMPORARY_ERROR_BREATHE_INTERVAL + "ms and retrying", (Throwable)tque);
                if (queueItem != null) {
                    this.reEnqueueItem(queueItem);
                }
                CIPluginSDKUtils.doWait(this.TEMPORARY_ERROR_BREATHE_INTERVAL);
            }
            catch (PermanentException pqie) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "permanent error on " + queueItem + ", passing over", (Throwable)pqie);
                this.vulnerabilitiesQueueItemCleanUp(queueItem);
                this.vulnerabilitiesQueue.remove();
            }
            catch (Throwable t) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "unexpected error on build log item '" + queueItem + "', passing over", t);
                this.vulnerabilitiesQueueItemCleanUp(queueItem);
                this.vulnerabilitiesQueue.remove();
            }
        }
        this.workerExited.complete(true);
    }

    private boolean processPushVulnerabilitiesQueueItem(VulnerabilitiesQueueItem queueItem) {
        try {
            if (!queueItem.isRelevant()) {
                logger.debug("before vulnerabilitiesPreflightRequest");
                Date relevant = this.vulnerabilitiesPreflightRequest(queueItem.getJobId(), queueItem.getBuildId());
                logger.debug("after vulnerabilitiesPreflightRequest");
                if (relevant != null) {
                    logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + queueItem.toString() + " , Relevant:" + relevant);
                    queueItem.setRelevant(true);
                    if (relevant.compareTo(DateUtils.getDateFromUTCString("2000-01-01", "yyyy-MM-dd")) > 0) {
                        queueItem.setBaselineDate(relevant);
                    }
                } else {
                    logger.debug("before return with true to silently proceed to the next item");
                    return true;
                }
            }
            logger.debug("before getVulnerabilitiesScanResultStream, queueItem.getJobId() : " + String.valueOf(queueItem.getJobId()) + " queueItem.getBuildId: " + String.valueOf(queueItem.getBuildId()));
            InputStream vulnerabilitiesStream = this.getToolService(queueItem).getVulnerabilitiesScanResultStream(queueItem);
            if (vulnerabilitiesStream == null) {
                logger.debug("vulnerabilitiesStream is null queueItem.getJobId() :" + String.valueOf(queueItem.getJobId()) + " queueItem.getBuildId: " + String.valueOf(queueItem.getBuildId()));
                return false;
            }
            logger.debug("before pushVulnerabilities, queueItem.getJobId() : " + String.valueOf(queueItem.getJobId()) + " queueItem.getBuildId: " + String.valueOf(queueItem.getBuildId()));
            this.pushVulnerabilities(vulnerabilitiesStream, queueItem.getJobId(), queueItem.getBuildId());
            return true;
        }
        catch (IOException e) {
            throw new PermanentException(e);
        }
    }

    private VulnerabilitiesToolService getToolService(VulnerabilitiesQueueItem queueItem) {
        return Optional.ofNullable(this.vulnerabilitiesServices.get(queueItem.getToolType())).orElseThrow(() -> new OctaneSDKGeneralException("Vulnerability tool service with name \"" + queueItem.getToolType() + "\" is not registered."));
    }

    private boolean isEncodeBase64() {
        return ConfigurationParameterFactory.isEncodeCiJobBase64(this.configurer.octaneConfiguration);
    }

    private void pushVulnerabilities(InputStream vulnerabilities, String jobId, String buildId) throws IOException {
        OctaneRestClient octaneRestClient = this.restService.obtainOctaneRestClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", ContentType.APPLICATION_JSON.getMimeType());
        boolean base64 = this.isEncodeBase64();
        String encodedJobId = base64 ? CIPluginSDKUtils.urlEncodeBase64(jobId) : CIPluginSDKUtils.urlEncodePathParam(jobId);
        String encodedBuildId = CIPluginSDKUtils.urlEncodePathParam(buildId);
        String url = this.getVulnerabilitiesContextPath(this.configurer.octaneConfiguration.getUrl(), this.configurer.octaneConfiguration.getSharedSpace()) + "?instance-id=" + this.configurer.octaneConfiguration.getInstanceId() + "&job-ci-id=" + encodedJobId + "&build-ci-id=" + encodedBuildId;
        logger.debug("URL: " + url);
        if (base64) {
            url = CIPluginSDKUtils.addParameterEncode64ToUrl(url);
        }
        OctaneRequest request = ((OctaneRequest)dtoFactory.newDTO(OctaneRequest.class)).setMethod(HttpMethod.POST).setUrl(url).setHeaders(headers).setBody(vulnerabilities);
        logger.debug("headers: " + headers);
        logger.debug("vulnerabilities: request.getBody " + request.getBody());
        OctaneResponse response = octaneRestClient.execute(request);
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "vulnerabilities pushed; status: " + response.getStatus() + ", response: " + response.getBody());
        if (response.getStatus() != 202) {
            if (response.getStatus() == 503) {
                throw new TemporaryException("vulnerabilities push FAILED, service unavailable");
            }
            if (response.getStatus() == 429) {
                throw new TemporaryException("vulnerabilities push FAILED, to many requests");
            }
            throw new PermanentException("vulnerabilities push FAILED, status " + response.getStatus() + "; dropping this item from the queue \n" + response.getBody());
        }
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "vulnerabilities push SUCCEED for " + jobId + " #" + buildId);
    }

    private Date vulnerabilitiesPreflightRequest(String jobId, String buildId) throws IOException {
        OctaneResponse response = this.getBaselineDateFromOctane(jobId, buildId);
        if (response.getStatus() == 200) {
            if (response.getBody() == null || "".equals(response.getBody())) {
                logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "vulnerabilities data of " + jobId + " #" + buildId + " is not relevant to Octane");
                return null;
            }
            logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "vulnerabilities data of " + jobId + " #" + buildId + " found to be relevant to Octane");
            boolean forTest = false;
            if ("true".equals(response.getBody()) || forTest) {
                return DateUtils.getDateFromUTCString("2000-01-01", "yyyy-MM-dd");
            }
            return DateUtils.getDateFromUTCString(response.getBody(), "yyyy-MM-dd'T'HH:mm:ss'Z'");
        }
        if (response.getStatus() == 503 || response.getStatus() == 502) {
            throw new TemporaryException("vulnerabilities preflight request FAILED, service unavailable");
        }
        throw new PermanentException("vulnerabilities preflight request FAILED with " + response.getStatus() + "");
    }

    private void reEnqueueItem(VulnerabilitiesQueueItem vulnerabilitiesQueueItem) {
        Long timePass = System.currentTimeMillis() - vulnerabilitiesQueueItem.getStartTime();
        this.vulnerabilitiesQueue.remove();
        if (timePass < vulnerabilitiesQueueItem.getTimeout()) {
            this.vulnerabilitiesQueue.add((Object)vulnerabilitiesQueueItem);
        } else {
            logger.info(this.configurer.octaneConfiguration.getLocationForLog() + vulnerabilitiesQueueItem.getBuildId() + "/" + vulnerabilitiesQueueItem.getJobId() + " was removed from queue after timeout in queue is over");
        }
        CIPluginSDKUtils.doWait(this.SKIP_QUEUE_ITEM_INTERVAL);
    }

    private OctaneResponse getBaselineDateFromOctane(String jobId, String buildId) throws IOException {
        boolean base64 = this.isEncodeBase64();
        String encodedJobId = base64 ? CIPluginSDKUtils.urlEncodeBase64(jobId) : CIPluginSDKUtils.urlEncodeQueryParam(jobId);
        String encodedBuildId = CIPluginSDKUtils.urlEncodeQueryParam(buildId);
        String url = this.getVulnerabilitiesPreFlightContextPath(this.configurer.octaneConfiguration.getUrl(), this.configurer.octaneConfiguration.getSharedSpace()) + "?instance-id=" + this.configurer.octaneConfiguration.getInstanceId() + "&job-ci-id=" + encodedJobId + "&build-ci-id=" + encodedBuildId;
        if (base64) {
            url = CIPluginSDKUtils.addParameterEncode64ToUrl(url);
        }
        OctaneRequest preflightRequest = ((OctaneRequest)dtoFactory.newDTO(OctaneRequest.class)).setMethod(HttpMethod.GET).setUrl(url);
        return this.restService.obtainOctaneRestClient().execute(preflightRequest);
    }

    private boolean vulnerabilitiesQueueItemCleanUp(VulnerabilitiesQueueItem queueItem) {
        if (queueItem == null) {
            return true;
        }
        return this.getToolService(queueItem).vulnerabilitiesQueueItemCleanUp(queueItem);
    }

    @Override
    public long getQueueSize() {
        return this.vulnerabilitiesQueue.size();
    }

    @Override
    public void clearQueue() {
        while (this.vulnerabilitiesQueue.size() > 0) {
            this.vulnerabilitiesQueue.remove();
        }
    }

    @Override
    public Map<String, Object> getMetrics() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("queueSize", this.getQueueSize());
        this.workerPreflight.addMetrics(map);
        return map;
    }

    private String getVulnerabilitiesContextPath(String octaneBaseUrl, String sharedSpaceId) {
        return octaneBaseUrl + "/api/shared_spaces/" + sharedSpaceId + "/vulnerabilities";
    }

    private String getVulnerabilitiesPreFlightContextPath(String octaneBaseUrl, String sharedSpaceId) {
        return octaneBaseUrl + "/api/shared_spaces/" + sharedSpaceId + "/vulnerabilities/preflight";
    }

    private static final class VulnerabilitiesPushWorkerThreadFactory
    implements ThreadFactory {
        private VulnerabilitiesPushWorkerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread result = new Thread(runnable);
            result.setName("VulnerabilitiesPushWorker-" + result.getId());
            result.setDaemon(true);
            return result;
        }
    }
}

