/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.scmdata;

import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.causes.CIEventCause;
import com.hp.octane.integrations.dto.causes.CIEventCauseType;
import com.hp.octane.integrations.dto.connectivity.HttpMethod;
import com.hp.octane.integrations.dto.connectivity.OctaneRequest;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.events.CIEvent;
import com.hp.octane.integrations.dto.events.CIEventType;
import com.hp.octane.integrations.dto.scm.SCMData;
import com.hp.octane.integrations.exceptions.PermanentException;
import com.hp.octane.integrations.exceptions.TemporaryException;
import com.hp.octane.integrations.services.WorkerPreflight;
import com.hp.octane.integrations.services.configuration.ConfigurationService;
import com.hp.octane.integrations.services.configuration.ConfigurationServiceImpl;
import com.hp.octane.integrations.services.configurationparameters.factory.ConfigurationParameterFactory;
import com.hp.octane.integrations.services.events.EventsService;
import com.hp.octane.integrations.services.queueing.QueueingService;
import com.hp.octane.integrations.services.rest.OctaneRestClient;
import com.hp.octane.integrations.services.rest.RestService;
import com.hp.octane.integrations.services.scmdata.SCMDataQueueItem;
import com.hp.octane.integrations.services.scmdata.SCMDataService;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import com.squareup.tape.ObjectQueue;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SCMDataServiceImpl
implements SCMDataService {
    protected final RestService restService;
    private static final Logger logger = LogManager.getLogger(SCMDataServiceImpl.class);
    private static final String SCMDATA_QUEUE_DAT = "scmdata-queue.dat";
    protected final ConfigurationService configurationService;
    protected final EventsService eventsService;
    protected final OctaneSDK.SDKServicesConfigurer configurer;
    private final WorkerPreflight workerPreflight;
    private final ExecutorService scmProcessingExecutor = Executors.newSingleThreadExecutor(new SCMPushWorkerThreadFactory());
    private final ObjectQueue<SCMDataQueueItem> scmDataQueue;
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();
    private int TEMPORARY_ERROR_BREATHE_INTERVAL = 10000;
    public static final String SCM_REST_API_SUPPORTED_VERSION = "15.1.23";
    private final ScheduledExecutorService publishService = Executors.newScheduledThreadPool(5);

    public SCMDataServiceImpl(QueueingService queueingService, OctaneSDK.SDKServicesConfigurer configurer, RestService restService, ConfigurationService configurationService, EventsService eventsService) {
        if (queueingService == null) {
            throw new IllegalArgumentException("queue Service MUST NOT be null");
        }
        if (restService == null) {
            throw new IllegalArgumentException("rest service MUST NOT be null");
        }
        if (configurer == null) {
            throw new IllegalArgumentException("configurer service MUST NOT be null");
        }
        if (configurationService == null) {
            throw new IllegalArgumentException("configuration service MUST NOT be null");
        }
        this.restService = restService;
        this.configurationService = configurationService;
        this.eventsService = eventsService;
        this.configurer = configurer;
        this.workerPreflight = new WorkerPreflight(this, configurationService, logger);
        this.scmDataQueue = queueingService.isPersistenceEnabled() ? queueingService.initFileQueue(SCMDATA_QUEUE_DAT, SCMDataQueueItem.class) : queueingService.initMemoQueue();
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "starting background worker...");
        this.scmProcessingExecutor.execute(this::worker);
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "initialized SUCCESSFULLY (backed by " + this.scmDataQueue.getClass().getSimpleName() + ")");
    }

    @Override
    public void enqueueSCMData(String jobId, String buildId, SCMData scmData, String rootJobId) {
        if (this.configurer.octaneConfiguration.isDisabled()) {
            return;
        }
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("job ID MUST NOT be null nor empty");
        }
        if (buildId == null || buildId.isEmpty()) {
            throw new IllegalArgumentException("build ID MUST NOT be null nor empty");
        }
        if (this.configurer.octaneConfiguration.isDisabled()) {
            return;
        }
        if (!((ConfigurationServiceImpl)this.configurationService).isRelevantForOctane(rootJobId)) {
            return;
        }
        this.publishService.schedule(() -> this.enqueueSCMDataInternal(jobId, buildId, scmData), 5L, TimeUnit.SECONDS);
    }

    private void enqueueSCMDataInternal(String jobId, String buildId, SCMData scmData) {
        if (this.isSCMRestAPI() && this.configurationService.isOctaneVersionGreaterOrEqual(SCM_REST_API_SUPPORTED_VERSION)) {
            SCMDataQueueItem scmDataQueueItem = new SCMDataQueueItem(jobId, buildId);
            this.scmDataQueue.add((Object)scmDataQueueItem);
            logger.info(this.configurer.octaneConfiguration.getLocationForLog() + scmDataQueueItem.getJobId() + " #" + scmDataQueueItem.getBuildId() + " was added to queue");
            this.workerPreflight.itemAddedToQueue();
        } else {
            this.pushSCMDataByEvent(scmData, jobId, buildId);
        }
    }

    @Override
    public void shutdown() {
        this.scmProcessingExecutor.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.scmProcessingExecutor.isShutdown();
    }

    @Override
    public Map<String, Object> getMetrics() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("queueSize", this.getQueueSize());
        this.workerPreflight.addMetrics(map);
        return map;
    }

    @Override
    public long getQueueSize() {
        return this.scmDataQueue.size();
    }

    @Override
    public void clearQueue() {
        while (this.scmDataQueue.size() > 0) {
            this.scmDataQueue.remove();
        }
    }

    private void worker() {
        while (!this.scmProcessingExecutor.isShutdown()) {
            if (!this.workerPreflight.preflight()) continue;
            SCMDataQueueItem queueItem = null;
            try {
                queueItem = (SCMDataQueueItem)this.scmDataQueue.peek();
                this.processPushSCMDataQueueItem(queueItem);
                this.scmDataQueue.remove();
            }
            catch (TemporaryException tque) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "temporary error on " + queueItem + ", breathing " + this.TEMPORARY_ERROR_BREATHE_INTERVAL + "ms and retrying", (Throwable)tque);
            }
            catch (PermanentException pqie) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "permanent error on " + queueItem + ", passing over", (Throwable)pqie);
                this.scmDataQueue.remove();
            }
            catch (Throwable t) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "unexpected error on build log item '" + queueItem + "', passing over", t);
                this.scmDataQueue.remove();
            }
        }
    }

    private boolean processPushSCMDataQueueItem(SCMDataQueueItem queueItem) {
        try {
            InputStream scmData = this.configurer.pluginServices.getSCMData(queueItem.getJobId(), queueItem.getBuildId());
            if (scmData == null) {
                return false;
            }
            this.pushSCMDataByRestAPI(queueItem.getJobId(), queueItem.getBuildId(), scmData);
            return true;
        }
        catch (IOException e) {
            throw new PermanentException(e);
        }
    }

    private boolean isEncodeBase64() {
        return ConfigurationParameterFactory.isEncodeCiJobBase64(this.configurer.octaneConfiguration);
    }

    private boolean isSCMRestAPI() {
        return ConfigurationParameterFactory.isSCMRestAPI(this.configurer.octaneConfiguration);
    }

    private void pushSCMDataByRestAPI(String jobId, String buildId, InputStream scmData) throws IOException {
        OctaneRequest request;
        OctaneResponse response;
        OctaneRestClient octaneRestClient = this.restService.obtainOctaneRestClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", ContentType.APPLICATION_JSON.getMimeType());
        boolean base64 = this.isEncodeBase64();
        String encodedJobId = base64 ? CIPluginSDKUtils.urlEncodeBase64(jobId) : CIPluginSDKUtils.urlEncodeQueryParam(jobId);
        String encodedBuildId = CIPluginSDKUtils.urlEncodeQueryParam(buildId);
        String url = this.getSCMDataContextPath(this.configurer.octaneConfiguration.getUrl(), this.configurer.octaneConfiguration.getSharedSpace()) + "?instance-id=" + this.configurer.octaneConfiguration.getInstanceId() + "&job-ci-id=" + encodedJobId + "&build-ci-id=" + encodedBuildId;
        if (base64) {
            url = CIPluginSDKUtils.addParameterEncode64ToUrl(url);
        }
        if ((response = octaneRestClient.execute(request = ((OctaneRequest)dtoFactory.newDTO(OctaneRequest.class)).setMethod(HttpMethod.PUT).setUrl(url).setHeaders(headers).setBody(scmData))).getStatus() != 200) {
            if (response.getStatus() == 503) {
                throw new TemporaryException("scmData push FAILED, service unavailable");
            }
            throw new PermanentException("scmData push FAILED, status " + response.getStatus() + "; dropping this item from the queue \n" + response.getBody());
        }
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "scmData for " + jobId + " #" + buildId + ", push SUCCEED : " + response.getBody());
    }

    private void pushSCMDataByEvent(SCMData scmData, String jobId, String buildId) {
        try {
            CIEvent event = ((CIEvent)dtoFactory.newDTO(CIEvent.class)).setEventType(CIEventType.SCM).setProject(jobId).setBuildCiId(buildId).setCauses(this.generateScmCauses()).setNumber(buildId).setScmData(scmData);
            this.eventsService.publishEvent(event);
        }
        catch (Exception e) {
            logger.error("failed to send SCM event for job " + jobId + " build " + buildId, (Throwable)e);
        }
    }

    private List<CIEventCause> generateScmCauses() {
        CIEventCause scmEventCause = (CIEventCause)dtoFactory.newDTO(CIEventCause.class);
        scmEventCause.setType(CIEventCauseType.SCM);
        LinkedHashMap<String, CIEventCause> mapScmEventCause = new LinkedHashMap<String, CIEventCause>();
        mapScmEventCause.put(scmEventCause.generateKey(), scmEventCause);
        return new ArrayList<CIEventCause>(mapScmEventCause.values());
    }

    private String getSCMDataContextPath(String octaneBaseUrl, String sharedSpaceId) {
        return octaneBaseUrl + "/api/shared_spaces/" + sharedSpaceId + "/scm-commits";
    }

    private static final class SCMPushWorkerThreadFactory
    implements ThreadFactory {
        private SCMPushWorkerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread result = new Thread(runnable);
            result.setName("SCMDataPushWorker-" + result.getId());
            result.setDaemon(true);
            return result;
        }
    }
}

