/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.securityscans.SSCProjectConfiguration;
import com.hp.octane.integrations.exceptions.PermanentException;
import com.hp.octane.integrations.exceptions.TemporaryException;
import com.hp.octane.integrations.services.rest.OctaneRestClientImpl;
import com.hp.octane.integrations.services.rest.SSCRestClient;
import com.hp.octane.integrations.services.vulnerabilities.ssc.dto.AuthToken;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

class SSCRestClientImpl
implements SSCRestClient {
    private static final int MAX_TOTAL_CONNECTIONS = 20;
    private final CloseableHttpClient httpClient;
    private AuthToken.AuthTokenData authTokenData;

    SSCRestClientImpl(OctaneSDK.SDKServicesConfigurer configurer) {
        if (configurer == null || configurer.pluginServices == null) {
            throw new IllegalArgumentException("invalid configurer");
        }
        SSLContext sslContext = SSLContexts.createSystemDefault();
        OctaneRestClientImpl.CustomHostnameVerifier hostnameVerifier = new OctaneRestClientImpl.CustomHostnameVerifier();
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connectionManager.setMaxTotal(20);
        connectionManager.setDefaultMaxPerRoute(20);
        HttpClientBuilder clientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager);
        this.httpClient = clientBuilder.build();
    }

    @Override
    public CloseableHttpResponse sendGetRequest(SSCProjectConfiguration sscProjectConfiguration, String url) {
        HttpGet request = new HttpGet(url);
        request.addHeader("Authorization", "FortifyToken " + this.getToken(sscProjectConfiguration, false));
        request.addHeader("Accept", "application/json");
        request.addHeader("Host", this.getNetHost(sscProjectConfiguration.getSSCUrl()));
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 401) {
                request.removeHeaders("Authorization");
                request.addHeader("Authorization", "FortifyToken " + this.getToken(sscProjectConfiguration, true));
                response = this.httpClient.execute((HttpUriRequest)request);
            }
            return response;
        }
        catch (IOException e) {
            throw new TemporaryException(e);
        }
        catch (Exception e) {
            throw new PermanentException(e);
        }
    }

    private String getToken(SSCProjectConfiguration sscProjectConfiguration, boolean forceRenew) {
        if (forceRenew || this.authTokenData == null) {
            this.authTokenData = this.sendReqAuth(sscProjectConfiguration);
        }
        return this.authTokenData.token;
    }

    private AuthToken.AuthTokenData sendReqAuth(SSCProjectConfiguration sscProjectConfiguration) {
        CloseableHttpResponse response;
        block6: {
            AuthToken.AuthTokenData authTokenData;
            block7: {
                String url = sscProjectConfiguration.getSSCUrl() + "/api/v1/tokens";
                HttpPost request = new HttpPost(url);
                request.addHeader("Authorization", sscProjectConfiguration.getSSCBaseAuthToken());
                request.addHeader("Accept", "application/json");
                request.addHeader("Host", this.getNetHost(sscProjectConfiguration.getSSCUrl()));
                request.addHeader("Content-Type", "application/json;charset=UTF-8");
                String body = "{\"type\": \"UnifiedLoginToken\"}";
                response = null;
                ByteArrayEntity entity = new ByteArrayEntity(body.getBytes(StandardCharsets.UTF_8));
                request.setEntity((HttpEntity)entity);
                response = this.httpClient.execute((HttpUriRequest)request);
                if (!this.succeeded(response.getStatusLine().getStatusCode())) break block6;
                String toString = CIPluginSDKUtils.inputStreamToUTF8String(response.getEntity().getContent());
                AuthToken authToken = (AuthToken)new ObjectMapper().readValue(toString, TypeFactory.defaultInstance().constructType(AuthToken.class));
                authTokenData = (AuthToken.AuthTokenData)authToken.getData();
                if (response == null) break block7;
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
            }
            return authTokenData;
        }
        try {
            try {
                throw new PermanentException("Couldn't Authenticate SSC user, need to check SSC configuration in Octane plugin");
            }
            catch (Throwable t) {
                throw new PermanentException(t);
            }
        }
        catch (Throwable throwable) {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                HttpClientUtils.closeQuietly(response);
            }
            throw throwable;
        }
    }

    private String getNetHost(String serverURL) {
        String prefix = "://";
        int indexOfStart = serverURL.toLowerCase().indexOf(prefix) + prefix.length();
        int indexOfEnd = serverURL.lastIndexOf("/");
        if (indexOfEnd < 0 || indexOfEnd <= indexOfStart) {
            return serverURL.substring(indexOfStart);
        }
        return serverURL.substring(indexOfStart, indexOfEnd);
    }

    private boolean succeeded(int statusCode) {
        return statusCode == 200 || statusCode == 201;
    }
}

