/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.rest;

import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.configuration.CIProxyConfiguration;
import com.hp.octane.integrations.services.rest.OctaneRestClient;
import com.hp.octane.integrations.services.rest.OctaneRestClientImpl;
import com.hp.octane.integrations.services.rest.RestService;
import com.hp.octane.integrations.services.rest.SSCRestClient;
import com.hp.octane.integrations.services.rest.SSCRestClientImpl;
import java.net.URL;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class RestServiceImpl
implements RestService {
    private static final Logger logger = LogManager.getLogger(RestServiceImpl.class);
    private final Object DEFAULT_CLIENT_INIT_LOCK = new Object();
    private final Object SSC_CLIENT_INIT_LOCK = new Object();
    private final OctaneSDK.SDKServicesConfigurer configurer;
    private OctaneRestClientImpl defaultClient;
    private SSCRestClient sscRestClient;

    RestServiceImpl(OctaneSDK.SDKServicesConfigurer configurer) {
        if (configurer == null) {
            throw new IllegalArgumentException("invalid configurer");
        }
        this.configurer = configurer;
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "initializing a default Octane REST client");
        this.obtainOctaneRestClient();
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "default Octane REST client is initialized");
    }

    @Override
    public Function<URL, CIProxyConfiguration> getProxySupplier() {
        return this.configurer.pluginServices::getProxyConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OctaneRestClient obtainOctaneRestClient() {
        if (this.defaultClient == null) {
            Object object = this.DEFAULT_CLIENT_INIT_LOCK;
            synchronized (object) {
                if (null == this.defaultClient) {
                    try {
                        this.defaultClient = new OctaneRestClientImpl(this.configurer);
                    }
                    catch (Exception e) {
                        logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "failed to initialize Octane's REST client");
                    }
                }
            }
        }
        return this.defaultClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSCRestClient obtainSSCRestClient() {
        if (this.sscRestClient == null) {
            Object object = this.SSC_CLIENT_INIT_LOCK;
            synchronized (object) {
                if (null == this.sscRestClient) {
                    try {
                        this.sscRestClient = new SSCRestClientImpl(this.configurer);
                    }
                    catch (Exception e) {
                        logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "failed to initialize Octane's REST client");
                    }
                }
            }
        }
        return this.sscRestClient;
    }

    @Override
    public void notifyConfigurationChange() {
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "connectivity configuration change has been notified; publishing to the RestClients");
        if (this.defaultClient != null) {
            this.defaultClient.notifyConfigurationChange();
        } else {
            logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "default client was not yet initialized");
        }
    }
}

