/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.hp.octane.integrations.OctaneConfiguration;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.configuration.CIProxyConfiguration;
import com.hp.octane.integrations.dto.connectivity.HttpMethod;
import com.hp.octane.integrations.dto.connectivity.OctaneRequest;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.services.rest.OctaneRestClient;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class OctaneRestClientImpl
implements OctaneRestClient {
    private static final Logger logger = LogManager.getLogger(OctaneRestClientImpl.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();
    private static final Set<Integer> AUTHENTICATION_ERROR_CODES = Stream.of(Integer.valueOf(401)).collect(Collectors.toSet());
    private static final String LWSSO_COOKIE_NAME = "LWSSO_COOKIE_KEY";
    private static final String AUTHENTICATION_URI = "authentication/sign_in";
    private static final int MAX_TOTAL_CONNECTIONS = 20;
    private final OctaneSDK.SDKServicesConfigurer configurer;
    private final CloseableHttpClient httpClient;
    private final ExecutorService requestMonitorExecutors = Executors.newSingleThreadExecutor(new RequestMonitorExecutorsFactory());
    private long requestMonitorExecutorsAbortedCount = 0L;
    private long lastRequestMonitorWorkerTime = 0L;
    private final Map<HttpUriRequest, Long> ongoingRequests2Started = new HashMap<HttpUriRequest, Long>();
    private final long REQUEST_ABORT_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(120L);
    private final Object REQUESTS_LIST_LOCK = new Object();
    private final Object RESET_LWSSO_TOKEN_LOCK = new Object();
    private boolean shutdownActivated = false;
    private Cookie LWSSO_TOKEN = null;
    private long loginRequiredForRefreshLwssoTokenUntil = 0L;

    OctaneRestClientImpl(OctaneSDK.SDKServicesConfigurer configurer) {
        SSLContext sslContext;
        if (configurer == null) {
            throw new IllegalArgumentException("invalid configurer");
        }
        this.requestMonitorExecutors.execute(this::requestMonitorWorker);
        this.configurer = configurer;
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, this.getTrustManagers(), new SecureRandom());
        }
        catch (Exception e) {
            logger.warn(configurer.octaneConfiguration.getLocationForLog() + "Failed to create sslContext with customTrustManagers. Using systemDefault sslContext. Error : " + e.getMessage());
            sslContext = SSLContexts.createSystemDefault();
        }
        CustomHostnameVerifier hostnameVerifier = new CustomHostnameVerifier();
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connectionManager.setMaxTotal(20);
        connectionManager.setDefaultMaxPerRoute(20);
        HttpClientBuilder clientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager);
        this.httpClient = clientBuilder.build();
    }

    @Override
    public OctaneResponse execute(OctaneRequest request) throws IOException {
        return this.executeRequest(request, this.configurer.octaneConfiguration);
    }

    @Override
    public OctaneResponse execute(OctaneRequest request, OctaneConfiguration configuration) throws IOException {
        return this.executeRequest(request, configuration);
    }

    @Override
    public void shutdown() {
        this.shutdownActivated = true;
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "starting REST client shutdown sequence...");
        this.abortAllRequests();
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "closing the client...");
        HttpClientUtils.closeQuietly((HttpClient)this.httpClient);
        this.requestMonitorExecutors.shutdown();
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "REST client shutdown done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyConfigurationChange() {
        Object object = this.RESET_LWSSO_TOKEN_LOCK;
        synchronized (object) {
            this.loginRequiredForRefreshLwssoTokenUntil = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L);
            this.LWSSO_TOKEN = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortAllRequests() {
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "aborting " + this.ongoingRequests2Started.size() + " request/s...");
        Object object = this.REQUESTS_LIST_LOCK;
        synchronized (object) {
            for (HttpUriRequest request : this.ongoingRequests2Started.keySet()) {
                logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "\taborting " + request);
                request.abort();
            }
            this.LWSSO_TOKEN = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private OctaneResponse executeRequest(OctaneRequest request, OctaneConfiguration configuration) throws IOException {
        OctaneResponse loginResponse;
        HttpUriRequest uriRequest = null;
        CloseableHttpResponse httpResponse = null;
        if (this.LWSSO_TOKEN == null) {
            logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "initial login");
            loginResponse = this.login(configuration);
            if (loginResponse.getStatus() != 200) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "failed on initial login, status " + loginResponse.getStatus());
                return loginResponse;
            }
        }
        try {
            for (int i = 0; i < 2; ++i) {
                uriRequest = this.createHttpRequest(request);
                HttpClientContext context = this.createHttpContext(request.getUrl(), request.getTimeoutSec(), false);
                Object object = this.REQUESTS_LIST_LOCK;
                // MONITORENTER : object
                this.ongoingRequests2Started.put(uriRequest, System.currentTimeMillis());
                // MONITOREXIT : object
                httpResponse = this.httpClient.execute(uriRequest, (HttpContext)context);
                object = this.REQUESTS_LIST_LOCK;
                // MONITORENTER : object
                this.ongoingRequests2Started.remove(uriRequest);
                // MONITOREXIT : object
                if (AUTHENTICATION_ERROR_CODES.contains(httpResponse.getStatusLine().getStatusCode())) {
                    logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "doing RE-LOGIN due to status " + httpResponse.getStatusLine().getStatusCode() + " received while calling " + request.getUrl());
                    EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                    HttpClientUtils.closeQuietly((HttpResponse)httpResponse);
                    loginResponse = this.login(configuration);
                    if (loginResponse.getStatus() != 200) {
                        logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "failed to RE-LOGIN with status " + loginResponse.getStatus() + ", won't attempt the original request anymore");
                        object = loginResponse;
                        if (uriRequest != null && this.ongoingRequests2Started.containsKey(uriRequest)) {
                            Object object2 = this.REQUESTS_LIST_LOCK;
                            // MONITORENTER : object2
                            this.ongoingRequests2Started.remove(uriRequest);
                            // MONITOREXIT : object2
                        }
                        if (httpResponse == null) return object;
                        EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                        HttpClientUtils.closeQuietly((HttpResponse)httpResponse);
                        return object;
                    }
                    logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "re-attempting the original request (" + request.getUrl() + ") having successful RE-LOGIN");
                    continue;
                }
                this.refreshSecurityToken(context, false);
                break;
            }
            OctaneResponse result = this.createNGAResponse(request, (HttpResponse)httpResponse);
            return result;
        }
        catch (IOException ioe) {
            logger.warn(this.configurer.octaneConfiguration.getLocationForLog() + "failed executing " + request, (Throwable)ioe);
            throw ioe;
        }
        finally {
            if (uriRequest != null && this.ongoingRequests2Started.containsKey(uriRequest)) {
                Object object = this.REQUESTS_LIST_LOCK;
            }
            if (httpResponse != null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                HttpClientUtils.closeQuietly(httpResponse);
            }
        }
    }

    private HttpUriRequest createHttpRequest(OctaneRequest octaneRequest) {
        RequestBuilder requestBuilder;
        if (octaneRequest.getMethod().equals((Object)HttpMethod.GET)) {
            requestBuilder = RequestBuilder.get((String)octaneRequest.getUrl());
        } else if (octaneRequest.getMethod().equals((Object)HttpMethod.DELETE)) {
            requestBuilder = RequestBuilder.delete((String)octaneRequest.getUrl());
        } else if (octaneRequest.getMethod().equals((Object)HttpMethod.POST)) {
            requestBuilder = RequestBuilder.post((String)octaneRequest.getUrl());
            requestBuilder.addHeader((Header)new BasicHeader("content-encoding", "gzip"));
            if (octaneRequest.getBody() != null) {
                requestBuilder.setEntity((HttpEntity)new GzipCompressingEntity((HttpEntity)new InputStreamEntity(octaneRequest.getBody(), ContentType.APPLICATION_JSON)));
            }
        } else if (octaneRequest.getMethod().equals((Object)HttpMethod.PUT)) {
            requestBuilder = RequestBuilder.put((String)octaneRequest.getUrl());
            requestBuilder.addHeader((Header)new BasicHeader("content-encoding", "gzip"));
            if (octaneRequest.getBody() != null) {
                requestBuilder.setEntity((HttpEntity)new GzipCompressingEntity((HttpEntity)new InputStreamEntity(octaneRequest.getBody(), ContentType.APPLICATION_JSON)));
            }
        } else {
            throw new RuntimeException("HTTP method " + octaneRequest.getMethod() + " not supported");
        }
        if (octaneRequest.getHeaders() != null) {
            for (Map.Entry e : octaneRequest.getHeaders().entrySet()) {
                requestBuilder.setHeader((String)e.getKey(), (String)e.getValue());
            }
        }
        requestBuilder.setHeader("HPECLIENTTYPE", "HPE_CI_CLIENT");
        HttpUriRequest request = requestBuilder.build();
        return request;
    }

    private HttpClientContext createHttpContext(String requestUrl, int requestTimeoutSec, boolean isLoginRequest) {
        HttpClientContext context = HttpClientContext.create();
        context.setCookieStore((CookieStore)new BasicCookieStore());
        if (!isLoginRequest) {
            context.getCookieStore().addCookie(this.LWSSO_TOKEN);
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setCookieSpec("standard");
        CIProxyConfiguration proxyConfiguration = CIPluginSDKUtils.getProxyConfiguration(requestUrl, this.configurer);
        if (proxyConfiguration != null) {
            logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "proxy will be used with the following setup: " + proxyConfiguration);
            HttpHost proxyHost = new HttpHost(proxyConfiguration.getHost(), proxyConfiguration.getPort().intValue());
            if (proxyConfiguration.getUsername() != null && !proxyConfiguration.getUsername().isEmpty()) {
                AuthScope authScope = new AuthScope(proxyHost);
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyConfiguration.getUsername(), proxyConfiguration.getPassword());
                SystemDefaultCredentialsProvider credentialsProvider = new SystemDefaultCredentialsProvider();
                credentialsProvider.setCredentials(authScope, (Credentials)credentials);
                context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            requestConfigBuilder.setProxy(proxyHost);
        }
        if (requestTimeoutSec > 0) {
            int timeoutMs = requestTimeoutSec * 1000;
            requestConfigBuilder.setConnectTimeout(timeoutMs).setConnectionRequestTimeout(timeoutMs).setSocketTimeout(timeoutMs);
        }
        context.setRequestConfig(requestConfigBuilder.build());
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshSecurityToken(HttpClientContext context, boolean isLogin) {
        for (Cookie cookie : context.getCookieStore().getCookies()) {
            if (!LWSSO_COOKIE_NAME.equals(cookie.getName()) || this.LWSSO_TOKEN != null && cookie.getValue().compareTo(this.LWSSO_TOKEN.getValue()) == 0) continue;
            ((BasicClientCookie)cookie).setPath("/");
            Object object = this.RESET_LWSSO_TOKEN_LOCK;
            synchronized (object) {
                if (!isLogin && this.loginRequiredForRefreshLwssoTokenUntil > System.currentTimeMillis()) {
                    logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "refreshSecurityToken is cancelled");
                } else {
                    this.LWSSO_TOKEN = cookie;
                    logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "successfully refreshed security token.isLogin=" + isLogin);
                }
                break;
            }
        }
    }

    private OctaneResponse createNGAResponse(OctaneRequest request, HttpResponse response) throws IOException {
        OctaneResponse octaneResponse = ((OctaneResponse)dtoFactory.newDTO(OctaneResponse.class)).setStatus(response.getStatusLine().getStatusCode());
        if (response.getEntity() != null) {
            octaneResponse.setBody(CIPluginSDKUtils.inputStreamToUTF8String(response.getEntity().getContent()));
        }
        if (response.getAllHeaders() != null && response.getAllHeaders().length > 0) {
            HashMap<String, String> mapHeaders = new HashMap<String, String>();
            for (Header header : response.getAllHeaders()) {
                mapHeaders.put(header.getName(), header.getValue());
            }
            octaneResponse.setHeaders(mapHeaders);
        }
        if (request != null && request.getHeaders() != null) {
            octaneResponse.setCorrelationId((String)request.getHeaders().get("X-Correlation-ID"));
        }
        return octaneResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OctaneResponse login(OctaneConfiguration config) throws IOException {
        OctaneResponse result;
        CloseableHttpResponse response = null;
        try {
            HttpUriRequest loginRequest = this.buildLoginRequest(config);
            HttpClientContext context = this.createHttpContext(loginRequest.getURI().toString(), 0, true);
            response = this.httpClient.execute(loginRequest, (HttpContext)context);
            if (response.getStatusLine().getStatusCode() == 200) {
                this.refreshSecurityToken(context, true);
            } else {
                logger.warn(this.configurer.octaneConfiguration.getLocationForLog() + "failed to login; response status: " + response.getStatusLine().getStatusCode());
            }
            result = this.createNGAResponse(null, (HttpResponse)response);
            if (response == null) return result;
        }
        catch (IOException ioe) {
            try {
                logger.debug(this.configurer.octaneConfiguration.getLocationForLog() + "failed to login", (Throwable)ioe);
                throw ioe;
            }
            catch (Throwable throwable) {
                if (response == null) throw throwable;
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        HttpClientUtils.closeQuietly((HttpResponse)response);
        return result;
    }

    private HttpUriRequest buildLoginRequest(OctaneConfiguration config) throws IOException {
        try {
            LoginApiBody loginApiBody = new LoginApiBody(config.getClient(), config.getSecret());
            StringEntity loginApiJson = new StringEntity(CIPluginSDKUtils.getObjectMapper().writeValueAsString((Object)loginApiBody), ContentType.APPLICATION_JSON);
            RequestBuilder requestBuilder = RequestBuilder.post((String)(config.getUrl() + "/" + AUTHENTICATION_URI)).setHeader("HPECLIENTTYPE", "HPE_CI_CLIENT").setEntity((HttpEntity)loginApiJson);
            HttpUriRequest loginRequest = requestBuilder.build();
            return loginRequest;
        }
        catch (JsonProcessingException jpe) {
            throw new IOException("failed to serialize login content", jpe);
        }
    }

    private TrustManager[] getTrustManagers() throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init((KeyStore)null);
        TrustManager[] tmArr = tmf.getTrustManagers();
        if (tmArr.length == 1 && tmArr[0] instanceof X509TrustManager) {
            final X509TrustManager defaultTm = (X509TrustManager)tmArr[0];
            X509TrustManager myTM = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return defaultTm.getAcceptedIssuers();
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                    defaultTm.checkClientTrusted(certs, authType);
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                    try {
                        defaultTm.checkServerTrusted(certs, authType);
                    }
                    catch (CertificateException e) {
                        for (X509Certificate cer : certs) {
                            if (cer.getIssuerDN().getName() == null || !cer.getIssuerDN().getName().toLowerCase().contains("microfocus")) continue;
                            return;
                        }
                        throw e;
                    }
                }
            };
            return new TrustManager[]{myTM};
        }
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "Using only default trust managers. Received " + tmArr.length + " trust managers." + (tmArr.length > 0 ? "First one is :" + tmArr[0].getClass().getCanonicalName() : ""));
        return tmArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestMonitorWorker() {
        while (!this.shutdownActivated) {
            this.lastRequestMonitorWorkerTime = System.currentTimeMillis();
            try {
                Object object = this.REQUESTS_LIST_LOCK;
                synchronized (object) {
                    this.ongoingRequests2Started.entrySet().forEach(entry -> {
                        long expectedEnd = (Long)entry.getValue() + this.REQUEST_ABORT_TIMEOUT_MS;
                        long diff = System.currentTimeMillis() - expectedEnd;
                        if (diff > 0L && !((HttpUriRequest)entry.getKey()).isAborted()) {
                            logger.info(this.configurer.octaneConfiguration.getLocationForLog() + " Aborting " + entry.getKey() + " as expected timeout is over ");
                            ((HttpUriRequest)entry.getKey()).abort();
                            ++this.requestMonitorExecutorsAbortedCount;
                        }
                    });
                }
            }
            catch (Exception e) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "requestMonitorWorker error : " + e.getMessage(), (Throwable)e);
            }
            CIPluginSDKUtils.doWait(10000L);
        }
    }

    @Override
    public Map<String, Object> getMetrics() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("requestMonitorExecutorsAbortedCount", this.requestMonitorExecutorsAbortedCount);
        map.put("ongoingRequests.size", this.ongoingRequests2Started.size());
        map.put("lastRequestMonitorWorkerTime", new Date(this.lastRequestMonitorWorkerTime));
        return map;
    }

    private static final class RequestMonitorExecutorsFactory
    implements ThreadFactory {
        private RequestMonitorExecutorsFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread result = new Thread(runnable);
            result.setName("RequestMonitorWorker-" + result.getId());
            result.setDaemon(true);
            return result;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    private static final class LoginApiBody {
        private final String client_id;
        private final String client_secret;

        private LoginApiBody(String client_id, String client_secret) {
            this.client_id = client_id;
            this.client_secret = client_secret;
        }

        public String toString() {
            return "LoginApiBody {client_id: " + this.client_id + ", client_secret: " + this.client_secret + "}";
        }
    }

    public static final class CustomHostnameVerifier
    implements HostnameVerifier {
        private final HostnameVerifier defaultVerifier = new DefaultHostnameVerifier();

        @Override
        public boolean verify(String host, SSLSession sslSession) {
            boolean result = this.defaultVerifier.verify(host, sslSession);
            if (!result) {
                try {
                    Certificate[] ex = sslSession.getPeerCertificates();
                    X509Certificate x509 = (X509Certificate)ex[0];
                    Collection<List<?>> altNames = x509.getSubjectAlternativeNames();
                    for (List<?> namePair : altNames) {
                        if (namePair == null || namePair.size() <= 1 || !(namePair.get(1) instanceof String) || !"*.saas.microfocus.com".equals(namePair.get(1))) continue;
                        result = true;
                        break;
                    }
                }
                catch (CertificateParsingException cpe) {
                    logger.error("failed to parse certificate", (Throwable)cpe);
                }
                catch (SSLException ssle) {
                    logger.error("failed to handle certificate", (Throwable)ssle);
                }
            }
            return result;
        }
    }
}

