/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.queueing;

import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.services.queueing.QueueingService;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import com.squareup.tape.FileObjectQueue;
import com.squareup.tape.InMemoryObjectQueue;
import com.squareup.tape.ObjectQueue;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class QueueingServiceImpl
implements QueueingService {
    private static final Logger logger = LogManager.getLogger(QueueingServiceImpl.class);
    private final File storageDirectory;
    private final List<FileObjectQueue> fileObjectQueues = new LinkedList<FileObjectQueue>();
    private boolean isShutdown;

    QueueingServiceImpl(OctaneSDK.SDKServicesConfigurer configurer) {
        if (configurer == null) {
            throw new IllegalArgumentException("invalid configurer");
        }
        if (configurer.pluginServices.getAllowedOctaneStorage() != null) {
            this.storageDirectory = new File(configurer.pluginServices.getAllowedOctaneStorage(), "nga" + File.separator + configurer.octaneConfiguration.getInstanceId());
            if (!this.storageDirectory.mkdirs()) {
                logger.info(configurer.octaneConfiguration.getLocationForLog() + "storage directories structure assumed to be present");
            }
            logger.info(configurer.octaneConfiguration.getLocationForLog() + "hosting plugin PROVIDE available storage, queues persistence enabled");
        } else {
            this.storageDirectory = null;
            logger.info(configurer.octaneConfiguration.getLocationForLog() + "hosting plugin DO NOT PROVIDE available storage, queues persistence disabled");
        }
    }

    @Override
    public boolean isPersistenceEnabled() {
        return this.storageDirectory != null;
    }

    @Override
    public <T> ObjectQueue<T> initMemoQueue() {
        return new InMemoryObjectQueue();
    }

    @Override
    public <T extends QueueingService.QueueItem> ObjectQueue<T> initFileQueue(String queueFileName, Class<T> targetType) {
        FileObjectQueue result;
        try {
            File queueFile = new File(this.storageDirectory, queueFileName);
            FileObjectQueue tmp = new FileObjectQueue(queueFile, new GenericOctaneQueueItemConverter(targetType));
            this.fileObjectQueues.add(tmp);
            result = tmp;
        }
        catch (Exception e) {
            logger.error("failed to create file based queue, falling back to memory based one", (Throwable)e);
            result = this.initMemoQueue();
        }
        return result;
    }

    @Override
    public void shutdown() {
        this.isShutdown = true;
        this.fileObjectQueues.forEach(fileObjectQueue -> {
            try {
                fileObjectQueue.close();
            }
            catch (Exception e) {
                logger.error("failed to close " + fileObjectQueue, (Throwable)e);
            }
        });
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown;
    }

    private static final class GenericOctaneQueueItemConverter<T>
    implements FileObjectQueue.Converter<T> {
        private final Class<T> targetType;

        private GenericOctaneQueueItemConverter(Class<T> targetType) {
            this.targetType = targetType;
        }

        public T from(byte[] bytes) throws IOException {
            return (T)CIPluginSDKUtils.getObjectMapper().readValue(bytes, this.targetType);
        }

        public void toStream(T t, OutputStream outputStream) throws IOException {
            CIPluginSDKUtils.getObjectMapper().writeValue(outputStream, t);
        }
    }
}

