/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.pullrequestsandbranches.gitlab;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hp.octane.integrations.services.pullrequestsandbranches.gitlab.pojo.Entity;
import com.hp.octane.integrations.services.pullrequestsandbranches.gitlab.pojo.EntityCollection;
import com.hp.octane.integrations.services.pullrequestsandbranches.gitlab.pojo.ErrorDetails;
import com.hp.octane.integrations.services.pullrequestsandbranches.gitlab.pojo.RequestErrors;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonConverter {
    private static final Logger logger = LogManager.getLogger(JsonConverter.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static <T extends Entity> EntityCollection<T> convertCollection(String str, Class<T> entityType) throws JsonProcessingException {
        JavaType type = objectMapper.getTypeFactory().constructParametricType(EntityCollection.class, new Class[]{entityType});
        return (EntityCollection)objectMapper.readValue(str, type);
    }

    public static <T extends Entity> T convert(String str, Class<T> entityType) throws JsonProcessingException {
        return (T)((Entity)objectMapper.readValue(str, entityType));
    }

    public static String getErrorMessage(String jsonString) {
        try {
            RequestErrors requestErrors = (RequestErrors)objectMapper.readValue(jsonString, RequestErrors.class);
            if (!requestErrors.getErrors().isEmpty()) {
                return requestErrors.getErrors().stream().map(ErrorDetails::getMessage).collect(Collectors.joining("; "));
            }
        }
        catch (JsonProcessingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return jsonString;
    }
}

