/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.pullrequestsandbranches.github;

import com.hp.octane.integrations.services.pullrequestsandbranches.github.GithubV3FetchHandler;
import com.hp.octane.integrations.services.pullrequestsandbranches.rest.authentication.AuthenticationStrategy;

public class GithubServerFetchHandler
extends GithubV3FetchHandler {
    public GithubServerFetchHandler(AuthenticationStrategy authenticationStrategy) {
        super(authenticationStrategy);
    }

    @Override
    public String getRepoApiPath(String repoHttpCloneUrl) {
        this.validateHttpCloneUrl(repoHttpCloneUrl);
        if (repoHttpCloneUrl.toLowerCase().startsWith("https://github.com/")) {
            throw new IllegalArgumentException("Supplied repository URL : " + repoHttpCloneUrl + " is Git Cloud URL. Change 'SCM Tool type' to Github Cloud.");
        }
        int repoSlashIndex = repoHttpCloneUrl.lastIndexOf("/");
        int teamSlashIndex = repoHttpCloneUrl.substring(0, repoSlashIndex).lastIndexOf("/");
        String result = repoHttpCloneUrl.substring(0, teamSlashIndex) + "/api/v3/repos" + repoHttpCloneUrl.substring(teamSlashIndex);
        result = result.substring(0, result.length() - ".git".length());
        return result;
    }

    @Override
    public String getApiPath(String repoHttpCloneUrl) {
        int repoSlashIndex = repoHttpCloneUrl.lastIndexOf("/");
        int teamSlashIndex = repoHttpCloneUrl.substring(0, repoSlashIndex).lastIndexOf("/");
        String result = repoHttpCloneUrl.substring(0, teamSlashIndex) + "/api/v3";
        return result;
    }
}

