/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.pullrequestsandbranches.factory;

import com.hp.octane.integrations.utils.SdkStringUtils;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FetchUtils {
    private static String REGEX_PREFIX = "regex:";

    public static List<Pattern> buildPatterns(String patterns) {
        LinkedList<Pattern> compiledPatterns = new LinkedList<Pattern>();
        if (SdkStringUtils.isNotEmpty(patterns)) {
            if (patterns.toLowerCase().startsWith(REGEX_PREFIX)) {
                String pattern = patterns.substring(REGEX_PREFIX.length()).trim();
                if (!pattern.isEmpty()) {
                    compiledPatterns.add(Pattern.compile(pattern));
                }
            } else {
                String[] patternsArr;
                for (String str : patternsArr = patterns.split("[|]")) {
                    String pattern = str.trim();
                    if (pattern.isEmpty()) continue;
                    compiledPatterns.add(Pattern.compile(pattern.replace(".", "\\.").replace("*", ".*"), 2));
                }
            }
        }
        return compiledPatterns;
    }

    public static boolean isBranchMatch(List<Pattern> patterns, String branch) {
        if (patterns.isEmpty()) {
            return true;
        }
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(branch).find()) continue;
            return true;
        }
        return false;
    }

    public static Long convertISO8601DateStringToLong(String dateStr) {
        if (dateStr == null || dateStr.isEmpty()) {
            return null;
        }
        return Instant.parse(dateStr).getEpochSecond() * 1000L;
    }

    public static String convertLongToISO8601DateString(long date) {
        return Instant.ofEpochMilli(date).toString();
    }

    public static String getRepoShortName(String url) {
        String patternStr = "^.*[/:](.*/.*)$";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(url);
        if (matcher.find() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        return url;
    }
}

