/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.pullrequestsandbranches.factory;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.connectivity.HttpMethod;
import com.hp.octane.integrations.dto.connectivity.OctaneRequest;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.scm.Branch;
import com.hp.octane.integrations.dto.scm.PullRequest;
import com.hp.octane.integrations.dto.scm.SCMRepositoryLinks;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.BranchFetchParameters;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.CommitUserIdPicker;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.PullRequestFetchParameters;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.RepoTemplates;
import com.hp.octane.integrations.services.pullrequestsandbranches.rest.GeneralRestClient;
import com.hp.octane.integrations.services.pullrequestsandbranches.rest.authentication.AuthenticationStrategy;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.http.conn.HttpHostConnectException;

public abstract class FetchHandler {
    protected static final DTOFactory dtoFactory = DTOFactory.getInstance();
    protected final GeneralRestClient restClient;

    public FetchHandler(AuthenticationStrategy authenticationStrategy) {
        this.restClient = new GeneralRestClient(authenticationStrategy);
    }

    public abstract List<PullRequest> fetchPullRequests(PullRequestFetchParameters var1, CommitUserIdPicker var2, Consumer<String> var3) throws IOException;

    public abstract List<Branch> fetchBranches(BranchFetchParameters var1, Map<String, Long> var2, Consumer<String> var3) throws IOException;

    public abstract String getRepoApiPath(String var1);

    protected abstract String parseRequestError(OctaneResponse var1);

    public SCMRepositoryLinks pingRepository(String repoApiBaseUrl, Consumer<String> logConsumer) throws IOException {
        OctaneRequest request = ((OctaneRequest)dtoFactory.newDTO(OctaneRequest.class)).setUrl(repoApiBaseUrl).setMethod(HttpMethod.GET);
        try {
            OctaneResponse response = this.restClient.executeRequest(request);
            if (response.getStatus() == 200) {
                logConsumer.accept("Ping repository : Ok");
                return this.parseSCMRepositoryLinks(response.getBody());
            }
            logConsumer.accept("Ping repository : " + response.getStatus() + "; " + this.parseRequestError(response));
            if (response.getStatus() == 404) {
                throw new IllegalArgumentException("Repository not found. Please validate that project/user name and repository name are spelled correctly.");
            }
            if (response.getStatus() == 401) {
                throw new IllegalArgumentException("Unauthorized, validate correctness of credentials.");
            }
            throw new IllegalArgumentException("Unexpected exception");
        }
        catch (HttpHostConnectException e) {
            throw new IOException("Repository is not available. Please validate that URL and proxy settings are set correctly.");
        }
    }

    public abstract SCMRepositoryLinks parseSCMRepositoryLinks(String var1) throws JsonProcessingException;

    protected void validateHttpCloneUrl(String clonePath) {
        if (clonePath == null || clonePath.isEmpty()) {
            throw new IllegalArgumentException("Repo url cannot be empty");
        }
        String clonePathLowerCase = clonePath.toLowerCase();
        String repoSuffix = ".git";
        if (clonePathLowerCase.startsWith("ssh")) {
            throw new IllegalArgumentException("SSH protocol is not supported by this action.");
        }
        if (!clonePath.toLowerCase().startsWith("http")) {
            throw new IllegalArgumentException("Repo url must start with 'http(s)'");
        }
        if (!clonePathLowerCase.endsWith(repoSuffix)) {
            throw new IllegalArgumentException("Repo url must end with '.git'");
        }
    }

    public abstract RepoTemplates buildRepoTemplates(String var1);

    public static String getUserName(CommitUserIdPicker idPicker, String email, String name) {
        if (idPicker != null) {
            return idPicker.getUserIdForCommit(email, name);
        }
        return FetchHandler.getUserName(email, name);
    }

    public static String getUserName(String email, String name) {
        String id;
        String[] emailParts;
        if (email != null && email.contains("@") && (emailParts = email.split("@")).length > 1 && !(id = emailParts[0].trim()).isEmpty()) {
            return id;
        }
        return name;
    }
}

