/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.pullrequestsandbranches.bitbucketserver;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.connectivity.HttpMethod;
import com.hp.octane.integrations.dto.connectivity.OctaneRequest;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.scm.SCMCommit;
import com.hp.octane.integrations.dto.scm.SCMRepository;
import com.hp.octane.integrations.dto.scm.SCMRepositoryLinks;
import com.hp.octane.integrations.dto.scm.SCMType;
import com.hp.octane.integrations.services.pullrequestsandbranches.bitbucketserver.JsonConverter;
import com.hp.octane.integrations.services.pullrequestsandbranches.bitbucketserver.pojo.Branch;
import com.hp.octane.integrations.services.pullrequestsandbranches.bitbucketserver.pojo.BranchMetadataLatestCommit;
import com.hp.octane.integrations.services.pullrequestsandbranches.bitbucketserver.pojo.Commit;
import com.hp.octane.integrations.services.pullrequestsandbranches.bitbucketserver.pojo.Entity;
import com.hp.octane.integrations.services.pullrequestsandbranches.bitbucketserver.pojo.EntityCollection;
import com.hp.octane.integrations.services.pullrequestsandbranches.bitbucketserver.pojo.Link;
import com.hp.octane.integrations.services.pullrequestsandbranches.bitbucketserver.pojo.PullRequest;
import com.hp.octane.integrations.services.pullrequestsandbranches.bitbucketserver.pojo.Ref;
import com.hp.octane.integrations.services.pullrequestsandbranches.bitbucketserver.pojo.Repository;
import com.hp.octane.integrations.services.pullrequestsandbranches.bitbucketserver.pojo.SupportUpdatedTime;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.BranchFetchParameters;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.CommitUserIdPicker;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.FetchHandler;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.FetchUtils;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.PullRequestFetchParameters;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.RepoTemplates;
import com.hp.octane.integrations.services.pullrequestsandbranches.rest.authentication.AuthenticationStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BitbucketServerFetchHandler
extends FetchHandler {
    public BitbucketServerFetchHandler(AuthenticationStrategy authenticationStrategy) {
        super(authenticationStrategy);
    }

    @Override
    public List<com.hp.octane.integrations.dto.scm.PullRequest> fetchPullRequests(PullRequestFetchParameters parameters, CommitUserIdPicker commitUserIdPicker, Consumer<String> logConsumer) throws IOException {
        ArrayList<com.hp.octane.integrations.dto.scm.PullRequest> result = new ArrayList<com.hp.octane.integrations.dto.scm.PullRequest>();
        String baseUrl = this.getRepoApiPath(parameters.getRepoUrl());
        logConsumer.accept("BitbucketServerRestHandler, Base url : " + baseUrl);
        SCMRepositoryLinks links = this.pingRepository(baseUrl, logConsumer);
        parameters.setRepoUrlSsh(links.getSshUrl());
        if (parameters.isUseSSHFormat()) {
            logConsumer.accept("Repo ssh format url : " + parameters.getRepoUrlSsh());
        }
        String pullRequestsUrl = baseUrl + "/pull-requests?state=ALL";
        logConsumer.accept("Pull requests url : " + pullRequestsUrl);
        List<PullRequest> pullRequests = this.getPagedEntities(pullRequestsUrl, PullRequest.class, parameters.getPageSize(), parameters.getMaxPRsToFetch(), parameters.getMinUpdateTime());
        List<Pattern> sourcePatterns = FetchUtils.buildPatterns(parameters.getSourceBranchFilter());
        List<Pattern> targetPatterns = FetchUtils.buildPatterns(parameters.getTargetBranchFilter());
        List filteredPullRequests = pullRequests.stream().filter(pr -> FetchUtils.isBranchMatch(sourcePatterns, pr.getFromRef().getDisplayId()) && FetchUtils.isBranchMatch(targetPatterns, pr.getToRef().getDisplayId())).collect(Collectors.toList());
        logConsumer.accept(String.format("Received %d pull-requests, while %d are matching source/target filters", pullRequests.size(), filteredPullRequests.size()));
        if (!filteredPullRequests.isEmpty()) {
            logConsumer.accept("Fetching commits ...");
            int counter = 0;
            for (PullRequest pr2 : filteredPullRequests) {
                String url = baseUrl + "/pull-requests/" + pr2.getId() + "/commits";
                List<Object> commits = Collections.emptyList();
                try {
                    commits = this.getPagedEntities(url, Commit.class, parameters.getPageSize(), parameters.getMaxCommitsToFetch(), parameters.getMinUpdateTime());
                }
                catch (Exception e) {
                    logConsumer.accept(String.format("Failed to fetch commits for PR %s : %s", pr2.getId(), e.getMessage()));
                }
                ArrayList<SCMCommit> dtoCommits = new ArrayList<SCMCommit>();
                for (Commit commit : commits) {
                    SCMCommit dtoCommit = ((SCMCommit)dtoFactory.newDTO(SCMCommit.class)).setRevId(commit.getId()).setComment(commit.getMessage()).setUser(BitbucketServerFetchHandler.getUserName(commit.getCommitter().getEmailAddress(), commit.getCommitter().getName())).setUserEmail(commit.getCommitter().getEmailAddress()).setTime(Long.valueOf(commit.getCommitterTimestamp())).setParentRevId(commit.getParents().get(0).getId());
                    dtoCommits.add(dtoCommit);
                }
                SCMRepository sourceRepository = this.buildScmRepository(parameters.isUseSSHFormat(), pr2.getFromRef());
                SCMRepository sCMRepository = this.buildScmRepository(parameters.isUseSSHFormat(), pr2.getToRef());
                boolean isMerged = "MERGED".equals(pr2.getState());
                String userId = BitbucketServerFetchHandler.getUserName(commitUserIdPicker, pr2.getAuthor().getUser().getEmailAddress(), pr2.getAuthor().getUser().getName());
                com.hp.octane.integrations.dto.scm.PullRequest dtoPullRequest = ((com.hp.octane.integrations.dto.scm.PullRequest)dtoFactory.newDTO(com.hp.octane.integrations.dto.scm.PullRequest.class)).setId(pr2.getId()).setTitle(pr2.getTitle()).setDescription(pr2.getDescription()).setState(pr2.getState()).setCreatedTime(Long.valueOf(pr2.getCreatedDate())).setUpdatedTime(Long.valueOf(pr2.getUpdatedTime())).setAuthorName(userId).setAuthorEmail(pr2.getAuthor().getUser().getEmailAddress()).setClosedTime(pr2.getClosedDate()).setSelfUrl(pr2.getLinks().getSelf().get(0).getHref()).setSourceRepository(sourceRepository).setTargetRepository(sCMRepository).setCommits(dtoCommits).setMergedTime(isMerged ? pr2.getClosedDate() : null).setIsMerged(isMerged);
                result.add(dtoPullRequest);
                if (counter > 0 && counter % 40 == 0) {
                    logConsumer.accept("Fetching commits " + counter * 100 / filteredPullRequests.size() + "%");
                }
                ++counter;
            }
            logConsumer.accept("Fetching commits is done");
            logConsumer.accept("Pull requests are ready");
        } else {
            logConsumer.accept("No new/updated PR is found.");
        }
        return result;
    }

    @Override
    public List<com.hp.octane.integrations.dto.scm.Branch> fetchBranches(BranchFetchParameters parameters, Map<String, Long> sha2DateMapCache, Consumer<String> logConsumer) throws IOException {
        String baseUrl = this.getRepoApiPath(parameters.getRepoUrl());
        String branchesUrl = baseUrl + "/branches?&details=true&&orderBy=MODIFICATION";
        logConsumer.accept("Branches url : " + branchesUrl);
        List<Branch> branches = this.getPagedEntities(branchesUrl, Branch.class, parameters.getPageSize(), Integer.MAX_VALUE, null);
        List<Pattern> searchPatterns = FetchUtils.buildPatterns(parameters.getFilter());
        List<com.hp.octane.integrations.dto.scm.Branch> filteredBranches = branches.stream().filter(br -> FetchUtils.isBranchMatch(searchPatterns, br.getDisplayId())).map(this::convertToDTOBranch).collect(Collectors.toList());
        logConsumer.accept(String.format("Found %d branches in Bitbucket, while %d are matching filter", branches.size(), filteredBranches.size()));
        if (!filteredBranches.isEmpty()) {
            logConsumer.accept("Fetching branches is done");
        } else {
            logConsumer.accept("No new/updated  branch is found.");
        }
        return filteredBranches;
    }

    private com.hp.octane.integrations.dto.scm.Branch convertToDTOBranch(Branch branch) {
        BranchMetadataLatestCommit latest = branch.getMetadata().getLatestCommit();
        boolean isMerged = branch.getIsDefault() ? true : branch.getMetadata().getAheadBehind().getAhead() == 0L;
        com.hp.octane.integrations.dto.scm.Branch branchDTO = ((com.hp.octane.integrations.dto.scm.Branch)DTOFactory.getInstance().newDTO(com.hp.octane.integrations.dto.scm.Branch.class)).setName(branch.getDisplayId()).setLastCommitSHA(latest.getId()).setLastCommitTime(Long.valueOf(latest.getCommitterTimestamp())).setLastCommiterName(latest.getCommitter().getName()).setLastCommiterEmail(latest.getCommitter().getEmailAddress()).setIsMerged(isMerged);
        return branchDTO;
    }

    private SCMRepository buildScmRepository(boolean useSSHFormat, Ref ref) {
        Stream links = ref.getRepository().getLinks().getClone().stream();
        Optional<Link> optLink = useSSHFormat ? links.filter(l -> l.getName().equalsIgnoreCase("ssh")).findFirst() : links.filter(l -> !l.getName().equalsIgnoreCase("ssh")).findFirst();
        String url = optLink.isPresent() ? optLink.get().getHref() : ref.getRepository().getLinks().getClone().get(0).getHref();
        return ((SCMRepository)dtoFactory.newDTO(SCMRepository.class)).setUrl(url).setBranch(ref.getDisplayId()).setType(SCMType.GIT);
    }

    private <T extends Entity> List<T> getPagedEntities(String url, Class<T> entityType, int pageSize, int maxTotal, Long minUpdateTime) {
        try {
            boolean finished;
            ArrayList<T> result = new ArrayList<T>();
            int limit = pageSize;
            int start = 0;
            do {
                String myUrl = url + (url.contains("?") ? "" : "?") + String.format("&limit=%d&start=%d", limit, start);
                OctaneRequest request = ((OctaneRequest)dtoFactory.newDTO(OctaneRequest.class)).setUrl(myUrl).setMethod(HttpMethod.GET);
                OctaneResponse response = this.restClient.executeRequest(request);
                if (response.getStatus() != 200) {
                    throw new RuntimeException(String.format("Request to '%s' is ended with result %d : %s", myUrl, response.getStatus(), JsonConverter.getErrorMessage(response.getBody())));
                }
                EntityCollection<T> collection = JsonConverter.convertCollection(response.getBody(), entityType);
                result.addAll(collection.getValues());
                finished = collection.isLastPage() || result.size() > maxTotal;
                limit = collection.getLimit();
                start = collection.getStart() + collection.getLimit();
                if (minUpdateTime == null) continue;
                for (int i = result.size() - 1; i >= 0 && ((SupportUpdatedTime)((Object)((Entity)result.get(i)))).getUpdatedTime() <= minUpdateTime; --i) {
                    result.remove(i);
                    finished = true;
                }
            } while (!finished);
            while (result.size() > maxTotal) {
                result.remove(result.size() - 1);
            }
            return result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to getPagedEntities : " + e.getMessage(), e);
        }
    }

    @Override
    public String getRepoApiPath(String repoHttpCloneUrl) {
        this.validateHttpCloneUrl(repoHttpCloneUrl);
        try {
            List<String> parts = Arrays.asList(repoHttpCloneUrl.trim().split("/"));
            int scmIndex = repoHttpCloneUrl.toLowerCase().indexOf("/scm/");
            StringBuilder sb = new StringBuilder();
            sb.append(repoHttpCloneUrl, 0, scmIndex);
            sb.append("/rest/api/1.0");
            String projOrUserPart = parts.get(parts.size() - 2);
            if (projOrUserPart.startsWith("~")) {
                sb.append("/users/");
                sb.append(projOrUserPart.substring(1));
            } else {
                sb.append("/projects/");
                sb.append(projOrUserPart);
            }
            String repoPart = parts.get(parts.size() - 1);
            if (repoPart.toLowerCase().endsWith(".git")) {
                repoPart = repoPart.substring(0, repoPart.length() - 4);
            }
            sb.append("/repos/");
            sb.append(repoPart);
            return sb.toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unexpected bitbucket server repository URL : " + repoHttpCloneUrl + ". Expected formats : http(s)://<bitbucket_server>:<port>/scm/<project_name>/<repository_name>.git or  http(s)://<bitbucket_server>:<port>/scm/~<user_name>/<repository_name>.git");
        }
    }

    private String getSelfUrl(String repoHttpCloneUrl) {
        List<String> parts = Arrays.asList(repoHttpCloneUrl.trim().split("/"));
        int scmIndex = repoHttpCloneUrl.toLowerCase().indexOf("/scm/");
        StringBuilder sb = new StringBuilder();
        sb.append(repoHttpCloneUrl, 0, scmIndex);
        String projOrUserPart = parts.get(parts.size() - 2);
        if (projOrUserPart.startsWith("~")) {
            sb.append("/users/");
            sb.append(projOrUserPart.substring(1));
        } else {
            sb.append("/projects/");
            sb.append(projOrUserPart);
        }
        String repoPart = parts.get(parts.size() - 1);
        if (repoPart.toLowerCase().endsWith(".git")) {
            repoPart = repoPart.substring(0, repoPart.length() - 4);
        }
        sb.append("/repos/");
        sb.append(repoPart);
        return sb.toString();
    }

    @Override
    protected String parseRequestError(OctaneResponse response) {
        return JsonConverter.getErrorMessage(response.getBody());
    }

    @Override
    public SCMRepositoryLinks parseSCMRepositoryLinks(String responseBody) throws JsonProcessingException {
        Repository repo = JsonConverter.convert(responseBody, Repository.class);
        SCMRepositoryLinks links = (SCMRepositoryLinks)dtoFactory.newDTO(SCMRepositoryLinks.class);
        repo.getLinks().getClone().forEach(l -> {
            if ("ssh".equalsIgnoreCase(l.getName())) {
                links.setSshUrl(l.getHref());
            } else {
                links.setHttpUrl(l.getHref());
            }
        });
        return links;
    }

    @Override
    public RepoTemplates buildRepoTemplates(String repoHttpCloneUrl) {
        String selfUrl = this.getSelfUrl(repoHttpCloneUrl);
        RepoTemplates repoTemplates = new RepoTemplates();
        repoTemplates.setDiffTemplate(selfUrl + "/commits/{revision}#{filePath}");
        repoTemplates.setSourceViewTemplate(selfUrl + "/browse/{filePath}?until={revision}&untilPath={filePath}");
        repoTemplates.setBranchFileTemplate(selfUrl + "/browse/{filePath}?at={branchName}");
        return repoTemplates;
    }
}

