/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.pullrequestsandbranches;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.connectivity.HttpMethod;
import com.hp.octane.integrations.dto.connectivity.OctaneRequest;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.entities.Entity;
import com.hp.octane.integrations.dto.scm.Branch;
import com.hp.octane.integrations.dto.scm.PullRequest;
import com.hp.octane.integrations.dto.scm.SCMRepositoryLinks;
import com.hp.octane.integrations.dto.scm.SCMType;
import com.hp.octane.integrations.exceptions.OctaneBulkException;
import com.hp.octane.integrations.exceptions.ResourceNotFoundException;
import com.hp.octane.integrations.services.entities.EntitiesService;
import com.hp.octane.integrations.services.entities.QueryHelper;
import com.hp.octane.integrations.services.pullrequestsandbranches.BranchSyncResult;
import com.hp.octane.integrations.services.pullrequestsandbranches.PullRequestAndBranchService;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.BranchFetchParameters;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.CommitUserIdPicker;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.FetchHandler;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.FetchUtils;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.PullRequestFetchParameters;
import com.hp.octane.integrations.services.pullrequestsandbranches.factory.RepoTemplates;
import com.hp.octane.integrations.services.pullrequestsandbranches.github.GithubV3FetchHandler;
import com.hp.octane.integrations.services.pullrequestsandbranches.gitlab.GitlabServerFetchHandler;
import com.hp.octane.integrations.services.rest.RestService;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import com.hp.octane.integrations.utils.SdkStringUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class PullRequestAndBranchServiceImpl
implements PullRequestAndBranchService {
    private static final Logger logger = LogManager.getLogger(PullRequestAndBranchServiceImpl.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();
    private final OctaneSDK.SDKServicesConfigurer configurer;
    private final RestService restService;
    private final EntitiesService entitiesService;
    private final File persistenceFile;
    private Map<String, PRItem> prItems;
    private static final ObjectMapper objectMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private static final String REMOVE_PREFIX = "origin/";

    PullRequestAndBranchServiceImpl(OctaneSDK.SDKServicesConfigurer configurer, RestService restService, EntitiesService entitiesService) {
        if (configurer == null) {
            throw new IllegalArgumentException("invalid configurer");
        }
        if (restService == null) {
            throw new IllegalArgumentException("rest service MUST NOT be null");
        }
        if (entitiesService == null) {
            throw new IllegalArgumentException("entities service MUST NOT be null");
        }
        this.configurer = configurer;
        this.restService = restService;
        this.entitiesService = entitiesService;
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "initialized SUCCESSFULLY");
        if (configurer.pluginServices.getAllowedOctaneStorage() != null) {
            File storageDirectory = new File(configurer.pluginServices.getAllowedOctaneStorage(), "nga" + File.separator + configurer.octaneConfiguration.getInstanceId());
            if (!storageDirectory.mkdirs()) {
                logger.debug(configurer.octaneConfiguration.getLocationForLog() + "instance folder considered as exist");
            }
            this.persistenceFile = new File(storageDirectory, "pr-fetchers.json");
            logger.info(configurer.octaneConfiguration.getLocationForLog() + "hosting plugin PROVIDE available storage, PR persistence enabled");
            if (this.persistenceFile.exists()) {
                try {
                    CollectionType type = objectMapper.getTypeFactory().constructCollectionType(List.class, PRItem.class);
                    List list = (List)objectMapper.readValue(this.persistenceFile, (JavaType)type);
                    this.prItems = list.stream().collect(Collectors.toMap(PRItem::getKey, Function.identity()));
                }
                catch (IOException e) {
                    logger.info(configurer.octaneConfiguration.getLocationForLog() + "failed to read PR persisted file");
                }
            } else {
                this.prItems = new HashMap<String, PRItem>();
            }
        } else {
            this.persistenceFile = null;
            this.prItems = new HashMap<String, PRItem>();
            logger.info(configurer.octaneConfiguration.getLocationForLog() + "hosting plugin DO NOT PROVIDE available storage, PR persistence disabled");
        }
    }

    @Override
    public void sendPullRequests(List<PullRequest> pullRequests, String workspaceId, PullRequestFetchParameters pullRequestFetchParameters, Consumer<String> logConsumer) throws IOException {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put("content-type", ContentType.APPLICATION_JSON.getMimeType());
        String url = this.configurer.octaneConfiguration.getUrl() + "/api/shared_spaces/" + this.configurer.octaneConfiguration.getSharedSpace() + "/workspaces/" + workspaceId + "/analytics/ci/" + "pull-requests/";
        List<Entity> repositoryRootsList = this.getRepositoryRootsById(pullRequestFetchParameters.getSearchBranchOctaneRootRepositoryId(), Long.valueOf(workspaceId));
        if (!repositoryRootsList.isEmpty()) {
            Entity rootRepoForSearch = repositoryRootsList.get(0);
            String rootRepoURL = rootRepoForSearch.getField("url").toString();
            logConsumer.accept(String.format("Checking branches that already exist in the root repository with the configured id: %s", rootRepoForSearch.getId()));
            Set octaneRepositoryBranches = this.getRepositoryBranches(rootRepoForSearch.getId(), Long.valueOf(workspaceId), false).stream().map(b -> b.getField("name").toString()).collect(Collectors.toSet());
            pullRequests.forEach(pullRequest -> {
                if (octaneRepositoryBranches.contains(pullRequest.getSourceRepository().getBranch())) {
                    pullRequest.getSourceRepository().setUrl(rootRepoURL);
                }
                if (octaneRepositoryBranches.contains(pullRequest.getTargetRepository().getBranch())) {
                    pullRequest.getTargetRepository().setUrl(rootRepoURL);
                }
            });
        }
        int sentCounter = 0;
        List subSets = ListUtils.partition(pullRequests, (int)200);
        for (List list : subSets) {
            String json = dtoFactory.dtoCollectionToJson(list);
            OctaneRequest octaneRequest = ((OctaneRequest)dtoFactory.newDTO(OctaneRequest.class)).setMethod(HttpMethod.PUT).setUrl(url).setHeaders(headers).setBody(json);
            OctaneResponse octaneResponse = this.restService.obtainOctaneRestClient().execute(octaneRequest);
            if (octaneResponse.getStatus() != 200) {
                if (octaneResponse.getStatus() == 404) {
                    throw new ResourceNotFoundException("Failed to sendPullRequests : received 404 status. Validate that you use correct workspace id and ALM Octane version is greater than 15.1.80");
                }
                throw new RuntimeException("Failed to sendPullRequests : (" + octaneResponse.getStatus() + ")" + octaneResponse.getBody());
            }
            logConsumer.accept(String.format("Sent %s/%s pull requests.", sentCounter += list.size(), pullRequests.size()));
        }
        long lastUpdateTime = pullRequests.stream().map(PullRequest::getUpdatedTime).max(Comparator.naturalOrder()).orElse(0L);
        this.savePullRequestLastUpdateTime(workspaceId, pullRequestFetchParameters.getRepoUrl(), lastUpdateTime);
        logConsumer.accept("Last update time set to " + lastUpdateTime);
    }

    @Override
    public long getPullRequestLastUpdateTime(String workspaceId, String repoUrl) {
        String key = PRItem.buildKey(workspaceId, repoUrl);
        PRItem item = this.prItems.get(key);
        return item == null ? 0L : item.getLastUpdated();
    }

    @Override
    public BranchSyncResult syncBranchesToOctane(FetchHandler fetcherHandler, BranchFetchParameters fp, Long workspaceId, CommitUserIdPicker idPicker, Consumer<String> logConsumer) throws IOException {
        BranchSyncResult result;
        block15: {
            String baseUrl = fetcherHandler.getRepoApiPath(fp.getRepoUrl());
            if (!(fetcherHandler instanceof GitlabServerFetchHandler)) {
                logConsumer.accept(fetcherHandler.getClass().getSimpleName() + " handler, Base url : " + baseUrl);
            }
            SCMRepositoryLinks links = fetcherHandler.pingRepository(baseUrl, logConsumer);
            fp.setRepoUrlSsh(links.getSshUrl());
            if (fp.isUseSSHFormat()) {
                logConsumer.accept("Repo ssh format url : " + fp.getRepoUrlSsh());
            }
            String repoUrlForOctane = fp.isUseSSHFormat() ? fp.getRepoUrlSsh() : fp.getRepoUrl();
            boolean supportCaching = fetcherHandler instanceof GithubV3FetchHandler;
            Map<String, Long> sha2DateMapCache = null;
            if (supportCaching) {
                sha2DateMapCache = this.loadBranchCommitsFromCache(repoUrlForOctane, logConsumer);
            }
            List<Object> ciServerBranches = fetcherHandler.fetchBranches(fp, sha2DateMapCache, logConsumer);
            List<Entity> rootRepositoryForSearchList = this.getRepositoryRootsById(fp.getSearchBranchOctaneRootRepositoryId(), workspaceId);
            if (!rootRepositoryForSearchList.isEmpty()) {
                Entity rootRepoForSearch = rootRepositoryForSearchList.get(0);
                logConsumer.accept(String.format("Filtering out the branches that already exist in the root repository with the configured id: %s", rootRepoForSearch.getId()));
                List<Entity> octaneRepositoryBranches = this.getRepositoryBranches(rootRepoForSearch.getId(), workspaceId, false);
                Set octaneBranchesNames = octaneRepositoryBranches.stream().map(b -> b.getField("name").toString()).collect(Collectors.toSet());
                ciServerBranches = ciServerBranches.stream().filter(branch -> !octaneBranchesNames.contains(branch.getName())).collect(Collectors.toList());
            } else {
                logConsumer.accept("The root repository id is not configured or no root repository exists with the configured id in ALM Octane.");
            }
            Map ciServerBranchMap = ciServerBranches.stream().collect(Collectors.toMap(Branch::getName, Function.identity()));
            if (supportCaching) {
                this.saveBranchCommitsToCache(repoUrlForOctane, logConsumer, sha2DateMapCache, ciServerBranches);
            }
            String repoShortName = FetchUtils.getRepoShortName(fp.getRepoUrl());
            ArrayList<Entity> roots = new ArrayList<Entity>(this.getRepositoryRoots(repoUrlForOctane, workspaceId));
            List<Object> octaneBranches = new ArrayList();
            String rootId = "";
            if (!roots.isEmpty()) {
                rootId = ((Entity)roots.get(0)).getId();
                octaneBranches = this.getRepositoryBranches(rootId, workspaceId, false);
                logConsumer.accept("Found repository root with id " + rootId);
            }
            if (octaneBranches == null) {
                octaneBranches = Collections.emptyList();
            }
            List<Pattern> filterPatterns = FetchUtils.buildPatterns(fp.getFilter());
            Map<String, List<Entity>> octaneBranchMap = octaneBranches.stream().filter(br -> FetchUtils.isBranchMatch(filterPatterns, br.getName())).collect(Collectors.groupingBy(b -> b.getName()));
            logConsumer.accept("Found " + octaneBranches.size() + " branches in ALM Octane related to defined filter.");
            result = new BranchSyncResult();
            octaneBranchMap.entrySet().stream().filter(entry -> !ciServerBranchMap.containsKey(entry.getKey())).map(e -> (List)e.getValue()).flatMap(Collection::stream).map(e -> ((Branch)dtoFactory.newDTO(Branch.class)).setOctaneId(e.getId()).setName(e.getName())).forEach(b -> result.getDeleted().add((Branch)b));
            ciServerBranches.forEach(ciBranch -> {
                if (ciBranch.isPartial()) {
                    return;
                }
                List octaneBranchList = (List)octaneBranchMap.get(ciBranch.getName());
                if (octaneBranchList == null) {
                    long diff = System.currentTimeMillis() - ciBranch.getLastCommitTime();
                    long diffDays = TimeUnit.MILLISECONDS.toDays(diff);
                    if (diffDays < (long)fp.getActiveBranchDays()) {
                        result.getCreated().add((Branch)ciBranch);
                    }
                } else {
                    octaneBranchList.forEach(octaneBranch -> {
                        if (!ciBranch.getLastCommitSHA().equals(octaneBranch.getField("last_commit_revision")) || !ciBranch.getIsMerged().equals(octaneBranch.getField("is_merged"))) {
                            ciBranch.setOctaneId(octaneBranch.getId());
                            result.getUpdated().add((Branch)ciBranch);
                        }
                    });
                }
            });
            if (!result.getDeleted().isEmpty()) {
                List<Entity> toDelete = result.getDeleted().stream().map(b -> this.buildOctaneBranchForUpdateAsDeleted((Branch)b)).collect(Collectors.toList());
                this.entitiesService.updateEntities(workspaceId, "scm_repositories", toDelete);
                logConsumer.accept("Deleted branches : " + toDelete.size());
            }
            if (!result.getUpdated().isEmpty()) {
                List<Entity> toUpdate = result.getUpdated().stream().map(b -> this.buildOctaneBranchForUpdate((Branch)b, idPicker)).collect(Collectors.toList());
                this.entitiesService.updateEntities(workspaceId, "scm_repositories", toUpdate);
                logConsumer.accept("Updated branches : " + toUpdate.size());
            }
            if (!result.getCreated().isEmpty()) {
                if (rootId.isEmpty()) {
                    Entity createdRoot = this.createRepositoryRoot(repoUrlForOctane, repoShortName, workspaceId);
                    rootId = createdRoot.getId();
                    logConsumer.accept("Repository root is created with id " + rootId);
                }
                String finalRootId = rootId;
                List<Entity> toCreate = result.getCreated().stream().map(b -> this.buildOctaneBranchForCreate(finalRootId, (Branch)b, idPicker)).collect(Collectors.toList());
                try {
                    this.entitiesService.postEntities(workspaceId, "scm_repositories", toCreate);
                    logConsumer.accept("New branches : " + toCreate.size());
                }
                catch (OctaneBulkException bulkException) {
                    logConsumer.accept(String.format("New branches created: %s, failed to create %s branches", toCreate.size() - bulkException.getData().getErrors().size(), bulkException.getData().getErrors().size()));
                    boolean hasDuplicatedException = bulkException.getData().getErrors().stream().filter(ex -> "platform.duplicate_entity_error".equals(ex.getErrorCode())).findAny().isPresent();
                    Map deletedBranchesInOctane = !hasDuplicatedException ? Collections.emptyMap() : this.getRepositoryBranches(rootId, workspaceId, true).stream().collect(Collectors.toMap(e -> e.getStringValue("name"), Function.identity()));
                    ArrayList<Entity> deletedBranchesToUpdate = new ArrayList<Entity>();
                    bulkException.getData().getErrors().forEach(ex -> {
                        int index = ex.getIndex() == null ? 0 : ex.getIndex();
                        Branch branch = result.getCreated().get(index);
                        if ("platform.duplicate_entity_error".equals(ex.getErrorCode())) {
                            Entity octaneEntity = (Entity)deletedBranchesInOctane.get(branch.getName());
                            if (octaneEntity != null) {
                                branch.setOctaneId(octaneEntity.getId());
                                deletedBranchesToUpdate.add(this.buildOctaneBranchForUpdate(branch, idPicker).setField("is_deleted", (Object)false));
                            } else {
                                logConsumer.accept("Failed to create/update branch : " + branch.getName());
                            }
                        } else {
                            logConsumer.accept(String.format("Failed to create branch %s : %s ", branch.getName(), ex.getDescriptionTranslated()));
                        }
                    });
                    if (deletedBranchesToUpdate.isEmpty()) break block15;
                    this.entitiesService.updateEntities(workspaceId, "scm_repositories", deletedBranchesToUpdate);
                    logConsumer.accept("New branches that appear as deleted in ALM OCtane : " + deletedBranchesToUpdate.size());
                }
            }
        }
        if (result.getDeleted().isEmpty() && result.getUpdated().isEmpty() && result.getCreated().isEmpty()) {
            logConsumer.accept("No changes are found.");
        }
        return result;
    }

    private void saveBranchCommitsToCache(String repoUrlForOctane, Consumer<String> logConsumer, Map<String, Long> sha2DateMapCache, List<Branch> ciServerBranches) {
        HashMap<String, Long> newSha2DateMapCache = new HashMap<String, Long>();
        newSha2DateMapCache.putAll(sha2DateMapCache);
        ciServerBranches.stream().filter(b -> b.getLastCommitTime() != null).forEach(b -> newSha2DateMapCache.put(b.getLastCommitSHA(), b.getLastCommitTime()));
        File cacheFile = this.getFileForBranchCaching(repoUrlForOctane);
        try {
            objectMapper.writerWithDefaultPrettyPrinter().writeValue(cacheFile, newSha2DateMapCache);
            logConsumer.accept(String.format("Cache of commits is saved with %s items ", newSha2DateMapCache.size()));
        }
        catch (Exception e) {
            logConsumer.accept("Failed to  save commit cache : " + e.getMessage());
        }
    }

    private Map<String, Long> loadBranchCommitsFromCache(String repoUrl, Consumer<String> logConsumer) {
        Map sha2DateMapCache = Collections.emptyMap();
        TypeReference<HashMap<String, Long>> typeRef = new TypeReference<HashMap<String, Long>>(){};
        File cacheFile = this.getFileForBranchCaching(repoUrl);
        if (cacheFile.exists()) {
            try {
                sha2DateMapCache = (Map)objectMapper.readValue(cacheFile, (TypeReference)typeRef);
                logConsumer.accept(String.format("Cache of commits is loaded with %s items ", sha2DateMapCache.size()));
            }
            catch (Exception e) {
                logConsumer.accept("Failed to load cache of commits : " + e.getMessage());
            }
        }
        return sha2DateMapCache;
    }

    private File getFileForBranchCaching(String url) {
        String urlReplacement = url.replace(":", "_").replace("/", "_").replaceAll("[<>:\"/\\|?*]", "_");
        String path = this.configurer.pluginServices.getAllowedOctaneStorage() + File.separator + "nga" + File.separator + this.configurer.octaneConfiguration.getInstanceId() + File.separator + "branchCache_" + urlReplacement;
        return new File(path);
    }

    private Entity createRepositoryRoot(String repoUrlForOctane, String repoShortName, Long workspaceId) {
        Entity entity = (Entity)DTOFactory.getInstance().newDTO(Entity.class);
        entity.setType("scm_repository_root");
        entity.setField("url", (Object)repoUrlForOctane);
        entity.setField("name", (Object)repoShortName);
        entity.setField("scm_type", (Object)SCMType.GIT.getOctaneId());
        List<Entity> results = this.entitiesService.postEntities(workspaceId, "scm_repository_roots", Arrays.asList(entity));
        return results.get(0);
    }

    @Override
    public boolean updateRepoTemplates(String repoUrl, Long workspaceId, RepoTemplates repoTemplates) {
        List<Entity> roots = this.getRepositoryRoots(repoUrl, workspaceId);
        int trialCounter = 0;
        while (roots.isEmpty() && trialCounter++ < 6) {
            logger.info(String.format("Wait to updateRepoTemplates - repo %s - %s", repoUrl, trialCounter));
            CIPluginSDKUtils.doWait(5000L);
            roots = this.getRepositoryRoots(repoUrl, workspaceId);
        }
        if (roots.isEmpty()) {
            logger.info(String.format("UpdateRepoTemplates  - repo %s is not found in ALM Octane", repoUrl));
            return false;
        }
        Entity repo = roots.get(0);
        Entity entity = (Entity)DTOFactory.getInstance().newDTO(Entity.class);
        entity.setField("id", (Object)repo.getId());
        boolean needUpdate = false;
        if (SdkStringUtils.isNotEmpty(repoTemplates.getBranchFileTemplate()) && SdkStringUtils.isEmpty(repo.getStringValue("scm_branch_file_link"))) {
            entity.setField("scm_branch_file_link", (Object)repoTemplates.getBranchFileTemplate());
            needUpdate = true;
        }
        if (SdkStringUtils.isNotEmpty(repoTemplates.getDiffTemplate()) && SdkStringUtils.isEmpty(repo.getStringValue("scm_diff"))) {
            entity.setField("scm_diff", (Object)repoTemplates.getDiffTemplate());
            needUpdate = true;
        }
        if (SdkStringUtils.isNotEmpty(repoTemplates.getSourceViewTemplate()) && SdkStringUtils.isEmpty(repo.getStringValue("scm_source_view"))) {
            entity.setField("scm_source_view", (Object)repoTemplates.getSourceViewTemplate());
            needUpdate = true;
        }
        if (needUpdate) {
            this.entitiesService.updateEntities(workspaceId, "scm_repository_roots", Arrays.asList(entity));
        }
        return needUpdate;
    }

    private Entity buildOctaneBranchForUpdateAsDeleted(Branch branch) {
        Entity entity = (Entity)DTOFactory.getInstance().newDTO(Entity.class);
        entity.setType("scm_repository");
        entity.setId(branch.getOctaneId());
        entity.setField("is_deleted", (Object)true);
        return entity;
    }

    private Entity buildOctaneBranchForUpdate(Branch ciBranch, CommitUserIdPicker idPicker) {
        Entity entity = (Entity)DTOFactory.getInstance().newDTO(Entity.class);
        entity.setType("scm_repository");
        if (ciBranch.getOctaneId() != null) {
            entity.setId(ciBranch.getOctaneId());
        }
        entity.setField("is_merged", (Object)ciBranch.getIsMerged());
        entity.setField("last_commit_revision", (Object)ciBranch.getLastCommitSHA());
        entity.setField("last_commit_time", (Object)FetchUtils.convertLongToISO8601DateString(ciBranch.getLastCommitTime()));
        entity.setField("scm_user", (Object)idPicker.getUserIdForCommit(ciBranch.getLastCommiterEmail(), ciBranch.getLastCommiterName()));
        entity.setField("scm_user_email", (Object)ciBranch.getLastCommiterEmail());
        return entity;
    }

    private Entity buildOctaneBranchForCreate(String rootId, Branch ciBranch, CommitUserIdPicker idPicker) {
        Entity parent = (Entity)DTOFactory.getInstance().newDTO(Entity.class);
        parent.setType("scm_repository_root");
        parent.setId(rootId);
        Entity entity = this.buildOctaneBranchForUpdate(ciBranch, idPicker);
        entity.setField("repository", (Object)parent);
        entity.setField("name", (Object)ciBranch.getName());
        return entity;
    }

    private List<Entity> getRepositoryRoots(String repoUrl, Long workspaceId) {
        String rootByUrlCondition = QueryHelper.condition("url", repoUrl);
        List<Entity> foundRoots = this.entitiesService.getEntities(workspaceId, "scm_repository_roots", Collections.singleton(rootByUrlCondition), Arrays.asList("id", "scm_branch_file_link", "scm_diff", "scm_source_view"));
        return foundRoots;
    }

    private List<Entity> getRepositoryRootsById(Integer id, Long workspaceId) {
        String rootByUrlCondition = QueryHelper.condition("id", id);
        List<Entity> foundRoots = this.entitiesService.getEntities(workspaceId, "scm_repository_roots", Collections.singleton(rootByUrlCondition), Arrays.asList("id", "scm_branch_file_link", "scm_diff", "scm_source_view", "name", "url"));
        return foundRoots;
    }

    private List<Entity> getRepositoryBranches(String repositoryRootId, Long workspaceId, boolean deleted) {
        String byParentIdCondition = QueryHelper.conditionRef("repository", Long.parseLong(repositoryRootId));
        String notDeletedCondition = QueryHelper.condition("is_deleted", deleted);
        List<Entity> foundBranches = this.entitiesService.getEntities(workspaceId, "scm_repositories", Arrays.asList(byParentIdCondition, notDeletedCondition), Arrays.asList("name", "is_merged", "last_commit_revision", "last_commit_time"));
        return foundBranches;
    }

    private synchronized void savePullRequestLastUpdateTime(String workspaceId, String repoUrl, long lastUpdateTime) {
        PRItem item = PRItem.create(workspaceId, repoUrl, lastUpdateTime);
        this.prItems.put(item.getKey(), item);
        if (this.persistenceFile != null) {
            try {
                objectMapper.writeValue(this.persistenceFile, this.prItems.values());
            }
            catch (IOException e) {
                logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "failed to save PR persisted file");
            }
        }
    }

    public static class PRItem
    implements Serializable {
        private String workspace;
        private String repositoryUrl;
        private long lastUpdated;

        public static PRItem create(String workspace, String repositoryUrl, long lastUpdated) {
            PRItem item = new PRItem();
            item.workspace = workspace;
            item.repositoryUrl = repositoryUrl;
            item.lastUpdated = lastUpdated;
            return item;
        }

        @JsonIgnore
        public String getKey() {
            return PRItem.buildKey(this.getWorkspace(), this.getRepositoryUrl());
        }

        public static String buildKey(String workspace, String repositoryUrl) {
            return workspace + "_" + repositoryUrl;
        }

        public String getWorkspace() {
            return this.workspace;
        }

        public String getRepositoryUrl() {
            return this.repositoryUrl;
        }

        public long getLastUpdated() {
            return this.lastUpdated;
        }
    }
}

