/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.logging;

import com.hp.octane.integrations.services.logging.LoggingServiceImpl;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;

public class CommonLoggerContextUtil {
    private static final Object INIT_LOCKER = new Object();
    private static LoggerContext commonLoggerContext;
    private static final String OCTANE_ALLOWED_STORAGE_LOCATION = "octaneAllowedStorage";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoggerContext configureLogger(File allowedStorage) {
        if (allowedStorage != null && (allowedStorage.isDirectory() || !allowedStorage.exists())) {
            Object object = INIT_LOCKER;
            synchronized (object) {
                URL path;
                if (commonLoggerContext != null) {
                    if (!commonLoggerContext.isStarted()) {
                        commonLoggerContext.start();
                    }
                    return commonLoggerContext;
                }
                commonLoggerContext = LoggerContext.getContext((boolean)false);
                if (!commonLoggerContext.isStarted()) {
                    commonLoggerContext.start();
                }
                System.setProperty(OCTANE_ALLOWED_STORAGE_LOCATION, allowedStorage.getAbsolutePath() + File.separator);
                if (!(commonLoggerContext.getConfiguration() != null && commonLoggerContext.getConfiguration() instanceof XmlConfiguration || (path = LoggingServiceImpl.class.getClassLoader().getResource("log4j2.xml")) == null)) {
                    try {
                        commonLoggerContext.setConfigLocation(path.toURI());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
                commonLoggerContext.reconfigure();
            }
        }
        return commonLoggerContext;
    }
}

