/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.events;

import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOBase;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.connectivity.HttpMethod;
import com.hp.octane.integrations.dto.connectivity.OctaneRequest;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.events.CIEvent;
import com.hp.octane.integrations.dto.events.CIEventType;
import com.hp.octane.integrations.dto.events.CIEventsList;
import com.hp.octane.integrations.dto.events.MultiBranchType;
import com.hp.octane.integrations.dto.general.CIServerInfo;
import com.hp.octane.integrations.exceptions.PermanentException;
import com.hp.octane.integrations.exceptions.RequestTimeoutException;
import com.hp.octane.integrations.exceptions.TemporaryException;
import com.hp.octane.integrations.services.WorkerPreflight;
import com.hp.octane.integrations.services.configuration.ConfigurationService;
import com.hp.octane.integrations.services.configurationparameters.factory.ConfigurationParameterFactory;
import com.hp.octane.integrations.services.events.EventsService;
import com.hp.octane.integrations.services.rest.RestService;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

final class EventsServiceImpl
implements EventsService {
    private static final Logger logger = LogManager.getLogger(EventsServiceImpl.class);
    Marker eventsMarker = MarkerManager.getMarker((String)"EVENTS");
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();
    private final ExecutorService eventsPushExecutor = Executors.newSingleThreadExecutor(new EventsServiceWorkerThreadFactory());
    private final OctaneSDK.SDKServicesConfigurer configurer;
    private final RestService restService;
    private final ConfigurationService configurationService;
    private final List<CIEvent> events = Collections.synchronizedList(new LinkedList());
    private final int EVENTS_CHUNK_SIZE = System.getProperty("octane.sdk.events.chunk-size") != null ? Integer.parseInt(System.getProperty("octane.sdk.events.chunk-size")) : 10;
    private final int MAX_EVENTS_TO_KEEP = System.getProperty("octane.sdk.events.max-to-keep") != null ? Integer.parseInt(System.getProperty("octane.sdk.events.max-to-keep")) : 3000;
    private final long TEMPORARY_FAILURE_PAUSE = System.getProperty("octane.sdk.events.temp-fail-pause") != null ? (long)Integer.parseInt(System.getProperty("octane.sdk.events.temp-fail-pause")) : 15000L;
    private long requestTimeoutCount = 0L;
    private long lastRequestTimeoutTime = 0L;
    private final WorkerPreflight workerPreflight;

    EventsServiceImpl(OctaneSDK.SDKServicesConfigurer configurer, RestService restService, ConfigurationService configurationService) {
        if (configurer == null || configurer.pluginServices == null || configurer.octaneConfiguration == null) {
            throw new IllegalArgumentException("invalid configurer");
        }
        if (restService == null) {
            throw new IllegalArgumentException("rest service MUST NOT be null");
        }
        if (configurationService == null) {
            throw new IllegalArgumentException("configuration service MUST NOT be null");
        }
        this.configurer = configurer;
        this.restService = restService;
        this.configurationService = configurationService;
        this.workerPreflight = new WorkerPreflight(this, configurationService, logger);
        this.workerPreflight.setWaitAfterConnection(false);
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "starting background worker...");
        this.eventsPushExecutor.execute(this::worker);
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "initialized SUCCESSFULLY");
    }

    @Override
    public void publishEvent(CIEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("event MUST NOT be null");
        }
        if (this.configurer.octaneConfiguration.isDisabled()) {
            return;
        }
        if (ConfigurationParameterFactory.octaneRootsCacheAllowed(this.configurer.octaneConfiguration)) {
            HashSet<String> parents = new HashSet<String>();
            CIPluginSDKUtils.getRootJobCiIds(event.getProject(), event.getCauses(), parents);
            if (!this.configurationService.isRelevantForOctane(parents)) {
                if (CIEventType.STARTED.equals((Object)event.getEventType())) {
                    String eventStr = event.getProject() + ":" + event.getBuildCiId() + ":" + event.getEventType() + ", parents : " + parents;
                    logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "Event is ignored : " + eventStr);
                }
                return;
            }
        }
        this.events.add(event);
        int eventsSize = this.events.size();
        if (eventsSize > this.MAX_EVENTS_TO_KEEP) {
            logger.warn(this.configurer.octaneConfiguration.getLocationForLog() + "reached MAX amount of events to keep in queue (max - " + this.MAX_EVENTS_TO_KEEP + ", found - " + eventsSize + "), capping the head");
            while (this.events.size() > this.MAX_EVENTS_TO_KEEP) {
                this.events.remove(0);
            }
        }
        this.workerPreflight.itemAddedToQueue();
    }

    @Override
    public long getQueueSize() {
        return this.events.size();
    }

    @Override
    public void clearQueue() {
        this.events.clear();
    }

    @Override
    public void shutdown() {
        this.eventsPushExecutor.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.eventsPushExecutor.isShutdown();
    }

    private void removeEvents(List<CIEvent> eventsToRemove) {
        if (eventsToRemove != null && !eventsToRemove.isEmpty()) {
            this.events.removeAll(eventsToRemove);
        }
    }

    private void worker() {
        while (!this.eventsPushExecutor.isShutdown()) {
            CIEventsList eventsSnapshot;
            if (!this.workerPreflight.preflight()) continue;
            List<CIEvent> eventsChunk = null;
            try {
                eventsChunk = this.getEventsChunk();
                CIServerInfo serverInfo = this.configurer.pluginServices.getServerInfo();
                serverInfo.setInstanceId(this.configurer.octaneConfiguration.getInstanceId());
                eventsSnapshot = ((CIEventsList)dtoFactory.newDTO(CIEventsList.class)).setServer(serverInfo).setEvents(eventsChunk);
            }
            catch (Throwable t) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "failed to serialize chunk of " + (eventsChunk != null ? Integer.valueOf(eventsChunk.size()) : "[NULL]") + " events, dropping them off (if any) and continue");
                this.removeEvents(eventsChunk);
                continue;
            }
            try {
                String correlationId = CIPluginSDKUtils.getNextCorrelationId();
                this.logEventsToBeSent(eventsSnapshot, correlationId);
                this.sendEventsData(eventsSnapshot, correlationId);
                this.removeEvents(eventsChunk);
                if (this.events.size() <= 0) continue;
                logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "left to send " + this.events.size() + " events");
            }
            catch (RequestTimeoutException rte) {
                ++this.requestTimeoutCount;
                this.lastRequestTimeoutTime = System.currentTimeMillis();
                logger.info(this.configurer.octaneConfiguration.getLocationForLog() + rte.getMessage());
                CIPluginSDKUtils.doWait(this.TEMPORARY_FAILURE_PAUSE);
            }
            catch (TemporaryException tqie) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "failed to send events with temporary error, breathing " + this.TEMPORARY_FAILURE_PAUSE + "ms and continue", (Throwable)tqie);
                CIPluginSDKUtils.doWait(this.TEMPORARY_FAILURE_PAUSE);
            }
            catch (PermanentException pqie) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "failed to send events with permanent error, dropping this chunk and continue", (Throwable)pqie);
                this.removeEvents(eventsChunk);
            }
            catch (Throwable t) {
                logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "failed to send events with unexpected error, dropping this chunk and continue", t);
                this.removeEvents(eventsChunk);
            }
        }
    }

    private List<CIEvent> getEventsChunk() {
        int maxInBulk = ConfigurationParameterFactory.isSendEventsInBulk(this.configurer.octaneConfiguration) ? this.EVENTS_CHUNK_SIZE : 1;
        ArrayList<Object> eventsChunk = new ArrayList<CIEvent>(this.events.subList(0, Math.min(this.events.size(), maxInBulk)));
        if (eventsChunk.size() > 1) {
            for (int i = 0; i < eventsChunk.size(); ++i) {
                CIEvent ciEvent = (CIEvent)eventsChunk.get(i);
                if (!CIEventType.STARTED.equals((Object)ciEvent.getEventType()) || !MultiBranchType.MULTI_BRANCH_CHILD.equals((Object)ciEvent.getMultiBranchType()) || i + 1 >= eventsChunk.size()) continue;
                eventsChunk = new ArrayList(eventsChunk.subList(0, i + 1));
                break;
            }
        }
        return eventsChunk;
    }

    private void logEventsToBeSent(CIEventsList eventsList, String correlationId) {
        try {
            String str;
            LinkedList<String> eventsStringified = new LinkedList<String>();
            for (CIEvent event : eventsList.getEvents()) {
                str = event.getProject() + ":" + event.getBuildCiId() + ":" + event.getEventType();
                if (CIEventType.FINISHED.equals((Object)event.getEventType()) && event.getTestResultExpected() != null && event.getTestResultExpected().booleanValue()) {
                    str = str + "(tests=true)";
                }
                eventsStringified.add(str);
            }
            logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "sending [" + String.join((CharSequence)", ", eventsStringified) + "] event/s. Correlation ID - " + correlationId);
            if (ConfigurationParameterFactory.isLogEvents(this.configurer.octaneConfiguration)) {
                for (CIEvent event : eventsList.getEvents()) {
                    str = String.format("%s%s:%s:%s %s", this.configurer.octaneConfiguration.getLocationForLog(), event.getProject(), event.getBuildCiId(), event.getEventType(), dtoFactory.dtoToJson((DTOBase)event));
                    logger.info(this.eventsMarker, str);
                }
            }
        }
        catch (Exception e) {
            logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "failed to log events to be sent", (Throwable)e);
        }
    }

    private void sendEventsData(CIEventsList eventsList, String correlationId) {
        OctaneResponse octaneResponse;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", ContentType.APPLICATION_JSON.getMimeType());
        headers.put("X-Correlation-ID", correlationId);
        OctaneRequest octaneRequest = ((OctaneRequest)dtoFactory.newDTO(OctaneRequest.class)).setMethod(HttpMethod.PUT).setUrl(this.configurer.octaneConfiguration.getUrl() + "/internal-api/shared_spaces/" + this.configurer.octaneConfiguration.getSharedSpace() + "/analytics/ci/" + "events?ci_server_identity=" + this.configurer.octaneConfiguration.getInstanceId()).setHeaders(headers).setTimeoutSec(60).setBody(dtoFactory.dtoToJsonStream((DTOBase)eventsList));
        try {
            octaneResponse = this.restService.obtainOctaneRestClient().execute(octaneRequest);
        }
        catch (InterruptedIOException ie) {
            String msg = "!!!!!!!!!!!!!!!!!!! request timeout" + ie.getClass().getCanonicalName() + " - " + ie.getMessage();
            throw new RequestTimeoutException(msg);
        }
        catch (IOException ioe) {
            throw new TemporaryException(ioe);
        }
        if (octaneResponse.getStatus() == 503 || octaneResponse.getStatus() == 502 || octaneResponse.getStatus() == 429) {
            throw new TemporaryException("PUT events failed with status " + octaneResponse.getStatus());
        }
        if (octaneResponse.getStatus() == 401 || octaneResponse.getStatus() == 403) {
            CIPluginSDKUtils.doWait(30000L);
            throw new PermanentException("PUT events failed with status " + octaneResponse.getStatus());
        }
        if (octaneResponse.getStatus() != 200) {
            if (CIPluginSDKUtils.isServiceTemporaryUnavailable(octaneResponse.getBody())) {
                throw new TemporaryException("Saas service is temporary unavailable.");
            }
            throw new PermanentException("PUT events failed with status " + octaneResponse.getStatus());
        }
    }

    @Override
    public Map<String, Object> getMetrics() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("queueSize", this.getQueueSize());
        map.put("requestTimeoutCount", this.requestTimeoutCount);
        if (this.lastRequestTimeoutTime > 0L) {
            map.put("lastRequestTimeoutTime", new Date(this.lastRequestTimeoutTime));
        }
        this.workerPreflight.addMetrics(map);
        return map;
    }

    private static final class EventsServiceWorkerThreadFactory
    implements ThreadFactory {
        private EventsServiceWorkerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread result = new Thread(runnable);
            result.setName("EventsServiceWorker-" + result.getId());
            result.setDaemon(true);
            return result;
        }
    }
}

