/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.configurationparameters.factory;

import com.hp.octane.integrations.OctaneConfiguration;
import com.hp.octane.integrations.services.configurationparameters.AddGlobalParameterToTestsParameter;
import com.hp.octane.integrations.services.configurationparameters.EncodeCiJobBase64Parameter;
import com.hp.octane.integrations.services.configurationparameters.FortifySSCFetchTimeoutParameter;
import com.hp.octane.integrations.services.configurationparameters.FortifySSCTokenParameter;
import com.hp.octane.integrations.services.configurationparameters.JobListCacheAllowedParameter;
import com.hp.octane.integrations.services.configurationparameters.LogEventsParameter;
import com.hp.octane.integrations.services.configurationparameters.OctaneRootsCacheAllowedParameter;
import com.hp.octane.integrations.services.configurationparameters.SCMRestAPIParameter;
import com.hp.octane.integrations.services.configurationparameters.SendEventsInBulkParameter;
import com.hp.octane.integrations.services.configurationparameters.UftTestConnectionDisabledParameter;
import com.hp.octane.integrations.services.configurationparameters.UftTestRunnerFolderParameter;
import com.hp.octane.integrations.services.configurationparameters.UftTestsDeepRenameParameter;
import com.hp.octane.integrations.services.configurationparameters.factory.ConfigurationParameter;
import java.util.NoSuchElementException;

public class ConfigurationParameterFactory {
    public static ConfigurationParameter tryCreate(String paramKey, String paramValue) {
        switch (paramKey) {
            case "ENCODE_CI_JOB_BASE64": {
                return EncodeCiJobBase64Parameter.create(paramValue);
            }
            case "UFT_TEST_RUNNER_FOLDER": {
                return UftTestRunnerFolderParameter.create(paramValue);
            }
            case "UFT_TEST_CONNECTION_DISABLED": {
                return UftTestConnectionDisabledParameter.create(paramValue);
            }
            case "SCM_REST_API": {
                return SCMRestAPIParameter.create(paramValue);
            }
            case "FORTIFY_SSC_TOKEN": {
                return FortifySSCTokenParameter.create(paramValue);
            }
            case "FORTIFY_SSC_FETCH_TIMEOUT": {
                return FortifySSCFetchTimeoutParameter.create(paramValue);
            }
            case "SEND_EVENTS_IN_BULK": {
                return SendEventsInBulkParameter.create(paramValue);
            }
            case "UFT_TESTS_DEEP_RENAME_CHECK": {
                return UftTestsDeepRenameParameter.create(paramValue);
            }
            case "LOG_EVENTS": {
                return LogEventsParameter.create(paramValue);
            }
            case "JOB_LIST_CACHE_ALLOWED": {
                return JobListCacheAllowedParameter.create(paramValue);
            }
            case "OCTANE_ROOTS_CACHE_ALLOWED": {
                return OctaneRootsCacheAllowedParameter.create(paramValue);
            }
            case "ADD_GLOBAL_PARAMETERS_TO_TESTS": {
                return AddGlobalParameterToTestsParameter.create(paramValue);
            }
        }
        throw new NoSuchElementException("Unknown parameter : " + paramKey);
    }

    public static void addParameter(OctaneConfiguration conf, String paramKey, String paramValue) {
        try {
            ConfigurationParameter param = ConfigurationParameterFactory.tryCreate(paramKey, paramValue);
            conf.addParameter(param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isEncodeCiJobBase64(OctaneConfiguration configuration) {
        EncodeCiJobBase64Parameter encodeCiJobBase64 = (EncodeCiJobBase64Parameter)configuration.getParameter("ENCODE_CI_JOB_BASE64");
        if (encodeCiJobBase64 != null) {
            return encodeCiJobBase64.isEncoded();
        }
        return true;
    }

    public static boolean isSCMRestAPI(OctaneConfiguration configuration) {
        SCMRestAPIParameter scmRestAPIParameter = (SCMRestAPIParameter)configuration.getParameter("SCM_REST_API");
        if (scmRestAPIParameter != null) {
            return scmRestAPIParameter.isSCMRestAPI();
        }
        return true;
    }

    public static boolean isSendEventsInBulk(OctaneConfiguration configuration) {
        SendEventsInBulkParameter param = (SendEventsInBulkParameter)configuration.getParameter("SEND_EVENTS_IN_BULK");
        if (param != null) {
            return param.isBulk();
        }
        return true;
    }

    public static boolean isUftTestsDeepRenameCheckEnabled(OctaneConfiguration configuration) {
        UftTestsDeepRenameParameter param = (UftTestsDeepRenameParameter)configuration.getParameter("UFT_TESTS_DEEP_RENAME_CHECK");
        if (param != null) {
            return param.isUftTestsDeepRenameCheckEnabled();
        }
        return true;
    }

    public static boolean isLogEvents(OctaneConfiguration configuration) {
        LogEventsParameter param = (LogEventsParameter)configuration.getParameter("LOG_EVENTS");
        if (param != null) {
            return param.isLogEvents();
        }
        return false;
    }

    public static boolean isUftTestConnectionDisabled(OctaneConfiguration configuration) {
        UftTestConnectionDisabledParameter param = (UftTestConnectionDisabledParameter)configuration.getParameter("UFT_TEST_CONNECTION_DISABLED");
        if (param != null) {
            return param.isDisabled();
        }
        return false;
    }

    public static boolean jobListCacheAllowed(OctaneConfiguration configuration) {
        JobListCacheAllowedParameter param = (JobListCacheAllowedParameter)configuration.getParameter("JOB_LIST_CACHE_ALLOWED");
        if (param != null) {
            return param.isAllowed();
        }
        return false;
    }

    public static boolean octaneRootsCacheAllowed(OctaneConfiguration configuration) {
        OctaneRootsCacheAllowedParameter param = (OctaneRootsCacheAllowedParameter)configuration.getParameter("OCTANE_ROOTS_CACHE_ALLOWED");
        if (param != null) {
            return param.isAllowed();
        }
        return true;
    }

    public static boolean addGlobalParametersToTests(OctaneConfiguration configuration) {
        AddGlobalParameterToTestsParameter param = (AddGlobalParameterToTestsParameter)configuration.getParameter("ADD_GLOBAL_PARAMETERS_TO_TESTS");
        if (param != null) {
            return param.isToAdd();
        }
        return false;
    }

    public static Boolean validateBooleanValue(String rawValue, String key) {
        if (rawValue == null) {
            throw new IllegalArgumentException("Parameter " + key + " : Expected boolean value (true/false)");
        }
        if (!rawValue.equalsIgnoreCase("true") && !rawValue.equalsIgnoreCase("false")) {
            throw new IllegalArgumentException("Parameter " + key + " : Expected boolean value (true/false)");
        }
        return Boolean.parseBoolean(rawValue);
    }
}

