/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services;

import com.hp.octane.integrations.services.HasQueueService;
import com.hp.octane.integrations.services.configuration.ConfigurationService;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import java.util.Date;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class WorkerPreflight {
    private static final int QUEUE_EMPTY_INTERVAL = 10000;
    private static final int REGULAR_CYCLE_PAUSE = 400;
    private static final int NO_CONNECTION_PAUSE = 30000;
    private static final int AFTER_RECONNECTION_PAUSE = 90000;
    private final Object EMPTY_QUEUE_MONITOR = new Object();
    private ConfigurationService confService;
    private HasQueueService service;
    private Logger logger;
    private boolean previousIterationWasNotConnected;
    private long lastIterationTime = 0L;
    private boolean waitAfterConnected = true;

    public WorkerPreflight(HasQueueService service, ConfigurationService confService, Logger logger) {
        this.service = service;
        this.logger = logger;
        this.confService = confService;
    }

    public boolean preflight() {
        this.lastIterationTime = System.currentTimeMillis();
        CIPluginSDKUtils.doWait(400L);
        if (this.service.getQueueSize() == 0L) {
            CIPluginSDKUtils.doBreakableWait(10000L, this.EMPTY_QUEUE_MONITOR);
            return false;
        }
        if (this.confService.getConfiguration().isDisabled()) {
            this.logger.error(this.confService.getConfiguration().getLocationForLog() + "client is disabled, removing " + this.service.getQueueSize() + " items from queue");
            this.service.clearQueue();
            return false;
        }
        if (!this.confService.isConnected()) {
            CIPluginSDKUtils.doWait(30000L);
            this.previousIterationWasNotConnected = true;
            return false;
        }
        if (this.previousIterationWasNotConnected && this.waitAfterConnected) {
            this.logger.warn(this.confService.getConfiguration().getLocationForLog() + "client is connected now. Giving time to events to be sent.");
            CIPluginSDKUtils.doWait(90000L);
            this.previousIterationWasNotConnected = false;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemAddedToQueue() {
        Object object = this.EMPTY_QUEUE_MONITOR;
        synchronized (object) {
            this.EMPTY_QUEUE_MONITOR.notify();
        }
    }

    public void addMetrics(Map<String, Object> metricsMap) {
        metricsMap.put("lastIterationTime", new Date(this.lastIterationTime));
    }

    public void setWaitAfterConnection(boolean waitAfterConnected) {
        this.waitAfterConnected = waitAfterConnected;
    }
}

