/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.executor.converters;

import com.hp.octane.integrations.OctaneClient;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.executor.TestToRunData;
import com.hp.octane.integrations.executor.TestsToRunConverter;
import com.hp.octane.integrations.services.configurationparameters.factory.ConfigurationParameterFactory;
import com.hp.octane.integrations.utils.SdkStringUtils;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MfUftConverter
extends TestsToRunConverter {
    private static final Logger logger = LogManager.getLogger(MfUftConverter.class);
    public static final String DATA_TABLE_PARAMETER = "dataTable";
    public static final String ITERATIONS_PARAMETER = "iterations";
    public static final String TESTING_TOOL_TYPE_PARAMETER = "testingToolType";
    public static final String MBT_DATA = "mbtData";
    public static final String INNER_RUN_ID_PARAMETER = "runId";

    @Override
    public String convertInternal(List<TestToRunData> data, String executionDirectory, Map<String, String> globalParameters) {
        String myWorkingDir = executionDirectory;
        return this.convertToMtbxContent(data, myWorkingDir, globalParameters);
    }

    public String convertToMtbxContent(List<TestToRunData> tests, String workingDir, Map<String, String> globalParameters) {
        if (CollectionUtils.isEmpty(tests = tests.stream().filter(testToRunData -> testToRunData.getParameter(TESTING_TOOL_TYPE_PARAMETER) == null).collect(Collectors.toList()))) {
            return "";
        }
        boolean addGlobalParameters = this.isAddGlobalParameters(globalParameters);
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("Mtbx");
            doc.appendChild(rootElement);
            for (TestToRunData test : tests) {
                String iterations;
                String dataTable;
                Element testElement = doc.createElement("Test");
                String packageAndTestName = (SdkStringUtils.isNotEmpty(test.getPackageName()) ? test.getPackageName() + "\\" : "") + test.getTestName();
                testElement.setAttribute("name", packageAndTestName);
                String path = workingDir + (SdkStringUtils.isEmpty(test.getPackageName()) ? "" : "\\" + test.getPackageName()) + "\\" + test.getTestName();
                testElement.setAttribute("path", path);
                test.getParameters().forEach((paramKey, paramValue) -> {
                    if (!(DATA_TABLE_PARAMETER.equals(paramKey) || ITERATIONS_PARAMETER.equals(paramKey) || MBT_DATA.equals(paramKey))) {
                        if (INNER_RUN_ID_PARAMETER.equals(paramKey) && !addGlobalParameters) {
                            return;
                        }
                        this.addParameterToTestElement(doc, testElement, (String)paramKey, (String)paramValue);
                    }
                });
                if (addGlobalParameters) {
                    globalParameters.entrySet().stream().filter(p -> !((String)p.getKey()).equals("ADD_GLOBAL_PARAMETERS_TO_TESTS")).forEach(entry -> this.addParameterToTestElement(doc, testElement, (String)entry.getKey(), (String)entry.getValue()));
                }
                if (SdkStringUtils.isNotEmpty(dataTable = test.getParameter(DATA_TABLE_PARAMETER))) {
                    Element dataTableElement = doc.createElement("DataTable");
                    dataTableElement.setAttribute("path", workingDir + "\\" + dataTable);
                    testElement.appendChild(dataTableElement);
                }
                if (SdkStringUtils.isNotEmpty(iterations = test.getParameter(ITERATIONS_PARAMETER))) {
                    String[] parts = iterations.split(",");
                    Element iterationElement = doc.createElement("Iterations");
                    iterationElement.setAttribute("mode", parts[0].trim());
                    if (parts.length >= 3) {
                        iterationElement.setAttribute("start", parts[1].trim());
                        iterationElement.setAttribute("end", parts[2].trim());
                    }
                    testElement.appendChild(iterationElement);
                }
                rootElement.appendChild(testElement);
            }
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            return writer.toString();
        }
        catch (ParserConfigurationException | TransformerException e) {
            String msg = "Failed to build MTBX content : " + e.getMessage();
            logger.error(msg);
            throw new RuntimeException(msg);
        }
    }

    private boolean isAddGlobalParameters(Map<String, String> globalParameters) {
        boolean addGlobalParameters = false;
        if (globalParameters != null) {
            boolean bl = addGlobalParameters = globalParameters.containsKey("ADD_GLOBAL_PARAMETERS_TO_TESTS") && "true".equalsIgnoreCase(globalParameters.getOrDefault("ADD_GLOBAL_PARAMETERS_TO_TESTS", "false"));
            if (!addGlobalParameters && globalParameters.containsKey("octaneConfigId")) {
                try {
                    OctaneClient octaneClient = OctaneSDK.getClientByInstanceId(globalParameters.get("octaneConfigId"));
                    addGlobalParameters = ConfigurationParameterFactory.addGlobalParametersToTests(octaneClient.getConfigurationService().getConfiguration());
                }
                catch (Exception e) {
                    logger.info("Failed to get octane client by id " + globalParameters.get("octaneConfigId"));
                }
            }
        }
        return addGlobalParameters;
    }

    private void addParameterToTestElement(Document doc, Element testElement, String paramKey, String paramValue) {
        Element parameterElement = doc.createElement("Parameter");
        parameterElement.setAttribute("name", paramKey);
        if (paramValue != null && paramValue.startsWith("(")) {
            int endIndex = paramValue.indexOf(")");
            if (endIndex != -1) {
                String type = paramValue.substring(1, endIndex).trim();
                String value = "";
                if (paramValue.length() >= endIndex + 1) {
                    value = paramValue.substring(endIndex + 1).trim();
                }
                parameterElement.setAttribute("value", value);
                parameterElement.setAttribute("type", type);
            }
        } else {
            parameterElement.setAttribute("value", paramValue);
        }
        testElement.appendChild(parameterElement);
    }
}

