/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.executor.converters;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hp.octane.integrations.OctaneClient;
import com.hp.octane.integrations.OctaneConfiguration;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.connectivity.HttpMethod;
import com.hp.octane.integrations.dto.connectivity.OctaneRequest;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.executor.impl.TestingToolType;
import com.hp.octane.integrations.dto.general.MbtData;
import com.hp.octane.integrations.dto.general.MbtDataTable;
import com.hp.octane.integrations.dto.general.MbtUnit;
import com.hp.octane.integrations.executor.TestToRunData;
import com.hp.octane.integrations.executor.TestsToRunConverterResult;
import com.hp.octane.integrations.executor.converters.MbtCodelessTest;
import com.hp.octane.integrations.executor.converters.MbtCodelessUnit;
import com.hp.octane.integrations.executor.converters.MbtTest;
import com.hp.octane.integrations.executor.converters.MbtUftTest;
import com.hp.octane.integrations.executor.converters.MfUftConverter;
import com.hp.octane.integrations.uft.UftTestDiscoveryUtils;
import com.hp.octane.integrations.utils.SdkStringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.Charsets;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.util.StringBuilderWriter;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MfMBTConverter
extends MfUftConverter {
    private static final Logger logger = LogManager.getLogger(MfMBTConverter.class);
    public static final String MBT_DATA = "mbtData";
    public static final String MBT_PARENT_SUB_DIR = "___mbt";
    public static final String MBT_DATA_NOT_INCLUDED = "mbtDataNotIncluded";
    public static final Pattern specialCharsPattern = Pattern.compile("[\\/:*?\"<>|%;]");
    public static final String BASE64_PREFIX = "BASE64_";
    public static final String INNER_RUN_ID_PARAMETER = "runId";
    List<MbtTest> mbtTests;

    public static String encodeTestNameIfRequired(String name) {
        if (name.startsWith(" ") || name.endsWith(" ") || specialCharsPattern.matcher(name).find()) {
            return BASE64_PREFIX + Base64.getUrlEncoder().encodeToString(name.getBytes(Charsets.UTF_8));
        }
        return name;
    }

    public static String decodeTestNameIfRequired(String name) {
        if (name.startsWith(BASE64_PREFIX)) {
            byte[] decodedBytes = Base64.getUrlDecoder().decode(name.substring(BASE64_PREFIX.length()));
            return new String(decodedBytes, Charsets.UTF_8);
        }
        return name;
    }

    private static boolean shouldRetrieveMbtData(List<TestToRunData> tests) {
        return tests.get(0).getParameters().get(MBT_DATA).equals(MBT_DATA_NOT_INCLUDED);
    }

    private static Map<String, String> parseSuiteRunDataJson(String responseJson) {
        try {
            ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (Map)objectMapper.readValue(responseJson, Map.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid suite run data format: " + e.getMessage(), e);
        }
    }

    private static String extractDataTableIterations(MbtData mbtData, TestToRunData testToRunData) {
        String encodedIterationsAsString = "";
        MbtDataTable dataTable = mbtData.getData();
        if (dataTable != null && dataTable.getParameters() != null && !dataTable.getParameters().isEmpty()) {
            StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringBuilderWriter, CSVFormat.DEFAULT.withHeader((String[])dataTable.getParameters().stream().toArray(String[]::new)));){
                dataTable.getIterations().forEach(iteration -> {
                    try {
                        csvPrinter.printRecord((Iterable)iteration);
                    }
                    catch (IOException e) {
                        logger.error("Failed to build data table iterations record for mbt test {}", (Object)testToRunData.getTestName(), (Object)e);
                    }
                });
            }
            catch (IOException e) {
                logger.error("Failed to build data table iterations for mbt test {}", (Object)testToRunData.getTestName(), (Object)e);
            }
            String iterationsAsString = stringBuilderWriter.toString();
            byte[] encodedIterations = Base64.getEncoder().encode(iterationsAsString.getBytes(StandardCharsets.UTF_8));
            encodedIterationsAsString = new String(encodedIterations, StandardCharsets.UTF_8);
        }
        return encodedIterationsAsString;
    }

    private static String extractActionParameterNames(MbtUnit mbtUnit) {
        List parameters = mbtUnit.getParameters();
        if (parameters != null && !parameters.isEmpty()) {
            StringBuilder inputParameters = new StringBuilder();
            StringBuilder outputParameters = new StringBuilder();
            parameters.forEach(mbtUnitParameter -> {
                String parameterName = mbtUnitParameter.getName();
                switch (mbtUnitParameter.getType().toUpperCase()) {
                    case "INPUT": {
                        inputParameters.append(SdkStringUtils.isEmpty(mbtUnitParameter.getOutputParameter()) ? ",DataTable(\"" + parameterName + "\")" : "," + mbtUnitParameter.getOutputParameter());
                        break;
                    }
                    default: {
                        outputParameters.append(",").append(parameterName);
                    }
                }
            });
            return inputParameters.append((CharSequence)outputParameters).toString();
        }
        return null;
    }

    public static String computeResourcePath(String resourcePath, String testPath) {
        if (resourcePath.startsWith("..")) {
            File file = new File(testPath, resourcePath);
            try {
                return file.getCanonicalPath();
            }
            catch (IOException e) {
                String msg = String.format("Failed to computeResourcePath for resource %s , test %s", resourcePath, testPath);
                logger.error(msg);
                return resourcePath;
            }
        }
        return resourcePath;
    }

    @Override
    public String convertInternal(List<TestToRunData> data, String executionDirectory, Map<String, String> globalParameters) {
        String myWorkingDir = executionDirectory + "\\" + MBT_PARENT_SUB_DIR;
        this.handleMBTModel(data, executionDirectory, globalParameters);
        return super.convertToMtbxContent(data, myWorkingDir, globalParameters);
    }

    @Override
    protected void afterConvert(TestsToRunConverterResult result) {
        result.setMbtTests(this.mbtTests);
    }

    @Override
    public void enrichTestsData(List<TestToRunData> tests, Map<String, String> globalParameters) {
        this.handleMbtDataRetrieval(tests, globalParameters);
    }

    private void handleMBTModel(List<TestToRunData> tests, String checkoutFolder, Map<String, String> globalParameters) {
        for (TestToRunData data : tests) {
            data.setTestName(MfMBTConverter.encodeTestNameIfRequired(data.getTestName()));
        }
        this.mbtTests = new ArrayList<MbtTest>();
        int order = 1;
        for (TestToRunData data : tests) {
            MbtData mbtData;
            String mbtDataRaw = data.getParameter(MBT_DATA);
            if (MBT_DATA_NOT_INCLUDED.equals(mbtDataRaw)) {
                throw new RuntimeException("Failed to fetch mbt data for test " + data.getTestName());
            }
            try {
                String raw = new String(Base64.getDecoder().decode(mbtDataRaw), StandardCharsets.UTF_8);
                mbtData = (MbtData)DTOFactory.getInstance().dtoFromJson(raw, MbtData.class);
                if (mbtData.getTestingToolType().equals((Object)TestingToolType.UFT)) {
                    data.setPackageName("_" + order++);
                }
            }
            catch (Exception e) {
                String msg = "Failed to decode test action data " + data.getTestName() + " : " + e.getMessage();
                logger.error(msg);
                throw new RuntimeException(msg);
            }
            if (mbtData.getTestingToolType().equals((Object)TestingToolType.UFT)) {
                this.convertUftTest(checkoutFolder, data, mbtData);
                continue;
            }
            this.convertCodelessTest(data, mbtData);
        }
    }

    private void convertUftTest(String checkoutFolder, TestToRunData data, MbtData mbtData) {
        for (int i = mbtData.getUnits().size() - 1; i >= 0; --i) {
            MbtUnit mbtUnit = (MbtUnit)mbtData.getUnits().get(i);
            String scmPath = mbtUnit.getPathInScm();
            if (scmPath == null || !scmPath.contains(":")) {
                logger.error("UnitId {} has invalid scmPath : {}, skipping", (Object)mbtUnit.getUnitId(), (Object)mbtUnit.getPathInScm());
                mbtData.getUnits().remove(i);
                continue;
            }
            String[] testAndActionParts = scmPath.split(":");
            String testPath = checkoutFolder + "\\" + testAndActionParts[0];
            String actionName = testAndActionParts[1];
            mbtUnit.setTestPath(testPath).setActionName(actionName);
        }
        ArrayList<String> scriptLinesList = new ArrayList<String>();
        ArrayList<String> underlyingTestsList = new ArrayList<String>();
        ArrayList<Long> unitIds = new ArrayList<Long>();
        String testLineSplitter = "'********************************************************************************************************************************************";
        scriptLinesList.add("");
        scriptLinesList.add(testLineSplitter);
        scriptLinesList.add("");
        try {
            for (int i = 0; i < mbtData.getUnits().size(); ++i) {
                boolean theSameTestAsPrev;
                MbtUnit mbtUnit = (MbtUnit)mbtData.getUnits().get(i);
                String sanitizedTestPath = this.sanitizeTestPath(mbtUnit.getTestPath());
                mbtUnit.setTestPath(sanitizedTestPath);
                File testFolderFile = new File(mbtUnit.getTestPath());
                if (!testFolderFile.exists()) {
                    throw new IllegalArgumentException(String.format("Test path %s is not found. UnitId = %s.", mbtUnit.getTestPath(), mbtUnit.getUnitId()));
                }
                if (UftTestDiscoveryUtils.isUftTestFolder(testFolderFile.listFiles()).isNone()) {
                    throw new IllegalArgumentException(String.format("Invalid test path %s. UnitId = %s.", mbtUnit.getTestPath(), mbtUnit.getUnitId()));
                }
                String actionParameters = MfMBTConverter.extractActionParameterNames(mbtUnit);
                TestResources testResources = this.extractTestResources(mbtUnit.getTestPath());
                boolean bl = theSameTestAsPrev = i > 0 ? ((MbtUnit)mbtData.getUnits().get(i - 1)).getTestPath().equals(mbtUnit.getTestPath()) : false;
                if (theSameTestAsPrev) {
                    scriptLinesList.add("'The action belongs to the test of the previous action. Skip reloading function libraries and recovery scenarios.");
                } else {
                    if (!testResources.functionLibraries.isEmpty()) {
                        scriptLinesList.add("");
                        scriptLinesList.add("'Add function libraries");
                        scriptLinesList.add("RestartFLEngine");
                        for (String fl : testResources.functionLibraries) {
                            scriptLinesList.add(String.format("LoadFunctionLibrary \"%s\"", fl));
                        }
                    }
                    if (!testResources.recoveryScenarios.isEmpty()) {
                        scriptLinesList.add("");
                        scriptLinesList.add("'Add recovery scenarios");
                        scriptLinesList.add("CleanRSManager");
                        String scenarios = "LoadRecoveryScenario " + testResources.recoveryScenarios.stream().map(rs -> String.format("\"%s|%s|1|1*\"", rs.path, rs.name)).collect(Collectors.joining(","));
                        scriptLinesList.add(scenarios);
                    }
                }
                scriptLinesList.add("");
                scriptLinesList.add("'Run action");
                if (actionParameters != null) {
                    scriptLinesList.add(String.format("LoadAndRunAction \"%s\",\"%s\",rngAll%s", mbtUnit.getTestPath(), mbtUnit.getActionName(), actionParameters));
                } else {
                    scriptLinesList.add(String.format("LoadAndRunAction \"%s\",\"%s\"", mbtUnit.getTestPath(), mbtUnit.getActionName()));
                }
                scriptLinesList.add("\r\nIf Reporter.CurrentActionIterationStatus = 1 Then\r\nExitAction\r\nEnd If");
                scriptLinesList.add("");
                scriptLinesList.add(testLineSplitter);
                scriptLinesList.add("");
                underlyingTestsList.add(mbtUnit.getTestPath());
                unitIds.add(mbtUnit.getUnitId());
            }
        }
        catch (Exception e) {
            logger.error("Failed to build script for test {} : {}", (Object)data.getTestName(), (Object)e.getMessage());
            throw e;
        }
        String script = String.join((CharSequence)"\r\n", scriptLinesList);
        String encodedIterationsAsString = MfMBTConverter.extractDataTableIterations(mbtData, data);
        MbtUftTest test = new MbtUftTest(data.getTestName(), data.getPackageName(), script, underlyingTestsList, unitIds, encodedIterationsAsString, Collections.emptyList(), Collections.emptyList());
        this.mbtTests.add(test);
    }

    private void convertCodelessTest(TestToRunData data, MbtData mbtData) {
        data.addParameters("testingToolType", TestingToolType.CODELESS.value());
        MbtCodelessTest mbtCodelessTest = new MbtCodelessTest(data.getTestName());
        mbtCodelessTest.setMbtDataTable(mbtData.getData());
        for (MbtUnit mbtUnit : mbtData.getUnits()) {
            MbtCodelessUnit mbtCodelessUnit = new MbtCodelessUnit();
            mbtCodelessUnit.setUnitId(mbtUnit.getUnitId());
            mbtCodelessUnit.setName(mbtUnit.getName());
            mbtCodelessUnit.setOrder(mbtUnit.getOrder());
            mbtCodelessUnit.setScript(mbtUnit.getScript());
            mbtCodelessUnit.setParameters(mbtUnit.getParameters());
            mbtCodelessTest.getUnits().add(mbtCodelessUnit);
        }
        this.mbtTests.add(mbtCodelessTest);
    }

    private String sanitizeTestPath(String testPath) {
        String lastPart;
        if (SdkStringUtils.isEmpty(testPath)) {
            return testPath;
        }
        int lastIndex = testPath.lastIndexOf("\\");
        if (lastIndex > -1 && (lastPart = testPath.substring(lastIndex)).toLowerCase().contains("action")) {
            return testPath.substring(0, lastIndex);
        }
        return testPath;
    }

    private void handleMbtDataRetrieval(List<TestToRunData> tests, Map<String, String> globalParameters) {
        if (MfMBTConverter.shouldRetrieveMbtData(tests)) {
            OctaneClient octaneClient = OctaneSDK.getClientByInstanceId(globalParameters.get("octaneConfigId"));
            OctaneConfiguration octaneConfig = octaneClient.getConfigurationService().getConfiguration();
            String url = octaneConfig.getUrl() + "/api/shared_spaces/" + octaneConfig.getSharedSpace() + "/workspaces/" + globalParameters.get("octaneWorkspaceId") + "/suite_runs/" + globalParameters.get("suiteRunId") + "/get_suite_data";
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("accept", ContentType.APPLICATION_JSON.getMimeType());
            headers.put("HPECLIENTTYPE", "HPE_CI_CLIENT");
            OctaneRequest request = ((OctaneRequest)DTOFactory.getInstance().newDTO(OctaneRequest.class)).setMethod(HttpMethod.GET).setHeaders(headers).setUrl(url);
            try {
                OctaneResponse octaneResponse = octaneClient.getRestService().obtainOctaneRestClient().execute(request);
                if (octaneResponse != null && octaneResponse.getStatus() == 200) {
                    Map<String, String> parsedResponse = MfMBTConverter.parseSuiteRunDataJson(octaneResponse.getBody());
                    if (parsedResponse != null) {
                        for (TestToRunData test : tests) {
                            String runID = test.getParameter(INNER_RUN_ID_PARAMETER);
                            test.addParameters(MBT_DATA, parsedResponse.get(runID));
                        }
                    }
                } else {
                    logger.error("Failed to get response {}", octaneResponse != null ? Integer.valueOf(octaneResponse.getStatus()) : "(null)");
                }
            }
            catch (IOException e) {
                logger.error("Failed to get response ", (Throwable)e);
            }
        }
    }

    private TestResources extractTestResources(String testPath) {
        TestResources content = new TestResources();
        try {
            String[] recoveryScenariosParts;
            File tspFile = new File(testPath + "\\Test.tsp");
            FileInputStream is = new FileInputStream(tspFile);
            String xmlContent = UftTestDiscoveryUtils.extractXmlContentFromTspFile(is);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(xmlContent)));
            NodeList funcLibNodes = document.getElementsByTagName("FuncLib");
            for (int i = 0; i < funcLibNodes.getLength(); ++i) {
                String fl = document.getElementsByTagName("FuncLib").item(i).getTextContent();
                content.functionLibraries.add(MfMBTConverter.computeResourcePath(fl, testPath));
            }
            for (String recoveryScenariosPart : recoveryScenariosParts = document.getElementsByTagName("RecoveryScenarios").item(0).getTextContent().split("\\*")) {
                String[] rsAsArray = recoveryScenariosPart.split("\\|");
                if (rsAsArray.length <= 1) continue;
                String rsPath = MfMBTConverter.computeResourcePath(rsAsArray[0], testPath);
                String rsName = rsAsArray[1];
                content.recoveryScenarios.add(RecoveryScenario.create(rsPath, rsName));
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.error("Failed to parse function libraries/recovery scenarios for tests {} : {}", (Object)testPath, (Object)e);
        }
        return content;
    }

    private static class RecoveryScenario {
        String path;
        String name;

        private RecoveryScenario() {
        }

        public static RecoveryScenario create(String path, String name) {
            RecoveryScenario rc = new RecoveryScenario();
            rc.path = path;
            rc.name = name;
            return rc;
        }
    }

    private static class TestResources {
        List<String> functionLibraries = new ArrayList<String>();
        List<RecoveryScenario> recoveryScenarios = new ArrayList<RecoveryScenario>();

        private TestResources() {
        }
    }
}

