/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations;

import com.hp.octane.integrations.OctaneClientImpl;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.services.configurationparameters.factory.ConfigurationParameter;
import com.hp.octane.integrations.utils.OctaneUrlParser;
import com.hp.octane.integrations.utils.SdkStringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OctaneConfiguration {
    private final String instanceId;
    private String url;
    private String sharedSpace;
    private String client;
    private String secret;
    volatile boolean attached;
    private boolean suspended;
    private boolean sdkSupported = true;
    private String impersonatedUser;
    private Map<String, ConfigurationParameter> parameters = new HashMap<String, ConfigurationParameter>();

    public OctaneConfiguration(String instanceId) {
        if (instanceId == null || instanceId.isEmpty()) {
            throw new IllegalArgumentException("instance ID MUST NOT be null nor empty");
        }
        this.instanceId = instanceId;
    }

    public static OctaneConfiguration createWithUiLocation(String instanceId, String uiLocation) throws IllegalArgumentException {
        OctaneConfiguration oc = new OctaneConfiguration(instanceId);
        oc.setUiLocation(uiLocation);
        return oc;
    }

    public static OctaneConfiguration create(String instanceId, String serverUrl, String sharedSpace) throws IllegalArgumentException {
        OctaneConfiguration oc = new OctaneConfiguration(instanceId);
        oc.setUrlAndSpace(serverUrl, sharedSpace);
        return oc;
    }

    public final String getInstanceId() {
        return this.instanceId;
    }

    public final String getUrl() {
        return this.url;
    }

    public final void setUiLocation(String uiLocation) {
        OctaneUrlParser parseLocation = OctaneUrlParser.parse(uiLocation);
        this.setUrlAndSpace(parseLocation.getLocation(), parseLocation.getSharedSpace());
    }

    public final void setUrlAndSpace(String serverUrl, String space) {
        if (serverUrl == null || serverUrl.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid URL");
        }
        if (space == null || space.trim().isEmpty()) {
            throw new IllegalArgumentException("Missing shared space parameter");
        }
        String myServerUrl = serverUrl.trim();
        String mySpace = space.trim();
        if (myServerUrl.contains("?")) {
            myServerUrl = myServerUrl.substring(0, myServerUrl.indexOf("?"));
        }
        try {
            new URL(myServerUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL");
        }
        if (myServerUrl.equals(this.url) && mySpace.equals(this.sharedSpace)) {
            return;
        }
        if (this.attached && !OctaneSDK.isSharedSpaceUnique(myServerUrl, mySpace)) {
            throw new IllegalArgumentException("shared space '" + mySpace + "' of Octane '" + myServerUrl + "' is already in use");
        }
        this.url = myServerUrl;
        this.sharedSpace = mySpace;
    }

    public final String getSharedSpace() {
        return this.sharedSpace;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        if (this.client != null && !SdkStringUtils.equals(this.client, client)) {
            try {
                ((OctaneClientImpl)OctaneSDK.getClientByInstanceId(this.instanceId)).notifyCredentialsChanged();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.client = client;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String toString() {
        return "OctaneConfiguration { instanceId: " + this.instanceId + ", url: " + this.url + ", sharedSpace: " + this.sharedSpace + ", suspended: " + this.suspended + ", client: " + this.client + " }";
    }

    public String getLocationForLog() {
        return "[" + this.getUrl() + "?p=" + this.getSharedSpace() + "] ";
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isDisabled() {
        return this.suspended || !this.sdkSupported;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public String getImpersonatedUser() {
        return this.impersonatedUser;
    }

    public void setImpersonatedUser(String impersonatedUser) {
        this.impersonatedUser = impersonatedUser;
    }

    public boolean isSdkSupported() {
        return this.sdkSupported;
    }

    protected void setSdkSupported(boolean sdkSupported) {
        this.sdkSupported = sdkSupported;
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public void addParameter(ConfigurationParameter param) {
        this.parameters.put(param.getKey(), param);
    }

    public ConfigurationParameter getParameter(String key) {
        return this.parameters.get(key);
    }

    public boolean isParameterDefined(String key) {
        return this.parameters.containsKey(key);
    }
}

