/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Note;
import org.gitlab4j.models.Constants;
import org.gitlab4j.models.utils.ISO8601;

public class NotesApi
extends AbstractApi {
    public NotesApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Note> getIssueNotes(Object projectIdOrPath, Long issueIid) throws GitLabApiException {
        return this.getIssueNotes(projectIdOrPath, issueIid, this.getDefaultPerPage()).all();
    }

    public List<Note> getIssueNotes(Object projectIdOrPath, Long issueIid, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes");
        return (List)response.readEntity((GenericType)new GenericType<List<Note>>(){});
    }

    public Pager<Note> getIssueNotes(Object projectIdOrPath, Long issueIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<Note>(this, Note.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes");
    }

    public Stream<Note> getIssueNotesStream(Object projectIdOrPath, Long issueIid) throws GitLabApiException {
        return this.getIssueNotes(projectIdOrPath, issueIid, this.getDefaultPerPage()).stream();
    }

    public Note getIssueNote(Object projectIdOrPath, Long issueIid, Long noteId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes", noteId);
        return (Note)response.readEntity(Note.class);
    }

    public Note createIssueNote(Object projectIdOrPath, Long issueIid, String body) throws GitLabApiException {
        return this.createIssueNote(projectIdOrPath, issueIid, body, null, null);
    }

    public Note createIssueNote(Object projectIdOrPath, Long issueIid, String body, Date createdAt) throws GitLabApiException {
        return this.createIssueNote(projectIdOrPath, issueIid, body, null, null);
    }

    public Note createIssueNote(Object projectIdOrPath, Long issueIid, String body, Date createdAt, Boolean internal) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("body", body, true).withParam("created_at", createdAt).withParam("internal", internal);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes"});
        return (Note)response.readEntity(Note.class);
    }

    public Note updateIssueNote(Object projectIdOrPath, Long issueIid, Long noteId, String body) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("body", body, true);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes", noteId});
        return (Note)response.readEntity(Note.class);
    }

    public void deleteIssueNote(Object projectIdOrPath, Long issueIid, Long noteId) throws GitLabApiException {
        if (issueIid == null) {
            throw new RuntimeException("issueIid cannot be null");
        }
        if (noteId == null) {
            throw new RuntimeException("noteId cannot be null");
        }
        this.delete(Response.Status.NO_CONTENT, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "notes", noteId);
    }

    public List<Note> getMergeRequestNotes(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getMergeRequestNotes(projectIdOrPath, mergeRequestIid, null, null, this.getDefaultPerPage()).all();
    }

    public List<Note> getMergeRequestNotes(Object projectIdOrPath, Long mergeRequestIid, Constants.SortOrder sortOrder, Note.OrderBy orderBy) throws GitLabApiException {
        return this.getMergeRequestNotes(projectIdOrPath, mergeRequestIid, sortOrder, orderBy, this.getDefaultPerPage()).all();
    }

    public List<Note> getMergeRequestNotes(Object projectIdOrPath, Long mergeRequestIid, int page, int perPage) throws GitLabApiException {
        return this.getMergeRequestNotes(projectIdOrPath, mergeRequestIid, null, null, page, perPage);
    }

    public List<Note> getMergeRequestNotes(Object projectIdOrPath, Long mergeRequestIid, Constants.SortOrder sortOrder, Note.OrderBy orderBy, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("sort", sortOrder).withParam("order_by", orderBy).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes");
        return (List)response.readEntity((GenericType)new GenericType<List<Note>>(){});
    }

    public Pager<Note> getMergeRequestNotes(Object projectIdOrPath, Long mergeRequestIid, int itemsPerPage) throws GitLabApiException {
        return this.getMergeRequestNotes(projectIdOrPath, mergeRequestIid, null, null, itemsPerPage);
    }

    public Stream<Note> getMergeRequestNotesStream(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getMergeRequestNotes(projectIdOrPath, mergeRequestIid, null, null, this.getDefaultPerPage()).stream();
    }

    public Pager<Note> getMergeRequestNotes(Object projectIdOrPath, Long mergeRequestIid, Constants.SortOrder sortOrder, Note.OrderBy orderBy, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("sort", sortOrder).withParam("order_by", orderBy).withParam("page", 1).withParam("per_page", itemsPerPage);
        return new Pager<Note>(this, Note.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes");
    }

    public Stream<Note> getMergeRequestNotesStream(Object projectIdOrPath, Long mergeRequestIid, Constants.SortOrder sortOrder, Note.OrderBy orderBy) throws GitLabApiException {
        return this.getMergeRequestNotes(projectIdOrPath, mergeRequestIid, sortOrder, orderBy, this.getDefaultPerPage()).stream();
    }

    public Note getMergeRequestNote(Object projectIdOrPath, Long mergeRequestIid, Long noteId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes", noteId);
        return (Note)response.readEntity(Note.class);
    }

    public Note createMergeRequestNote(Object projectIdOrPath, Long mergeRequestIid, String body, Date createdAt, Boolean internal) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("body", body, true).withParam("internal", internal);
        if (createdAt != null) {
            formData.withParam("created_at", ISO8601.toString((Date)createdAt));
        }
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes"});
        return (Note)response.readEntity(Note.class);
    }

    public Note updateMergeRequestNote(Object projectIdOrPath, Long mergeRequestIid, Long noteId, String body) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("body", body, true);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes", noteId});
        return (Note)response.readEntity(Note.class);
    }

    public void deleteMergeRequestNote(Object projectIdOrPath, Long mergeRequestIid, Long noteId) throws GitLabApiException {
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        if (noteId == null) {
            throw new RuntimeException("noteId cannot be null");
        }
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "notes", noteId);
    }

    public List<Note> getEpicNotes(Object groupIdOrPath, Long epicId) throws GitLabApiException {
        return this.getEpicNotes(groupIdOrPath, epicId, this.getDefaultPerPage()).all();
    }

    public List<Note> getEpicNotes(Object groupIdOrPath, Long epicId, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicId, "notes");
        return (List)response.readEntity((GenericType)new GenericType<List<Note>>(){});
    }

    public Pager<Note> getEpicNotes(Object groupIdOrPath, Long epicId, int itemsPerPage) throws GitLabApiException {
        return new Pager<Note>(this, Note.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicId, "notes");
    }

    public Stream<Note> getEpicNotesStream(Object groupIdOrPath, Long epicId) throws GitLabApiException {
        return this.getEpicNotes(groupIdOrPath, epicId, this.getDefaultPerPage()).stream();
    }

    public Note getEpicNote(Object groupIdOrPath, Long epicId, Long noteId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicId, "notes", noteId);
        return (Note)response.readEntity(Note.class);
    }

    public Note createEpicNote(Object groupIdOrPath, Long epicId, String body) throws GitLabApiException {
        return this.createEpicNote(groupIdOrPath, epicId, body, null, null);
    }

    public Note createEpicNote(Object groupIdOrPath, Long epicId, String body, Date createdAt) throws GitLabApiException {
        return this.createEpicNote(groupIdOrPath, epicId, body, null, null);
    }

    public Note createEpicNote(Object groupIdOrPath, Long epicId, String body, Date createdAt, Boolean internal) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("body", body, true).withParam("created_at", createdAt).withParam("internal", internal);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicId, "notes"});
        return (Note)response.readEntity(Note.class);
    }

    public Note updateEpicNote(Object groupIdOrPath, Long epicId, Long noteId, String body) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("body", body, true);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicId, "notes", noteId});
        return (Note)response.readEntity(Note.class);
    }

    public void deleteEpicNote(Object groupIdOrPath, Long epicId, Long noteId) throws GitLabApiException {
        if (epicId == null) {
            throw new RuntimeException("epicId cannot be null");
        }
        if (noteId == null) {
            throw new RuntimeException("noteId cannot be null");
        }
        this.delete(Response.Status.NO_CONTENT, this.getDefaultPerPageParam(), "groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicId, "notes", noteId);
    }
}

