/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.util;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlunit.html.impl.Color;

public final class StringUtils {
    private static final Pattern HEX_COLOR = Pattern.compile("#([\\da-fA-F]{3}|[\\da-fA-F]{6})");
    private static final Pattern RGB_COLOR = Pattern.compile("rgb\\(\\s*(0|[1-9]\\d?|1\\d\\d?|2[0-4]\\d|25[0-5])%?\\s*,\\s*(0|[1-9]\\d?|1\\d\\d?|2[0-4]\\d|25[0-5])%?\\s*,\\s*(0|[1-9]\\d?|1\\d\\d?|2[0-4]\\d|25[0-5])%?\\s*\\)");
    private static final Pattern RGBA_COLOR = Pattern.compile("rgba\\(\\s*(0|[1-9]\\d?|1\\d\\d?|2[0-4]\\d|25[0-5])%?\\s*,\\s*(0|[1-9]\\d?|1\\d\\d?|2[0-4]\\d|25[0-5])%?\\s*,\\s*(0|[1-9]\\d?|1\\d\\d?|2[0-4]\\d|25[0-5])%?\\s*,\\s*((0?.[1-9])|[01])\\s*\\)");
    private static final Pattern HSL_COLOR = Pattern.compile("hsl\\(\\s*((0|[1-9]\\d?|[12]\\d\\d?|3[0-5]\\d)(.\\d*)?)\\s*,\\s*((0|[1-9]\\d?|100)(.\\d*)?)%\\s*,\\s*((0|[1-9]\\d?|100)(.\\d*)?)%\\s*\\)");
    private static final Pattern ILLEGAL_FILE_NAME_CHARS = Pattern.compile("\\\\|/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}");
    private static final Map<String, String> CamelizeCache_ = new ConcurrentHashMap<String, String>();

    private StringUtils() {
    }

    public static String escapeXmlChars(String s) {
        return org.apache.commons.lang3.StringUtils.replaceEach((String)s, (String[])new String[]{"&", "<", ">"}, (String[])new String[]{"&amp;", "&lt;", "&gt;"});
    }

    public static String escapeXmlAttributeValue(String attValue) {
        int len = attValue.length();
        StringBuilder sb = null;
        for (int i = len - 1; i >= 0; --i) {
            char c = attValue.charAt(i);
            String replacement = null;
            if (c == '<') {
                replacement = "&lt;";
            } else if (c == '&') {
                replacement = "&amp;";
            } else if (c == '\"') {
                replacement = "&quot;";
            }
            if (replacement == null) continue;
            if (sb == null) {
                sb = new StringBuilder(attValue);
            }
            sb.replace(i, i + 1, replacement);
        }
        if (sb != null) {
            return sb.toString();
        }
        return attValue;
    }

    public static int indexOf(String s, char searchChar, int beginIndex, int endIndex) {
        for (int i = beginIndex; i < endIndex; ++i) {
            if (s.charAt(i) != searchChar) continue;
            return i;
        }
        return -1;
    }

    public static Color asColorHexadecimal(String token) {
        if (token == null) {
            return null;
        }
        Matcher tmpMatcher = HEX_COLOR.matcher(token);
        boolean tmpFound = tmpMatcher.matches();
        if (!tmpFound) {
            return null;
        }
        String tmpHex = tmpMatcher.group(1);
        if (tmpHex.length() == 6) {
            int tmpRed = Integer.parseInt(tmpHex.substring(0, 2), 16);
            int tmpGreen = Integer.parseInt(tmpHex.substring(2, 4), 16);
            int tmpBlue = Integer.parseInt(tmpHex.substring(4, 6), 16);
            return new Color(tmpRed, tmpGreen, tmpBlue);
        }
        int tmpRed = Integer.parseInt(tmpHex.substring(0, 1) + tmpHex.substring(0, 1), 16);
        int tmpGreen = Integer.parseInt(tmpHex.substring(1, 2) + tmpHex.substring(1, 2), 16);
        int tmpBlue = Integer.parseInt(tmpHex.substring(2, 3) + tmpHex.substring(2, 3), 16);
        return new Color(tmpRed, tmpGreen, tmpBlue);
    }

    public static Color findColorRGB(String token) {
        if (token == null) {
            return null;
        }
        Matcher tmpMatcher = RGB_COLOR.matcher(token);
        if (!tmpMatcher.find()) {
            return null;
        }
        int tmpRed = Integer.parseInt(tmpMatcher.group(1));
        int tmpGreen = Integer.parseInt(tmpMatcher.group(2));
        int tmpBlue = Integer.parseInt(tmpMatcher.group(3));
        return new Color(tmpRed, tmpGreen, tmpBlue);
    }

    public static Color findColorRGBA(String token) {
        if (token == null) {
            return null;
        }
        Matcher tmpMatcher = RGBA_COLOR.matcher(token);
        if (!tmpMatcher.find()) {
            return null;
        }
        int tmpRed = Integer.parseInt(tmpMatcher.group(1));
        int tmpGreen = Integer.parseInt(tmpMatcher.group(2));
        int tmpBlue = Integer.parseInt(tmpMatcher.group(3));
        int tmpAlpha = (int)(Float.parseFloat(tmpMatcher.group(4)) * 255.0f);
        return new Color(tmpRed, tmpGreen, tmpBlue, tmpAlpha);
    }

    public static Color findColorHSL(String token) {
        if (token == null) {
            return null;
        }
        Matcher tmpMatcher = HSL_COLOR.matcher(token);
        if (!tmpMatcher.find()) {
            return null;
        }
        float tmpHue = Float.parseFloat(tmpMatcher.group(1)) / 360.0f;
        float tmpSaturation = Float.parseFloat(tmpMatcher.group(4)) / 100.0f;
        float tmpLightness = Float.parseFloat(tmpMatcher.group(7)) / 100.0f;
        return StringUtils.hslToRgb(tmpHue, tmpSaturation, tmpLightness);
    }

    private static Color hslToRgb(float h, float s, float l) {
        if (s == 0.0f) {
            return new Color(StringUtils.to255(l), StringUtils.to255(l), StringUtils.to255(l));
        }
        float q = l < 0.5f ? l * (1.0f + s) : l + s - l * s;
        float p = 2.0f * l - q;
        float r = StringUtils.hueToRgb(p, q, h + 0.33333334f);
        float g = StringUtils.hueToRgb(p, q, h);
        float b = StringUtils.hueToRgb(p, q, h - 0.33333334f);
        return new Color(StringUtils.to255(r), StringUtils.to255(g), StringUtils.to255(b));
    }

    private static float hueToRgb(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t < 0.16666667f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t < 0.5f) {
            return q;
        }
        if (t < 0.6666667f) {
            return p + (q - p) * (0.6666667f - t) * 6.0f;
        }
        return p;
    }

    private static int to255(float value) {
        return (int)Math.min(255.0f, 256.0f * value);
    }

    public static String formatColor(Color color) {
        return "rgb(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")";
    }

    public static String sanitizeForAppendReplacement(String toSanitize) {
        return org.apache.commons.lang3.StringUtils.replaceEach((String)toSanitize, (String[])new String[]{"\\", "$"}, (String[])new String[]{"\\\\", "\\$"});
    }

    public static String sanitizeForFileName(String toSanitize) {
        return ILLEGAL_FILE_NAME_CHARS.matcher(toSanitize).replaceAll("_");
    }

    public static String cssCamelize(String string) {
        if (string == null) {
            return null;
        }
        String result = CamelizeCache_.get(string);
        if (null != result) {
            return result;
        }
        int pos = string.indexOf(45);
        if (pos == -1 || pos == string.length() - 1) {
            CamelizeCache_.put(string, string);
            return string;
        }
        StringBuilder builder = new StringBuilder(string);
        builder.deleteCharAt(pos);
        builder.setCharAt(pos, Character.toUpperCase(builder.charAt(pos)));
        for (int i = pos + 1; i < builder.length() - 1; ++i) {
            if (builder.charAt(i) != '-') continue;
            builder.deleteCharAt(i);
            builder.setCharAt(i, Character.toUpperCase(builder.charAt(i)));
        }
        result = builder.toString();
        CamelizeCache_.put(string, result);
        return result;
    }

    public static String toRootLowerCase(String s) {
        return s == null ? null : s.toLowerCase(Locale.ROOT);
    }

    public static String cssDeCamelize(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (Character.isUpperCase(ch)) {
                builder.append('-').append(Character.toLowerCase(ch));
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    public static byte[] toByteArray(String content, Charset charset) {
        if (content == null || content.isEmpty()) {
            return new byte[0];
        }
        return content.getBytes(charset);
    }

    public static String[] splitAtJavaWhitespace(String str) {
        String[] parts = org.apache.commons.lang3.StringUtils.split((String)str);
        if (parts == null) {
            return new String[0];
        }
        return parts;
    }

    public static String[] splitAtBlank(String str) {
        String[] parts = org.apache.commons.lang3.StringUtils.split((String)str, (char)' ');
        if (parts == null) {
            return new String[0];
        }
        return parts;
    }

    public static String[] splitAtComma(String str) {
        String[] parts = org.apache.commons.lang3.StringUtils.split((String)str, (char)',');
        if (parts == null) {
            return new String[0];
        }
        return parts;
    }

    public static String[] splitAtCommaOrBlank(String str) {
        String[] parts = org.apache.commons.lang3.StringUtils.split((String)str, (String)", ");
        if (parts == null) {
            return new String[0];
        }
        return parts;
    }
}

