/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.ScriptResult;
import org.htmlunit.StringWebResponse;
import org.htmlunit.WebClient;
import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.BaseFrameElement;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.FrameWindow;
import org.htmlunit.html.HtmlAttributeChangeEvent;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlImage;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlScript;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.PostponedAction;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.Element;
import org.htmlunit.javascript.host.dom.AbstractList;
import org.htmlunit.javascript.host.dom.Attr;
import org.htmlunit.javascript.host.dom.Document;
import org.htmlunit.javascript.host.dom.NodeList;
import org.htmlunit.javascript.host.dom.Selection;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.javascript.host.html.DocumentProxy;
import org.htmlunit.javascript.host.html.HTMLCollection;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.javascript.host.html.HTMLIFrameElement;
import org.htmlunit.util.Cookie;
import org.htmlunit.util.StringUtils;

@JsxClass
public class HTMLDocument
extends Document {
    private static final Log LOG = LogFactory.getLog(HTMLDocument.class);
    private final StringBuilder writeBuilder_ = new StringBuilder();
    private boolean writeInCurrentDocument_ = true;
    private boolean closePostponedAction_;
    private boolean executionExternalPostponed_;

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    @Override
    public DomNode getDomNodeOrDie() {
        try {
            return super.getDomNodeOrDie();
        }
        catch (IllegalStateException e) {
            throw JavaScriptEngine.reportRuntimeError("No node attached to this object");
        }
    }

    @Override
    public HtmlPage getPage() {
        return (HtmlPage)this.getDomNodeOrDie();
    }

    @JsxFunction
    public static void write(Context context, Scriptable scope, Scriptable thisObj, Object[] args, org.htmlunit.corejs.javascript.Function function) {
        HTMLDocument thisAsDocument = HTMLDocument.getDocument(thisObj);
        thisAsDocument.write(HTMLDocument.concatArgsAsString(args));
    }

    private static String concatArgsAsString(Object[] args) {
        StringBuilder builder = new StringBuilder();
        for (Object arg : args) {
            builder.append(JavaScriptEngine.toString(arg));
        }
        return builder.toString();
    }

    @JsxFunction
    public static void writeln(Context context, Scriptable scope, Scriptable thisObj, Object[] args, org.htmlunit.corejs.javascript.Function function) {
        HTMLDocument thisAsDocument = HTMLDocument.getDocument(thisObj);
        thisAsDocument.write(HTMLDocument.concatArgsAsString(args) + "\n");
    }

    private static HTMLDocument getDocument(Scriptable thisObj) {
        if (thisObj instanceof HTMLDocument && thisObj.getPrototype() instanceof HTMLDocument) {
            return (HTMLDocument)thisObj;
        }
        if (thisObj instanceof DocumentProxy && thisObj.getPrototype() instanceof HTMLDocument) {
            return (HTMLDocument)((DocumentProxy)thisObj).getDelegee();
        }
        throw JavaScriptEngine.reportRuntimeError("Function can't be used detached from document");
    }

    public void setExecutingDynamicExternalPosponed(boolean executing) {
        this.executionExternalPostponed_ = executing;
    }

    protected void write(String content) {
        HtmlPage page;
        if (this.executionExternalPostponed_) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("skipping write for external posponed: " + content));
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("write: " + content));
        }
        if (!(page = (HtmlPage)this.getDomNodeOrDie()).isBeingParsed()) {
            this.writeInCurrentDocument_ = false;
        }
        this.writeBuilder_.append(content);
        if (!this.writeInCurrentDocument_) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"wrote content to buffer");
            }
            this.scheduleImplicitClose();
            return;
        }
        String bufferedContent = this.writeBuilder_.toString();
        if (!HTMLDocument.canAlreadyBeParsed(bufferedContent)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"write: not enough content to parse it now");
            }
            return;
        }
        this.writeBuilder_.setLength(0);
        page.writeInParsedStream(bufferedContent);
    }

    private void scheduleImplicitClose() {
        if (!this.closePostponedAction_) {
            this.closePostponedAction_ = true;
            HtmlPage page = (HtmlPage)this.getDomNodeOrDie();
            final WebWindow enclosingWindow = page.getEnclosingWindow();
            page.getWebClient().getJavaScriptEngine().addPostponedAction(new PostponedAction(page, "HTMLDocument.scheduleImplicitClose"){

                @Override
                public void execute() throws Exception {
                    if (HTMLDocument.this.writeBuilder_.length() != 0) {
                        HTMLDocument.this.close();
                    }
                    HTMLDocument.this.closePostponedAction_ = false;
                }

                @Override
                public boolean isStillAlive() {
                    return !enclosingWindow.isClosed();
                }
            });
        }
    }

    static boolean canAlreadyBeParsed(String content) {
        ParsingStatus tagState = ParsingStatus.OUTSIDE;
        int tagNameBeginIndex = 0;
        int scriptTagCount = 0;
        boolean tagIsOpen = true;
        char stringBoundary = '\u0000';
        boolean stringSkipNextChar = false;
        int index = 0;
        char openingQuote = '\u0000';
        for (char currentChar : content.toCharArray()) {
            switch (tagState) {
                case OUTSIDE: {
                    if (currentChar == '<') {
                        tagState = ParsingStatus.START;
                        tagIsOpen = true;
                        break;
                    }
                    if (scriptTagCount <= 0 || currentChar != '\'' && currentChar != '\"') break;
                    tagState = ParsingStatus.IN_STRING;
                    stringBoundary = currentChar;
                    stringSkipNextChar = false;
                    break;
                }
                case START: {
                    if (currentChar == '/') {
                        tagIsOpen = false;
                        tagNameBeginIndex = index + 1;
                    } else {
                        tagNameBeginIndex = index;
                    }
                    tagState = ParsingStatus.IN_NAME;
                    break;
                }
                case IN_NAME: {
                    if (Character.isWhitespace(currentChar) || currentChar == '>') {
                        String tagName = content.substring(tagNameBeginIndex, index);
                        if ("script".equalsIgnoreCase(tagName)) {
                            if (tagIsOpen) {
                                ++scriptTagCount;
                            } else if (scriptTagCount > 0) {
                                --scriptTagCount;
                            }
                        }
                        if (currentChar == '>') {
                            tagState = ParsingStatus.OUTSIDE;
                            break;
                        }
                        tagState = ParsingStatus.INSIDE;
                        break;
                    }
                    if (Character.isLetter(currentChar)) break;
                    tagState = ParsingStatus.OUTSIDE;
                    break;
                }
                case INSIDE: {
                    if (currentChar == openingQuote) {
                        openingQuote = '\u0000';
                        break;
                    }
                    if (openingQuote != '\u0000') break;
                    if (currentChar == '\'' || currentChar == '\"') {
                        openingQuote = currentChar;
                        break;
                    }
                    if (currentChar != '>' || openingQuote != '\u0000') break;
                    tagState = ParsingStatus.OUTSIDE;
                    break;
                }
                case IN_STRING: {
                    if (stringSkipNextChar) {
                        stringSkipNextChar = false;
                        break;
                    }
                    if (currentChar == stringBoundary) {
                        tagState = ParsingStatus.OUTSIDE;
                        break;
                    }
                    if (currentChar != '\\') break;
                    stringSkipNextChar = true;
                    break;
                }
            }
            ++index;
        }
        if (scriptTagCount > 0 || tagState != ParsingStatus.OUTSIDE) {
            if (LOG.isDebugEnabled()) {
                StringBuilder message = new StringBuilder().append("canAlreadyBeParsed() retruns false for content: '").append(org.apache.commons.lang3.StringUtils.abbreviateMiddle((String)content, (String)".", (int)100)).append("' (scriptTagCount: ").append(scriptTagCount).append(" tagState: ").append((Object)tagState).append(')');
                LOG.debug((Object)message.toString());
            }
            return false;
        }
        return true;
    }

    HtmlElement getLastHtmlElement(HtmlElement node) {
        DomNode lastChild = node.getLastChild();
        if (!(lastChild instanceof HtmlElement) || lastChild instanceof HtmlScript) {
            return node;
        }
        return this.getLastHtmlElement((HtmlElement)lastChild);
    }

    @Override
    @JsxGetter
    public String getCookie() {
        HtmlPage page = this.getPage();
        URL url = page.getUrl();
        StringBuilder builder = new StringBuilder();
        Set<Cookie> cookies = page.getWebClient().getCookies(url);
        for (Cookie cookie : cookies) {
            if (cookie.isHttpOnly()) continue;
            if (builder.length() != 0) {
                builder.append("; ");
            }
            if (!"HTMLUNIT_EMPTY_COOKIE".equals(cookie.getName())) {
                builder.append(cookie.getName());
                builder.append('=');
            }
            builder.append(cookie.getValue());
        }
        return builder.toString();
    }

    @JsxSetter
    public void setCookie(String newCookie) {
        HtmlPage page = this.getPage();
        WebClient client = page.getWebClient();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)newCookie) && client.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COOKIES_IGNORE_BLANK)) {
            return;
        }
        client.addCookie(newCookie, this.getPage().getUrl(), this);
    }

    @JsxFunction
    public Object open(Object url, Object name, Object features, Object replace) {
        HtmlPage page = this.getPage();
        if (page.isBeingParsed()) {
            LOG.warn((Object)"Ignoring call to open() during the parsing stage.");
            return null;
        }
        if (!this.writeInCurrentDocument_) {
            LOG.warn((Object)"Function open() called when document is already open.");
        }
        this.writeInCurrentDocument_ = false;
        WebWindow ww = this.getWindow().getWebWindow();
        if (ww instanceof FrameWindow && "about:blank".equals(this.getPage().getUrl().toExternalForm())) {
            URL enclosingUrl = ((FrameWindow)ww).getEnclosingPage().getUrl();
            this.getPage().getWebResponse().getWebRequest().setUrl(enclosingUrl);
        }
        return this;
    }

    @Override
    @JsxFunction(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void close() throws IOException {
        if (this.writeInCurrentDocument_) {
            LOG.warn((Object)"close() called when document is not open.");
        } else {
            BaseFrameElement frame;
            Object scriptable;
            HtmlPage page = this.getPage();
            URL url = page.getUrl();
            StringWebResponse webResponse = new StringWebResponse(this.writeBuilder_.toString(), url);
            webResponse.setFromJavascript(true);
            this.writeInCurrentDocument_ = true;
            this.writeBuilder_.setLength(0);
            WebClient webClient = page.getWebClient();
            WebWindow window = page.getEnclosingWindow();
            if (window instanceof FrameWindow && (scriptable = (frame = ((FrameWindow)window).getFrameElement()).getScriptableObject()) instanceof HTMLIFrameElement) {
                ((HTMLIFrameElement)scriptable).onRefresh();
            }
            webClient.loadWebResponseInto(webResponse, window);
        }
    }

    @Override
    @JsxGetter
    public Element getDocumentElement() {
        this.implicitCloseIfNecessary();
        return super.getDocumentElement();
    }

    private void implicitCloseIfNecessary() {
        if (!this.writeInCurrentDocument_) {
            try {
                this.close();
            }
            catch (IOException e) {
                throw JavaScriptEngine.throwAsScriptRuntimeEx(e);
            }
        }
    }

    @Override
    public Object appendChild(Object childObject) {
        throw JavaScriptEngine.reportRuntimeError("Node cannot be inserted at the specified point in the hierarchy.");
    }

    @Override
    @JsxFunction
    public HtmlUnitScriptable getElementById(String id) {
        this.implicitCloseIfNecessary();
        DomElement domElement = this.getPage().getElementById(id);
        if (null == domElement) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getElementById(" + id + "): no DOM node found with this id"));
            }
            return null;
        }
        HtmlUnitScriptable jsElement = this.getScriptableFor(domElement);
        if (jsElement == NOT_FOUND) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getElementById(" + id + ") cannot return a result as there isn't a JavaScript object for the HTML element " + domElement.getClass().getName()));
            }
            return null;
        }
        return jsElement;
    }

    @Override
    public HTMLCollection getElementsByClassName(String className) {
        return this.getDocumentElement().getElementsByClassName(className);
    }

    @Override
    public NodeList getElementsByName(String elementName) {
        this.implicitCloseIfNecessary();
        if ("null".equals(elementName) || elementName.isEmpty() && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_ELEMENTS_BY_NAME_EMPTY)) {
            return NodeList.staticNodeList(this.getWindow(), new ArrayList<DomNode>());
        }
        HtmlPage page = this.getPage();
        NodeList elements = new NodeList((DomNode)page, true);
        elements.setElementsSupplier((Supplier<List> & Serializable)() -> new ArrayList<DomElement>(page.getElementsByName(elementName)));
        elements.setEffectOnCacheFunction((Function<HtmlAttributeChangeEvent, AbstractList.EffectOnCache> & Serializable)event -> {
            if ("name".equals(event.getName())) {
                return AbstractList.EffectOnCache.RESET;
            }
            return AbstractList.EffectOnCache.NONE;
        });
        return elements;
    }

    @Override
    protected Object getWithPreemption(String name) {
        Object response;
        HtmlPage page = (HtmlPage)this.getDomNodeOrNull();
        if (page == null && (response = this.getPrototype().get(name, (Scriptable)this)) != NOT_FOUND) {
            return response;
        }
        return this.getIt(name);
    }

    private Object getIt(String name) {
        HtmlPage page = (HtmlPage)this.getDomNodeOrNull();
        if (page == null) {
            return NOT_FOUND;
        }
        final boolean alsoFrames = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_GET_ALSO_FRAMES);
        List<DomNode> matchingElements = HTMLDocument.getItComputeElements(page, name, alsoFrames);
        int size = matchingElements.size();
        if (size == 0) {
            return NOT_FOUND;
        }
        if (size == 1) {
            DomNode object = matchingElements.get(0);
            if (alsoFrames && object instanceof BaseFrameElement) {
                return ((BaseFrameElement)object).getEnclosedWindow().getScriptableObject();
            }
            return super.getScriptableFor(object);
        }
        HTMLCollection coll = new HTMLCollection(page, matchingElements){

            @Override
            protected HtmlUnitScriptable getScriptableFor(Object object) {
                if (alsoFrames && object instanceof BaseFrameElement) {
                    return (HtmlUnitScriptable)((BaseFrameElement)object).getEnclosedWindow().getScriptableObject();
                }
                return super.getScriptableFor(object);
            }
        };
        coll.setElementsSupplier((Supplier<List> & Serializable)() -> HTMLDocument.getItComputeElements(page, name, alsoFrames));
        coll.setEffectOnCacheFunction((Function<HtmlAttributeChangeEvent, AbstractList.EffectOnCache> & Serializable)event -> {
            String attributeName = event.getName();
            if ("name".equals(attributeName)) {
                return AbstractList.EffectOnCache.RESET;
            }
            return AbstractList.EffectOnCache.NONE;
        });
        return coll;
    }

    static List<DomNode> getItComputeElements(HtmlPage page, String name, boolean alsoFrames) {
        List<DomElement> elements = page.getElementsByName(name);
        ArrayList<DomNode> matchingElements = new ArrayList<DomNode>();
        for (DomElement elt : elements) {
            if (!(elt instanceof HtmlForm) && !(elt instanceof HtmlImage) && (!alsoFrames || !(elt instanceof BaseFrameElement))) continue;
            matchingElements.add(elt);
        }
        return matchingElements;
    }

    @Override
    public HTMLElement getHead() {
        HtmlElement head = this.getPage().getHead();
        if (head == null) {
            return null;
        }
        return (HTMLElement)head.getScriptableObject();
    }

    @Override
    public String getTitle() {
        return this.getPage().getTitleText();
    }

    @Override
    public void setTitle(String title) {
        this.getPage().setTitleText(title);
    }

    @Override
    public HTMLElement getActiveElement() {
        HtmlElement activeElement = this.getPage().getActiveElement();
        if (activeElement != null) {
            return (HTMLElement)activeElement.getScriptableObject();
        }
        return null;
    }

    @Override
    public boolean hasFocus() {
        return this.getPage().getFocusedElement() != null;
    }

    @Override
    @JsxFunction
    public boolean dispatchEvent(Event event) {
        event.setTarget(this);
        ScriptResult result = this.fireEvent(event);
        return !event.isAborted(result);
    }

    @Override
    public Selection getSelection() {
        return this.getWindow().getSelectionImpl();
    }

    @Override
    public Attr createAttribute(String attributeName) {
        String name = attributeName;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)name)) {
            name = StringUtils.toRootLowerCase(name);
        }
        return super.createAttribute(name);
    }

    @Override
    public String getBaseURI() {
        return this.getPage().getBaseURL().toString();
    }

    @Override
    public HtmlUnitScriptable elementFromPoint(int x, int y) {
        HtmlElement element = this.getPage().getElementFromPoint(x, y);
        return element == null ? null : (HtmlUnitScriptable)element.getScriptableObject();
    }

    private static enum ParsingStatus {
        OUTSIDE,
        START,
        IN_NAME,
        INSIDE,
        IN_STRING;

    }
}

