/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.geo;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.WebClient;
import org.htmlunit.WebClientOptions;
import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import org.htmlunit.javascript.background.JavaScriptJob;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.host.geo.GeolocationCoordinates;
import org.htmlunit.javascript.host.geo.GeolocationPosition;

@JsxClass
public class Geolocation
extends HtmlUnitScriptable {
    private static final Log LOG = LogFactory.getLog(Geolocation.class);
    private Function successHandler_;
    private Function errorHandler_;

    @JsxConstructor
    public void jsConstructor() {
        throw JavaScriptEngine.reportRuntimeError("Illegal constructor.");
    }

    @JsxFunction
    public void getCurrentPosition(Function successCallback, Function errorCallback, Object options) {
        this.successHandler_ = successCallback;
        this.errorHandler_ = errorCallback;
        WebWindow webWindow = this.getWindow().getWebWindow();
        if (webWindow.getWebClient().getOptions().isGeolocationEnabled()) {
            JavaScriptJob job = BackgroundJavaScriptFactory.theFactory().createJavaScriptJob(0, null, () -> this.doGetPosition());
            webWindow.getJobManager().addJob(job, webWindow.getEnclosedPage());
        }
    }

    @JsxFunction
    public int watchPosition(Function successCallback, Object errorCallback, Object options) {
        return 0;
    }

    @JsxFunction
    public void clearWatch(int watchId) {
    }

    void doGetPosition() {
        WebWindow ww = this.getWindow().getWebWindow();
        WebClient webClient = ww.getWebClient();
        WebClientOptions.Geolocation geolocation = webClient.getOptions().getGeolocation();
        GeolocationCoordinates coordinates = new GeolocationCoordinates(geolocation.getLatitude(), geolocation.getLongitude(), geolocation.getAccuracy());
        coordinates.setPrototype(this.getPrototype(coordinates.getClass()));
        GeolocationPosition position = new GeolocationPosition(coordinates);
        position.setPrototype(this.getPrototype(position.getClass()));
        JavaScriptEngine jsEngine = (JavaScriptEngine)ww.getWebClient().getJavaScriptEngine();
        jsEngine.callFunction((HtmlPage)ww.getEnclosedPage(), this.successHandler_, (Scriptable)this, this.getParentScope(), new Object[]{position});
    }
}

