/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSymbol;
import org.htmlunit.javascript.host.dom.Attr;
import org.htmlunit.javascript.host.dom.Node;

@JsxClass
public class NamedNodeMap
extends HtmlUnitScriptable {
    private final org.w3c.dom.NamedNodeMap attributes_;

    public NamedNodeMap() {
        this.attributes_ = null;
    }

    @JsxConstructor
    public void jsConstructor() {
    }

    public NamedNodeMap(DomElement element) {
        this.setParentScope((Scriptable)element.getScriptableObject());
        this.setPrototype(this.getPrototype(this.getClass()));
        this.attributes_ = element.getAttributes();
        this.setDomNode(element, false);
    }

    public final Object get(int index, Scriptable start) {
        NamedNodeMap startMap = (NamedNodeMap)start;
        HtmlUnitScriptable response = startMap.item(index);
        if (response != null) {
            return response;
        }
        return NOT_FOUND;
    }

    @Override
    public Object get(String name, Scriptable start) {
        Object response = super.get(name, start);
        if (response != NOT_FOUND) {
            return response;
        }
        response = this.getNamedItem(name);
        if (response != null) {
            return response;
        }
        return NOT_FOUND;
    }

    public HtmlUnitScriptable getNamedItemWithoutSytheticClassAttr(String name) {
        DomNode attr;
        if (this.attributes_ != null && (attr = (DomNode)this.attributes_.getNamedItem(name)) != null) {
            return attr.getScriptableObject();
        }
        return null;
    }

    @JsxFunction
    public HtmlUnitScriptable getNamedItem(String name) {
        return this.getNamedItemWithoutSytheticClassAttr(name);
    }

    @JsxFunction
    public Node getNamedItemNS(String namespaceURI, String localName) {
        DomNode attr;
        if (this.attributes_ != null && (attr = (DomNode)this.attributes_.getNamedItemNS(namespaceURI, localName)) != null) {
            return (Node)attr.getScriptableObject();
        }
        return null;
    }

    @JsxFunction
    public void setNamedItem(Node node) {
        this.attributes_.setNamedItem(node.getDomNodeOrDie());
    }

    @JsxFunction
    public void setNamedItemNS(Node node) {
        this.attributes_.setNamedItemNS(node.getDomNodeOrDie());
    }

    @JsxFunction
    public void removeNamedItem(String name) {
        this.attributes_.removeNamedItem(name);
    }

    @JsxFunction
    public Attr removeNamedItemNS(String namespaceURI, String localName) {
        return (Attr)((Object)this.attributes_.removeNamedItemNS(namespaceURI, localName));
    }

    @JsxFunction
    public HtmlUnitScriptable item(int index) {
        DomNode attr = (DomNode)this.attributes_.item(index);
        if (attr != null) {
            return attr.getScriptableObject();
        }
        return null;
    }

    @JsxGetter
    public int getLength() {
        return this.attributes_.getLength();
    }

    @Override
    public boolean has(int index, Scriptable start) {
        return index >= 0 && index < this.getLength();
    }

    @JsxSymbol
    public Scriptable iterator() {
        return JavaScriptEngine.newArrayIteratorTypeValues(this.getParentScope(), (Scriptable)this);
    }
}

