/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.background;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.WebClient;
import org.htmlunit.WebWindow;
import org.htmlunit.javascript.background.JavaScriptExecutor;
import org.htmlunit.javascript.background.JavaScriptJob;
import org.htmlunit.javascript.background.JavaScriptJobManager;

public class DefaultJavaScriptExecutor
implements JavaScriptExecutor {
    private final transient WeakReference<WebClient> webClient_;
    private final transient List<WeakReference<JavaScriptJobManager>> jobManagerList_;
    private final transient AtomicBoolean shutdown_;
    private transient Thread eventLoopThread_;
    private static final Log LOG = LogFactory.getLog(DefaultJavaScriptExecutor.class);

    public DefaultJavaScriptExecutor(WebClient webClient) {
        this.webClient_ = new WeakReference<WebClient>(webClient);
        this.jobManagerList_ = new ArrayList<WeakReference<JavaScriptJobManager>>();
        this.shutdown_ = new AtomicBoolean();
    }

    protected void startThreadIfNeeded() {
        if (this.eventLoopThread_ == null) {
            this.eventLoopThread_ = new Thread((Runnable)this, this.getThreadName());
            this.eventLoopThread_.setDaemon(true);
            this.eventLoopThread_.start();
        }
    }

    protected String getThreadName() {
        if (this.shutdown_.get()) {
            return "Stopped JS executor for " + this.webClient_.get();
        }
        return "JS executor for " + this.webClient_.get();
    }

    private void killThread() {
        if (this.eventLoopThread_ == null) {
            return;
        }
        try {
            this.eventLoopThread_.interrupt();
            this.eventLoopThread_.join(10000L);
        }
        catch (InterruptedException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"InterruptedException while waiting for the eventLoop thread to join", (Throwable)e);
            }
            Thread.currentThread().interrupt();
        }
        if (this.eventLoopThread_.isAlive()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Event loop thread " + this.eventLoopThread_.getName() + " still alive at " + System.currentTimeMillis()));
                LOG.warn((Object)"Event loop thread will be stopped");
            }
            this.eventLoopThread_.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaScriptJobManager getJobManagerWithEarliestJob() {
        JavaScriptJobManager javaScriptJobManager = null;
        JavaScriptJob earliestJob = null;
        List<WeakReference<JavaScriptJobManager>> list = this.jobManagerList_;
        synchronized (list) {
            for (WeakReference<JavaScriptJobManager> weakReference : this.jobManagerList_) {
                JavaScriptJob newJob;
                JavaScriptJobManager jobManager = (JavaScriptJobManager)weakReference.get();
                if (jobManager == null || (newJob = jobManager.getEarliestJob()) == null || earliestJob != null && earliestJob.compareTo(newJob) <= 0) continue;
                earliestJob = newJob;
                javaScriptJobManager = jobManager;
            }
        }
        return javaScriptJobManager;
    }

    @Override
    public void run() {
        boolean trace = LOG.isTraceEnabled();
        long sleepInterval = 10L;
        while (!this.shutdown_.get() && !Thread.currentThread().isInterrupted() && this.webClient_.get() != null) {
            long waitTime;
            JavaScriptJob earliestJob;
            JavaScriptJobManager jobManager = this.getJobManagerWithEarliestJob();
            if (jobManager != null && (earliestJob = jobManager.getEarliestJob()) != null && (waitTime = earliestJob.getTargetExecutionTime() - System.currentTimeMillis()) < 1L) {
                if (trace) {
                    LOG.trace((Object)("started executing job at " + System.currentTimeMillis()));
                }
                jobManager.runSingleJob(earliestJob);
                if (!trace) continue;
                LOG.trace((Object)("stopped executing job at " + System.currentTimeMillis()));
                continue;
            }
            if (this.shutdown_.get() || Thread.currentThread().isInterrupted() || this.webClient_.get() == null) break;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void addWindow(WebWindow newWindow) {
        JavaScriptJobManager jobManager = newWindow.getJobManager();
        if (jobManager != null) {
            this.updateJobMangerList(jobManager);
            this.startThreadIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateJobMangerList(JavaScriptJobManager newJobManager) {
        ArrayList<WeakReference<JavaScriptJobManager>> managers = new ArrayList<WeakReference<JavaScriptJobManager>>(this.jobManagerList_.size());
        List<WeakReference<JavaScriptJobManager>> list = this.jobManagerList_;
        synchronized (list) {
            for (WeakReference<JavaScriptJobManager> weakReference : this.jobManagerList_) {
                JavaScriptJobManager manager = (JavaScriptJobManager)weakReference.get();
                if (newJobManager == manager) {
                    return;
                }
                if (null == weakReference.get()) continue;
                managers.add(weakReference);
            }
            managers.add(new WeakReference<JavaScriptJobManager>(newJobManager));
            this.jobManagerList_.clear();
            this.jobManagerList_.addAll(managers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.shutdown_.set(true);
        this.killThread();
        this.webClient_.clear();
        List<WeakReference<JavaScriptJobManager>> list = this.jobManagerList_;
        synchronized (list) {
            this.jobManagerList_.clear();
        }
    }
}

