/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.util.AbstractSequentialList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomNodeList;
import org.w3c.dom.Node;

class SiblingDomNodeList
extends AbstractSequentialList<DomNode>
implements DomNodeList<DomNode> {
    private final DomNode parent_;

    SiblingDomNodeList(DomNode parent) {
        this.parent_ = parent;
    }

    @Override
    public int getLength() {
        int length = 0;
        for (DomNode node = this.parent_.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++length;
        }
        return length;
    }

    @Override
    public int size() {
        return this.getLength();
    }

    @Override
    public Node item(int index) {
        return this.get(index);
    }

    @Override
    public DomNode get(int index) {
        int i = 0;
        for (DomNode node = this.parent_.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (i == index) {
                return node;
            }
            ++i;
        }
        return null;
    }

    @Override
    public ListIterator<DomNode> listIterator(int index) {
        return new SiblingListIterator(index);
    }

    @Override
    public String toString() {
        return "SiblingDomNodeList[" + this.parent_ + "]";
    }

    private class SiblingListIterator
    implements ListIterator<DomNode> {
        private DomNode prev_;
        private DomNode next_;
        private int nextIndex_;

        SiblingListIterator(int index) {
            this.next_ = SiblingDomNodeList.this.parent_.getFirstChild();
            this.nextIndex_ = 0;
            for (int i = 0; i < index; ++i) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.next_ != null;
        }

        @Override
        public DomNode next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prev_ = this.next_;
            this.next_ = this.next_.getNextSibling();
            ++this.nextIndex_;
            return this.prev_;
        }

        @Override
        public boolean hasPrevious() {
            return this.prev_ != null;
        }

        @Override
        public DomNode previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.next_ = this.prev_;
            this.prev_ = this.prev_.getPreviousSibling();
            --this.nextIndex_;
            return this.next_;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex_;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex_ - 1;
        }

        @Override
        public void add(DomNode e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(DomNode e) {
            throw new UnsupportedOperationException();
        }
    }
}

