/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.LabelableElement;

public class HtmlRangeInput
extends HtmlInput
implements LabelableElement {
    HtmlRangeInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        String value = this.getValueAttribute();
        if (value == ATTRIBUTE_NOT_DEFINED) {
            double min = this.getMinNumeric();
            double max = this.getMaxNumeric();
            if (max < min) {
                this.setValue(min);
                this.unmarkValueDirty();
                return;
            }
            double val = min + (max - min) / 2.0;
            this.setValue(val);
            this.unmarkValueDirty();
        } else {
            this.setValue(value);
            this.unmarkValueDirty();
        }
    }

    public double getMinNumeric() {
        String min = this.getAttributeDirect("min");
        if (min == ATTRIBUTE_NOT_DEFINED) {
            return 0.0;
        }
        try {
            return Double.parseDouble(min);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public double getMaxNumeric() {
        String max = this.getAttributeDirect("max");
        if (max == ATTRIBUTE_NOT_DEFINED) {
            return 100.0;
        }
        try {
            return Double.parseDouble(max);
        }
        catch (NumberFormatException e) {
            return 100.0;
        }
    }

    public double getStepNumeric() {
        String step = this.getAttributeDirect("step");
        if (step == ATTRIBUTE_NOT_DEFINED) {
            return 1.0;
        }
        try {
            return Double.parseDouble(step);
        }
        catch (NumberFormatException e) {
            return 1.0;
        }
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void setValue(String newValue) {
        try {
            if (StringUtils.isNotEmpty((CharSequence)newValue)) {
                this.setValue(Double.parseDouble(newValue));
            } else {
                double min = this.getMinNumeric();
                double max = this.getMaxNumeric();
                this.setValue(min + (max - min) / 2.0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void setValue(double newValue) {
        double value = newValue;
        double min = this.getMinNumeric();
        double max = this.getMaxNumeric();
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        double step = this.getStepNumeric();
        int fact = (int)((value -= min) / step);
        double rest = value % step;
        if (rest >= step / 2.0) {
            ++fact;
        }
        if (!Double.isInfinite(value = min + step * (double)fact) && value == Math.floor(value)) {
            super.setValue(Integer.toString((int)value));
        } else {
            super.setValue(Double.toString(value));
        }
    }

    @Override
    protected void valueAttributeChanged(String attributeValue, boolean isValueDirty) {
        if (isValueDirty) {
            return;
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)attributeValue)) {
                this.setRawValue(Double.parseDouble(attributeValue));
            } else {
                double min = this.getMinNumeric();
                double max = this.getMaxNumeric();
                this.setRawValue(min + (max - min) / 2.0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void setRawValue(double newValue) {
        double value = newValue;
        double min = this.getMinNumeric();
        double max = this.getMaxNumeric();
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        double step = this.getStepNumeric();
        int fact = (int)((value -= min) / step);
        double rest = value % step;
        if (rest >= step / 2.0) {
            ++fact;
        }
        if (!Double.isInfinite(value = min + step * (double)fact) && value == Math.floor(value)) {
            this.setRawValue(Integer.toString((int)value));
        } else {
            this.setRawValue(Double.toString(value));
        }
    }

    @Override
    protected boolean isRequiredSupported() {
        return false;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.isMaxValid() && this.isMinValid();
    }

    private boolean isMinValid() {
        if (!this.getRawValue().isEmpty() && !this.getMin().isEmpty()) {
            try {
                double value = Double.parseDouble(this.getRawValue());
                return this.getMinNumeric() <= value;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean isMaxValid() {
        if (!this.getRawValue().isEmpty() && !this.getMax().isEmpty()) {
            try {
                int value = Integer.parseInt(this.getRawValue());
                return this.getMaxNumeric() >= (double)value;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return true;
    }
}

