/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class ProxyConfig
implements Serializable {
    private String proxyHost_;
    private int proxyPort_;
    private String proxyScheme_;
    private boolean isSocksProxy_;
    private final Map<String, Pattern> proxyBypassHosts_ = new HashMap<String, Pattern>();
    private String proxyAutoConfigUrl_;
    private String proxyAutoConfigContent_;

    public ProxyConfig() {
        this(null, 0, null, false);
    }

    public ProxyConfig(String proxyHost, int proxyPort, String proxyScheme) {
        this(proxyHost, proxyPort, proxyScheme, false);
    }

    public ProxyConfig(String proxyHost, int proxyPort, String proxyScheme, boolean isSocks) {
        this.proxyHost_ = proxyHost;
        this.proxyPort_ = proxyPort;
        this.proxyScheme_ = proxyScheme;
        this.isSocksProxy_ = isSocks;
    }

    public String getProxyHost() {
        return this.proxyHost_;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost_ = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort_;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort_ = proxyPort;
    }

    public String getProxyScheme() {
        return this.proxyScheme_;
    }

    public void setProxyPort(String proxyScheme) {
        this.proxyScheme_ = proxyScheme;
    }

    public boolean isSocksProxy() {
        return this.isSocksProxy_;
    }

    public void setSocksProxy(boolean isSocksProxy) {
        this.isSocksProxy_ = isSocksProxy;
    }

    public void addHostsToProxyBypass(String pattern) {
        this.proxyBypassHosts_.put(pattern, Pattern.compile(pattern));
    }

    public void removeHostsFromProxyBypass(String pattern) {
        this.proxyBypassHosts_.remove(pattern);
    }

    protected boolean shouldBypassProxy(String hostname) {
        boolean bypass = false;
        for (Pattern p : this.proxyBypassHosts_.values()) {
            if (!p.matcher(hostname).find()) continue;
            bypass = true;
            break;
        }
        return bypass;
    }

    public String getProxyAutoConfigUrl() {
        return this.proxyAutoConfigUrl_;
    }

    public void setProxyAutoConfigUrl(String proxyAutoConfigUrl) {
        this.proxyAutoConfigUrl_ = proxyAutoConfigUrl;
        this.setProxyAutoConfigContent(null);
    }

    protected String getProxyAutoConfigContent() {
        return this.proxyAutoConfigContent_;
    }

    protected void setProxyAutoConfigContent(String proxyAutoConfigContent) {
        this.proxyAutoConfigContent_ = proxyAutoConfigContent;
    }
}

