/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.uft.utils;

import com.microfocus.application.automation.tools.results.projectparser.performance.XmlParserUtil;
import com.microfocus.application.automation.tools.uft.model.RerunSettingsModel;
import com.microfocus.application.automation.tools.uft.model.UftRunAsUser;
import com.microfocus.application.automation.tools.uft.utils.UftMasterToSlave;
import hudson.FilePath;
import hudson.model.Node;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UftToolUtils {
    private static final Logger logger = Logger.getLogger(UftToolUtils.class.getName());
    private static final String ACTION_TAG = "Action";
    private static final String ACTIONS_XML_TAG = "Actions.xml";

    private UftToolUtils() {
    }

    public static List<RerunSettingsModel> updateRerunSettings(String nodeName, String fsTestPath, List<RerunSettingsModel> rerunSettingsModels) {
        List<String> buildTests = UftToolUtils.getBuildTests(nodeName, fsTestPath);
        int numberOfRerunTests = rerunSettingsModels.size();
        if (buildTests != null && !buildTests.isEmpty()) {
            List<String> testPaths = UftToolUtils.getTests(buildTests, rerunSettingsModels);
            for (String testPath : testPaths) {
                if (UftToolUtils.listContainsTest(rerunSettingsModels, testPath).booleanValue()) continue;
                rerunSettingsModels.add(new RerunSettingsModel(testPath, false, 0, ""));
            }
        }
        if (numberOfRerunTests > 0 && rerunSettingsModels.size() > numberOfRerunTests) {
            rerunSettingsModels.sort(Comparator.comparing(RerunSettingsModel::getTest));
        }
        return rerunSettingsModels;
    }

    public static boolean isMtbxContent(String testContent) {
        return testContent != null && testContent.toLowerCase().contains("<mtbx>");
    }

    public static boolean isMtbxFile(String testContent) {
        return testContent != null && testContent.toLowerCase().endsWith(".mtbx");
    }

    public static List<String> getBuildTests(String nodeName, String fsTestPath) {
        if (fsTestPath == null) {
            return new ArrayList<String>();
        }
        Node node = Jenkins.get().getNode(nodeName);
        String rawTestString = fsTestPath.replace("\\", "/").trim();
        List<String> buildTests = Jenkins.get().getNodes().isEmpty() || node == null ? UftToolUtils.getTests(rawTestString) : UftToolUtils.getTestsFromNode(nodeName, rawTestString);
        return buildTests;
    }

    public static List<String> getTests(String rawTestString) {
        List<Object> buildTests = new ArrayList();
        if (UftToolUtils.isMtbxContent(rawTestString)) {
            buildTests = UftToolUtils.extractTestPathsFromMtbxContent(rawTestString);
        } else if (UftToolUtils.isMtbxFile(rawTestString)) {
            try {
                String fileContent = new String(Files.readAllBytes(Paths.get(rawTestString, new String[0])));
                return UftToolUtils.getTests(fileContent);
            }
            catch (IOException e) {
                logger.info(String.format("Failed to get tests from mtbx file %s : %s", rawTestString, e.getMessage()));
            }
        } else if (rawTestString != null) {
            List<String> tests = Arrays.asList(rawTestString.split("\\r?\\n"));
            String paramFilteredTestPath = UftToolUtils.filterParamFromPath(rawTestString);
            File testFolder = new File(paramFilteredTestPath);
            if (tests.size() == 1 && testFolder.isDirectory()) {
                if (testFolder.exists()) {
                    buildTests = UftToolUtils.listFilesForFolder(new File(paramFilteredTestPath));
                }
            } else {
                for (String test : tests) {
                    File testFile = new File(UftToolUtils.filterParamFromPath(test).trim());
                    if (!testFile.exists()) continue;
                    buildTests = UftToolUtils.getBuildTests(testFile);
                }
            }
        }
        return buildTests;
    }

    private static String filterParamFromPath(String testPath) {
        int firstIndexOfParam = testPath.indexOf(" \"");
        return firstIndexOfParam == -1 ? testPath : testPath.substring(0, firstIndexOfParam);
    }

    public static List<String> extractTestPathsFromMtbxContent(String mtbxContent) {
        ArrayList<String> tests = new ArrayList<String>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(mtbxContent.getBytes()));
            document.getDocumentElement().normalize();
            Element root = document.getDocumentElement();
            NodeList childNodes = root.getChildNodes();
            for (int x = 0; x < childNodes.getLength(); ++x) {
                org.w3c.dom.Node data = childNodes.item(x);
                if (!data.getNodeName().equalsIgnoreCase("Test")) continue;
                tests.add(XmlParserUtil.getNodeAttr("path", data));
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.warning("Failed to extractTestPathsFromMtbxContent : " + e.getMessage());
        }
        return tests;
    }

    private static List<String> getTestsFromNode(String nodeName, String path) {
        Node node = Jenkins.get().getNode(nodeName);
        List<String> tests = new ArrayList<String>();
        String[] paths = path.split("\\n");
        boolean multiLinePath = path.contains("\n");
        for (String pathStr : paths) {
            FilePath filePath = new FilePath(node.getChannel(), pathStr);
            UftMasterToSlave uftMasterToSlave = new UftMasterToSlave(pathStr);
            try {
                if (multiLinePath) {
                    List result = (List)filePath.act((FilePath.FileCallable)uftMasterToSlave);
                    if (result == null) continue;
                    tests.addAll(result);
                    continue;
                }
                tests = (List)filePath.act((FilePath.FileCallable)uftMasterToSlave);
            }
            catch (IOException e) {
                logger.info(String.format("File path not found: %s", e.getMessage()));
            }
            catch (InterruptedException e) {
                logger.info(String.format("Remote operation failed: %s", e.getMessage()));
            }
        }
        return tests;
    }

    public static void deleteReportFoldersFromNode(String nodeName, String testPath, TaskListener listener) {
        FilePath filePath = UftToolUtils.getFilePath(nodeName, testPath);
        try {
            List entries = filePath.list();
            boolean isDeleted = false;
            for (FilePath entry : entries) {
                try {
                    if (entry.getName().startsWith("Report")) {
                        entry.deleteRecursive();
                        listener.getLogger().println(String.format("Folder %s is deleted", entry));
                        isDeleted = true;
                    }
                }
                catch (Exception e) {
                    listener.error(String.format("Failed to delete folder %s : %s", entry.getName(), e.getMessage()));
                }
                try {
                    if (!entry.getName().startsWith("StRes")) continue;
                    entry.deleteRecursive();
                    listener.getLogger().println(String.format("Folder %s is deleted", entry));
                }
                catch (Exception e) {
                    listener.error(String.format("Failed to delete folder %s : %s", entry.getName(), e.getMessage()));
                }
            }
            if (!isDeleted) {
                listener.getLogger().println(String.format("No report folder was deleted", new Object[0]));
            }
        }
        catch (IOException | InterruptedException e) {
            listener.error("Failure in clearing report folders for " + testPath + " : " + e.getMessage());
        }
    }

    public static FilePath getFilePath(String nodeName, String testPath) {
        Node node = Jenkins.get().getNode(nodeName);
        FilePath filePath = Jenkins.get().getNodes().isEmpty() || node == null ? new FilePath(new File(testPath)) : new FilePath(node.getChannel(), testPath);
        return filePath;
    }

    private static List<String> listFilesForFolder(File folder) {
        ArrayList<String> buildTests = new ArrayList<String>();
        if (!folder.isDirectory() && folder.getName().contains("mtbx")) {
            buildTests.add(folder.getPath().trim());
            return buildTests;
        }
        if (folder.isDirectory() && !folder.getName().contains("mtbx") && folder.getName().contains(ACTION_TAG)) {
            buildTests.add(folder.getPath().trim());
        }
        buildTests = UftToolUtils.getBuildTests(folder);
        return buildTests;
    }

    private static List<String> getBuildTests(File folder) {
        ArrayList<String> buildTests = new ArrayList<String>();
        File[] files = folder.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        for (File fileEntry : files) {
            if (fileEntry.isDirectory()) {
                if (!fileEntry.getName().contains(ACTION_TAG)) {
                    buildTests.add(fileEntry.getPath().trim());
                    continue;
                }
                buildTests.add(folder.getPath().trim());
                break;
            }
            if (!fileEntry.isFile() || !fileEntry.getName().endsWith(ACTIONS_XML_TAG)) continue;
            buildTests.add(folder.getPath().trim());
            break;
        }
        return buildTests;
    }

    private static Boolean listContainsTest(List<RerunSettingsModel> rerunSettingModels, String test) {
        for (RerunSettingsModel settings : rerunSettingModels) {
            if (!settings.getTest().trim().equals(test.trim())) continue;
            return true;
        }
        return false;
    }

    private static List<String> getTests(List<String> buildTests, List<RerunSettingsModel> rerunSettingModels) {
        ArrayList<String> rerunTests = new ArrayList<String>();
        if (buildTests == null || rerunSettingModels == null) {
            return rerunTests;
        }
        for (RerunSettingsModel rerun : rerunSettingModels) {
            rerunTests.add(rerun.getTest().trim());
        }
        for (String test : buildTests) {
            if (rerunTests.contains(test)) continue;
            rerunTests.add(test.trim());
        }
        Iterator<RerunSettingsModel> it = rerunSettingModels.iterator();
        while (it.hasNext()) {
            RerunSettingsModel rerunSettingsModel1 = it.next();
            if (buildTests.contains(rerunSettingsModel1.getTest().trim())) continue;
            rerunTests.remove(rerunSettingsModel1.getTest());
            it.remove();
        }
        return rerunTests;
    }

    public static FormValidation doCheckNumberOfReruns(String value) {
        String errorMessage = "You must enter a positive integer number.";
        try {
            int number = Integer.parseInt(value);
            if (StringUtils.isBlank((String)value.trim()) || number < 0) {
                return FormValidation.error((String)errorMessage);
            }
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)errorMessage);
        }
        return FormValidation.ok();
    }

    public static List<String> getNodesList() {
        List nodeList = Jenkins.get().getNodes();
        ArrayList<String> nodes = new ArrayList<String>();
        nodes.add("master");
        for (Node node : nodeList) {
            nodes.add(node.getDisplayName());
        }
        return nodes;
    }

    public static boolean isPrintTestParams(@Nonnull Run<?, ?> build, @Nonnull TaskListener listener) {
        ParametersAction parameterAction = (ParametersAction)build.getAction(ParametersAction.class);
        String msg = "NOTE : The test parameters and their values are printed by default in both Console Output and Results###.xml. You can disable this behavior by defining a job-level parameter UFT_PRINT_TEST_PARAMS as boolean and set it to false.";
        boolean isUftPrintTestParams = true;
        if (parameterAction == null) {
            listener.getLogger().println(msg);
        } else {
            ParameterValue uftPrintTestParams = parameterAction.getParameter("UFT_PRINT_TEST_PARAMS");
            if (uftPrintTestParams == null) {
                listener.getLogger().println(msg);
            } else {
                isUftPrintTestParams = (Boolean)uftPrintTestParams.getValue();
                listener.getLogger().println(String.format("%s = %s", "UFT_PRINT_TEST_PARAMS", isUftPrintTestParams ? "Yes" : "No"));
            }
        }
        return isUftPrintTestParams;
    }

    public static boolean leaveUftOpenIfVisible(@Nonnull Run<?, ?> build, @Nonnull TaskListener listener) {
        ParametersAction parameterAction = (ParametersAction)build.getAction(ParametersAction.class);
        String msg = "Parameter LEAVE_UFT_OPEN_IF_VISIBLE is not set.";
        boolean leaveUftOpen = false;
        if (parameterAction == null) {
            listener.getLogger().println(msg);
        } else {
            ParameterValue leaveUFTOpenIfVisibleParam = parameterAction.getParameter("LEAVE_UFT_OPEN_IF_VISIBLE");
            if (leaveUFTOpenIfVisibleParam == null) {
                listener.getLogger().println(msg);
            } else {
                leaveUftOpen = (Boolean)leaveUFTOpenIfVisibleParam.getValue();
                listener.getLogger().println(String.format("%s = %s", "LEAVE_UFT_OPEN_IF_VISIBLE", leaveUftOpen ? "1" : "0"));
            }
        }
        return leaveUftOpen;
    }

    public static UftRunAsUser getRunAsUser(@Nonnull Run<?, ?> build, @Nonnull TaskListener listener) throws IllegalArgumentException {
        String username;
        ParameterValue paramValuePair;
        ParametersAction paramAction = (ParametersAction)build.getAction(ParametersAction.class);
        UftRunAsUser uftRunAsUser = null;
        if (paramAction != null && (paramValuePair = paramAction.getParameter("UFT_RUN_AS_USER_NAME")) != null && StringUtils.isNotBlank((String)(username = (String)paramValuePair.getValue()))) {
            listener.getLogger().println(String.format("%s = %s", "UFT_RUN_AS_USER_NAME", username));
            paramValuePair = paramAction.getParameter("UFT_RUN_AS_USER_ENCODED_PASSWORD");
            if (paramValuePair == null) {
                uftRunAsUser = UftToolUtils.getRunAsUserWithPassword(paramAction, username);
            } else {
                Secret encodedPwd = (Secret)paramValuePair.getValue();
                if (encodedPwd == null || StringUtils.isBlank((String)encodedPwd.getPlainText())) {
                    uftRunAsUser = UftToolUtils.getRunAsUserWithPassword(paramAction, username);
                } else {
                    Secret pwd;
                    paramValuePair = paramAction.getParameter("UFT_RUN_AS_USER_PASSWORD");
                    if (paramValuePair != null && (pwd = (Secret)paramValuePair.getValue()) != null && StringUtils.isNotBlank((String)pwd.getPlainText())) {
                        throw new IllegalArgumentException(String.format("Please provide either %s or %s, but not both.", "UFT_RUN_AS_USER_PASSWORD", "UFT_RUN_AS_USER_ENCODED_PASSWORD"));
                    }
                    uftRunAsUser = new UftRunAsUser(username, encodedPwd.getPlainText());
                }
            }
        }
        return uftRunAsUser;
    }

    private static UftRunAsUser getRunAsUserWithPassword(ParametersAction paramAction, String username) throws IllegalArgumentException {
        Secret pwd = UftToolUtils.getRunAsUserPassword(paramAction);
        if (pwd == null || StringUtils.isBlank((String)pwd.getPlainText())) {
            throw new IllegalArgumentException(String.format("Either %s or %s is required.", "UFT_RUN_AS_USER_PASSWORD", "UFT_RUN_AS_USER_ENCODED_PASSWORD"));
        }
        return new UftRunAsUser(username, pwd);
    }

    private static Secret getRunAsUserPassword(ParametersAction paramAction) {
        ParameterValue paramValuePair;
        Secret pwd = null;
        if (paramAction != null && (paramValuePair = paramAction.getParameter("UFT_RUN_AS_USER_PASSWORD")) != null) {
            pwd = (Secret)paramValuePair.getValue();
        }
        return pwd;
    }
}

