/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.uft.model;

import com.microfocus.application.automation.tools.model.EnumDescription;
import com.microfocus.application.automation.tools.uft.model.RerunSettingsModel;
import com.microfocus.application.automation.tools.uft.utils.UftToolUtils;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class UftSettingsModel
extends AbstractDescribableImpl<UftSettingsModel> {
    public static final String ENTIRE_TEST_SET = "Rerun the entire set of tests";
    public static final String SPECIFIC_TESTS = "Rerun specific tests in the build";
    public static final String ONLY_FAILED_TESTS = "Rerun only failed tests";
    public static final EnumDescription ANY_BUILD_TEST = new EnumDescription("Rerun the entire set of tests", "Rerun the entire set of tests");
    public static final EnumDescription SPECIFIC_BUILD_TEST = new EnumDescription("Rerun specific tests in the build", "Rerun specific tests in the build");
    public static final EnumDescription FAILED_BUILD_TEST = new EnumDescription("Rerun only failed tests", "Rerun only failed tests");
    public static final List<EnumDescription> fsTestTypes = Arrays.asList(ANY_BUILD_TEST, SPECIFIC_BUILD_TEST, FAILED_BUILD_TEST);
    private String selectedNode;
    private String fsTestPath;
    private String numberOfReruns;
    private String cleanupTest;
    private String onCheckFailedTest;
    private String fsTestType;
    private List<RerunSettingsModel> rerunSettingsModels;

    @DataBoundConstructor
    public UftSettingsModel(String selectedNode, String numberOfReruns, String cleanupTest, String onCheckFailedTest, String fsTestType, List<RerunSettingsModel> rerunSettingsModels) {
        this.selectedNode = selectedNode;
        this.numberOfReruns = numberOfReruns;
        this.cleanupTest = cleanupTest;
        this.onCheckFailedTest = onCheckFailedTest;
        this.fsTestType = fsTestType;
        this.setRerunSettingsModels(UftToolUtils.updateRerunSettings(this.getSelectedNode(), this.getFsTestPath(), rerunSettingsModels));
    }

    public List<String> getNodes() {
        return UftToolUtils.getNodesList();
    }

    public String getSelectedNode() {
        return this.selectedNode;
    }

    @DataBoundSetter
    public void setSelectedNode(String selectedNode) {
        this.selectedNode = selectedNode;
    }

    public String getFsTestPath() {
        return this.fsTestPath;
    }

    public void setFsTestPath(String fsTestPath) {
        this.fsTestPath = fsTestPath;
    }

    public String getNumberOfReruns() {
        return this.numberOfReruns;
    }

    @DataBoundSetter
    public void setNumberOfReruns(String numberOfReruns) {
        this.numberOfReruns = numberOfReruns;
    }

    public String getCleanupTest() {
        return this.cleanupTest;
    }

    @DataBoundSetter
    public void setCleanupTest(String cleanupTest) {
        this.cleanupTest = cleanupTest;
    }

    public String getOnCheckFailedTest() {
        return this.onCheckFailedTest;
    }

    @DataBoundSetter
    public void setOnCheckFailedTest(String onCheckFailedTest) {
        this.onCheckFailedTest = onCheckFailedTest;
    }

    public String getFsTestType() {
        return this.fsTestType;
    }

    @DataBoundSetter
    public void setFsTestType(String fsTestType) {
        this.fsTestType = fsTestType;
    }

    public List<RerunSettingsModel> getRerunSettingsModels() {
        return UftToolUtils.updateRerunSettings(this.selectedNode, this.getFsTestPath(), this.rerunSettingsModels);
    }

    @DataBoundSetter
    public void setRerunSettingsModels(List<RerunSettingsModel> rerunSettingsModels) {
        this.rerunSettingsModels = rerunSettingsModels;
    }

    public List<EnumDescription> getFsTestTypes() {
        return fsTestTypes;
    }

    public void addToProperties(Properties props) {
        if (!StringUtils.isEmpty((String)this.selectedNode)) {
            props.put("Selected node", this.selectedNode);
        }
        String onCheckFailedTestVal = StringUtils.isEmpty((String)this.onCheckFailedTest) ? "false" : this.onCheckFailedTest;
        props.put("onCheckFailedTest", onCheckFailedTestVal);
        props.put("testType", this.fsTestType);
        switch (this.fsTestType) {
            case "Rerun the entire set of tests": {
                this.addPropertiesForEntireSet(props);
                break;
            }
            case "Rerun specific tests in the build": {
                this.addPropertiesForSpecificTests(props);
                break;
            }
            case "Rerun only failed tests": {
                this.addPropertiesForFailedTests(props);
                break;
            }
        }
    }

    private void addPropertiesForEntireSet(Properties props) {
        int i = 1;
        int index = 1;
        while (props.getProperty("Test" + index) != null) {
            props.put("FailedTest" + index, props.getProperty("Test" + index));
            ++index;
        }
        if (!StringUtils.isEmpty((String)this.numberOfReruns)) {
            props.put("Reruns" + i, this.numberOfReruns);
        }
        if (!StringUtils.isEmpty((String)this.cleanupTest)) {
            props.put("CleanupTest" + i, this.cleanupTest);
        }
    }

    private void addPropertiesForSpecificTests(Properties props) {
        int j = 1;
        if (this.rerunSettingsModels != null && !this.rerunSettingsModels.isEmpty()) {
            for (RerunSettingsModel settings : this.rerunSettingsModels) {
                if (!settings.getChecked().booleanValue()) continue;
                props.put("FailedTest" + j, settings.getTest());
                props.put("Reruns" + j, String.valueOf(settings.getNumberOfReruns()));
                if (StringUtils.isEmpty((String)settings.getCleanupTest())) {
                    ++j;
                    continue;
                }
                props.put("CleanupTest" + j, settings.getCleanupTest());
                ++j;
            }
        }
    }

    private void addPropertiesForFailedTests(Properties props) {
        if (!StringUtils.isEmpty((String)this.numberOfReruns)) {
            props.put("Reruns1", this.numberOfReruns);
        }
        if (!StringUtils.isEmpty((String)this.cleanupTest)) {
            props.put("CleanupTest1", this.cleanupTest);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<UftSettingsModel> {
        @Nonnull
        public String getDisplayName() {
            return "Functional Testing Settings Model";
        }

        public FormValidation doCheckNumberOfReruns(@QueryParameter String value) {
            return UftToolUtils.doCheckNumberOfReruns(value);
        }

        public List<EnumDescription> getFsTestTypes() {
            return fsTestTypes;
        }

        public List<String> getNodes() {
            return UftToolUtils.getNodesList();
        }
    }
}

