/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.uft.model;

import com.microfocus.application.automation.tools.EncryptionUtils;
import com.microfocus.application.automation.tools.model.EnumDescription;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Node;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class SpecifyParametersModel
extends AbstractDescribableImpl<SpecifyParametersModel> {
    private static final String PWD = "Password";
    private static final EnumDescription STRING_TYPE = new EnumDescription("String", "String");
    private static final EnumDescription NUMBER_TYPE = new EnumDescription("Number", "Number");
    private static final EnumDescription DATE_TYPE = new EnumDescription("Date", "Date");
    private static final EnumDescription BOOL_TYPE = new EnumDescription("Boolean", "Boolean");
    private static final EnumDescription ANY_TYPE = new EnumDescription("Any", "Any");
    private static final EnumDescription PWD_TYPE = new EnumDescription("Password", "Password");
    public static final List<EnumDescription> paramTypesGUI = Arrays.asList(STRING_TYPE, NUMBER_TYPE, DATE_TYPE, BOOL_TYPE, ANY_TYPE, PWD_TYPE);
    private static final EnumDescription INT_TYPE = new EnumDescription("Int", "Int");
    private static final EnumDescription FLOAT_TYPE = new EnumDescription("Float", "Float");
    private static final EnumDescription DATETIME_TYPE = new EnumDescription("DateTime", "DateTime");
    private static final EnumDescription LONG_TYPE = new EnumDescription("Long", "Long");
    private static final EnumDescription DOUBLE_TYPE = new EnumDescription("Double", "Double");
    private static final EnumDescription DECIMAL_TYPE = new EnumDescription("Decimal", "Decimal");
    public static final List<EnumDescription> paramTypesAPI = Arrays.asList(STRING_TYPE, INT_TYPE, FLOAT_TYPE, DATETIME_TYPE, BOOL_TYPE, LONG_TYPE, DOUBLE_TYPE, DECIMAL_TYPE);
    public static final Map<String, List<EnumDescription>> mapping = new HashMap<String, List<EnumDescription>>();
    public static final int NUM_OF_TYPES = paramTypesAPI.size() + paramTypesGUI.size();
    private String parameterJson;

    @DataBoundConstructor
    public SpecifyParametersModel(String parameterJson) {
        this.parameterJson = parameterJson;
    }

    public String getParameterJson() {
        return this.parameterJson;
    }

    public void setParameterJson(String parameterJson) {
        this.parameterJson = parameterJson;
    }

    public void addProperties(Properties props, String searchStr, Node node) throws Exception {
        JSONArray testParams = (JSONArray)JSONValue.parseStrict((String)this.parameterJson);
        int pidx = 1;
        while (props.getProperty(searchStr + pidx) != null) {
            int currPidx = pidx;
            List relevant = testParams.stream().filter(elem -> Integer.parseInt((String)((JSONObject)elem).get((Object)"index")) == currPidx).collect(Collectors.toList());
            for (int i = 0; i < relevant.size(); ++i) {
                JSONObject curr = (JSONObject)relevant.get(i);
                String name = curr.get((Object)"name").toString();
                String type = curr.get((Object)"type").toString();
                String val = curr.get((Object)"value").toString();
                if (type.equals(PWD) && StringUtils.isNotBlank((CharSequence)val)) {
                    val = EncryptionUtils.encrypt(val, node);
                }
                props.setProperty(String.format("Param%d_Name_%d", currPidx, i + 1), name);
                props.setProperty(String.format("Param%d_Value_%d", currPidx, i + 1), val);
                props.setProperty(String.format("Param%d_Type_%d", currPidx, i + 1), type);
            }
            ++pidx;
        }
    }

    static {
        mapping.put("GUI", paramTypesGUI);
        mapping.put("API", paramTypesAPI);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<SpecifyParametersModel> {
        @Nonnull
        public String getDisplayName() {
            return "Specify test parameters model";
        }

        public List<EnumDescription> getParamTypesGUI() {
            return paramTypesGUI;
        }

        public List<EnumDescription> getParamTypesAPI() {
            return paramTypesAPI;
        }

        public Map<String, List<EnumDescription>> getMapping() {
            return mapping;
        }

        public int getNumOfTypes() {
            return NUM_OF_TYPES;
        }
    }
}

