/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.uft.model;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class FilterTestsModel
extends AbstractDescribableImpl<FilterTestsModel> {
    private String testName;
    private Boolean blockedCheckbox;
    private Boolean failedCheckbox;
    private Boolean notCompletedCheckbox;
    private Boolean noRunCheckbox;
    private Boolean passedCheckbox;

    @DataBoundConstructor
    public FilterTestsModel(String testName, Boolean blockedCheckbox, Boolean failedCheckbox, Boolean notCompletedCheckbox, Boolean noRunCheckbox, Boolean passedCheckbox) {
        this.testName = testName;
        this.blockedCheckbox = blockedCheckbox;
        this.failedCheckbox = failedCheckbox;
        this.notCompletedCheckbox = notCompletedCheckbox;
        this.noRunCheckbox = noRunCheckbox;
        this.passedCheckbox = passedCheckbox;
    }

    public String getTestName() {
        return this.testName;
    }

    @DataBoundSetter
    public void setTestName(String testName) {
        this.testName = testName;
    }

    public Boolean getBlockedCheckbox() {
        return this.blockedCheckbox;
    }

    public void setBlockedCheckbox(Boolean blockedCheckbox) {
        this.blockedCheckbox = blockedCheckbox;
    }

    public Boolean getFailedCheckbox() {
        return this.failedCheckbox;
    }

    public void setFailedCheckbox(Boolean failedCheckbox) {
        this.failedCheckbox = failedCheckbox;
    }

    public Boolean getNotCompletedCheckbox() {
        return this.notCompletedCheckbox;
    }

    public void setNotCompletedCheckbox(Boolean notCompletedCheckbox) {
        this.notCompletedCheckbox = notCompletedCheckbox;
    }

    public Boolean getNoRunCheckbox() {
        return this.noRunCheckbox;
    }

    public void setNoRunCheckbox(Boolean noRunCheckbox) {
        this.noRunCheckbox = noRunCheckbox;
    }

    public Boolean getPassedCheckbox() {
        return this.passedCheckbox;
    }

    public void setPassedCheckbox(Boolean passedCheckbox) {
        this.passedCheckbox = passedCheckbox;
    }

    public void addProperties(Properties props) {
        props.put("FilterTests", "true");
        props.put("FilterByName", this.testName);
        StringBuilder statusList = new StringBuilder();
        this.addStatus(this.blockedCheckbox, "Blocked", statusList);
        this.addStatus(this.failedCheckbox, "Failed", statusList);
        this.addStatus(this.notCompletedCheckbox, "\"Not Completed\"", statusList);
        this.addStatus(this.noRunCheckbox, "\"No Run\"", statusList);
        this.addStatus(this.passedCheckbox, "Passed", statusList);
        if (statusList.length() > 0) {
            statusList.replace(statusList.lastIndexOf(","), statusList.lastIndexOf(" "), "");
        }
        props.put("FilterByStatus", statusList.toString());
    }

    public void addStatus(boolean status, String statusName, StringBuilder statusList) {
        if (status) {
            statusList.append(statusName);
            statusList.append(", ");
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<FilterTestsModel> {
        @Nonnull
        public String getDisplayName() {
            return "Filter tests model";
        }
    }
}

