/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.sv.runner;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.microfocus.application.automation.tools.model.SvServerSettingsModel;
import com.microfocus.application.automation.tools.settings.SvServerSettingsGlobalConfiguration;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;

public abstract class AbstractSvRunDescriptor
extends BuildStepDescriptor<Builder> {
    private final String displayName;

    protected AbstractSvRunDescriptor(String displayName) {
        this.displayName = displayName;
        this.load();
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    @Nonnull
    public String getDisplayName() {
        return this.displayName;
    }

    public SvServerSettingsModel[] getServers() {
        return SvServerSettingsGlobalConfiguration.getInstance().getServers();
    }

    public ListBoxModel doFillServerNameItems(@AncestorInPath Item project, @QueryParameter String serverName) {
        if (project == null || !project.hasPermission(Item.CONFIGURE)) {
            return new StandardListBoxModel().includeCurrentValue(serverName);
        }
        StandardListBoxModel items = new StandardListBoxModel();
        SvServerSettingsModel[] servers = this.getServers();
        if (servers != null) {
            for (SvServerSettingsModel server : servers) {
                if (!StringUtils.isNotBlank((String)server.getName())) continue;
                items.add(server.getName(), server.getName());
            }
        }
        return items;
    }
}

