/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.sv.runner;

import com.microfocus.application.automation.tools.model.SvServerSettingsModel;
import com.microfocus.application.automation.tools.model.SvServiceSelectionModel;
import com.microfocus.application.automation.tools.sv.model.AbstractSvRunModel;
import com.microfocus.application.automation.tools.sv.runner.AbstractSvRemoteRunner;
import com.microfocus.application.automation.tools.sv.runner.AbstractSvRunDescriptor;
import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSvRunBuilder<T extends AbstractSvRunModel>
extends Builder
implements SimpleBuildStep {
    private static final Logger LOG = Logger.getLogger(AbstractSvRunBuilder.class.getName());
    protected final T model;

    protected AbstractSvRunBuilder(T model) {
        this.model = model;
    }

    protected static void verifyNotNull(Object value, String errorMessage) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public T getModel() {
        return this.model;
    }

    public SvServiceSelectionModel getServiceSelection() {
        return ((AbstractSvRunModel)this.model).getServiceSelection();
    }

    protected SvServerSettingsModel getSelectedServerSettings() throws IllegalArgumentException {
        SvServerSettingsModel[] servers = ((AbstractSvRunDescriptor)this.getDescriptor()).getServers();
        if (servers != null) {
            for (SvServerSettingsModel serverSettings : servers) {
                if (((AbstractSvRunModel)this.model).getServerName() == null || !((AbstractSvRunModel)this.model).getServerName().equals(serverSettings.getName())) continue;
                return serverSettings;
            }
        }
        throw new IllegalArgumentException("Selected server configuration '" + ((AbstractSvRunModel)this.model).getServerName() + "' does not exist.");
    }

    protected abstract AbstractSvRemoteRunner<T> getRemoteRunner(@Nonnull FilePath var1, TaskListener var2, SvServerSettingsModel var3);

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        Date startDate = new Date();
        try {
            SvServerSettingsModel serverModel = this.getSelectedServerSettings();
            logger.printf("%nStarting %s for SV Server '%s' (%s as %s, ignoreSslErrors=%s) on %s%n", this.getDescriptor().getDisplayName(), serverModel.getName(), serverModel.getUrlObject(), serverModel.getUsername(), serverModel.isTrustEveryone(), startDate);
            this.logConfig(logger, "    ");
            this.validateServiceSelection();
            SvServerSettingsModel server = this.getSelectedServerSettings();
            AbstractSvRemoteRunner<T> runner = this.getRemoteRunner(workspace, listener, server);
            launcher.getChannel().call(runner);
        }
        catch (Exception e) {
            try {
                LOG.log(Level.SEVERE, "Build failed: " + e.getMessage(), e);
                throw new AbortException(e.getMessage());
            }
            catch (Throwable throwable) {
                double duration = (double)(new Date().getTime() - startDate.getTime()) / 1000.0;
                logger.printf("Finished: %s in %.3f seconds%n%n", this.getDescriptor().getDisplayName(), duration);
                throw throwable;
            }
        }
        double duration = (double)(new Date().getTime() - startDate.getTime()) / 1000.0;
        logger.printf("Finished: %s in %.3f seconds%n%n", this.getDescriptor().getDisplayName(), duration);
    }

    protected void logConfig(PrintStream logger, String prefix) {
        SvServiceSelectionModel ss = ((AbstractSvRunModel)this.model).getServiceSelection();
        switch (ss.getSelectionType()) {
            case SERVICE: {
                logger.println(prefix + "Service name or id: " + ss.getService());
                break;
            }
            case PROJECT: {
                logger.println(prefix + "Project path: " + ss.getProjectPath());
                logger.println(prefix + "Project password: " + (StringUtils.isNotBlank((String)ss.getProjectPassword()) ? "*****" : null));
                break;
            }
            case ALL_DEPLOYED: {
                logger.println(prefix + "All deployed services");
                break;
            }
            case DEPLOY: {
                logger.println(prefix + "Project path: " + ss.getProjectPath());
                logger.println(prefix + "Project password: " + (StringUtils.isNotBlank((String)ss.getProjectPassword()) ? "*****" : null));
                logger.println(prefix + "Service name or id: " + ss.getService());
            }
        }
        logger.println(prefix + "Force: " + ((AbstractSvRunModel)this.model).isForce());
    }

    protected void validateServiceSelection() throws IllegalArgumentException {
        SvServiceSelectionModel s = this.getServiceSelection();
        switch (s.getSelectionType()) {
            case SERVICE: {
                AbstractSvRunBuilder.verifyNotNull(s.getService(), "Service name or id must not be empty if service selection by name or id set");
                break;
            }
            case PROJECT: {
                AbstractSvRunBuilder.verifyNotNull(s.getProjectPath(), "Project path must not be empty if service selection by project is set");
                break;
            }
            case ALL_DEPLOYED: {
                break;
            }
            case DEPLOY: {
                AbstractSvRunBuilder.verifyNotNull(s.getProjectPath(), "Project path must not be empty for deployment");
            }
        }
    }
}

