/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.sse.sdk.handler;

import com.microfocus.application.automation.tools.model.CdaDetails;
import com.microfocus.application.automation.tools.sse.sdk.ALMRunReportUrlBuilder;
import com.microfocus.application.automation.tools.sse.sdk.Args;
import com.microfocus.application.automation.tools.sse.sdk.Client;
import com.microfocus.application.automation.tools.sse.sdk.Response;
import com.microfocus.application.automation.tools.sse.sdk.RunResponse;
import com.microfocus.application.automation.tools.sse.sdk.handler.Handler;
import com.microfocus.application.automation.tools.sse.sdk.request.StartRunEntityRequest;
import com.microfocus.application.automation.tools.sse.sdk.request.StopEntityRequest;

public abstract class RunHandler
extends Handler {
    protected abstract String getStartSuffix();

    public abstract String getNameSuffix();

    public RunHandler(Client client, String entityId) {
        super(client, entityId);
    }

    public Response start(String duration, String postRunAction, String environmentConfigurationId, CdaDetails cdaDetails) {
        return new StartRunEntityRequest(this._client, this.getStartSuffix(), this._entityId, duration, postRunAction, environmentConfigurationId, cdaDetails).execute();
    }

    public Response stop() {
        return new StopEntityRequest(this._client, this._runId).execute();
    }

    public String getReportUrl(Args args) {
        return new ALMRunReportUrlBuilder().build(this._client, this._client.getServerUrl(), args.getDomain(), args.getProject(), this._runId);
    }

    public RunResponse getRunResponse(Response response) {
        RunResponse ret = new RunResponse();
        ret.initialize(response);
        return ret;
    }
}

