/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.sse.sdk.handler;

import com.microfocus.application.automation.tools.sse.common.StringUtils;
import com.microfocus.application.automation.tools.sse.common.XPathUtils;
import com.microfocus.application.automation.tools.sse.sdk.Client;
import com.microfocus.application.automation.tools.sse.sdk.Logger;
import com.microfocus.application.automation.tools.sse.sdk.Response;
import com.microfocus.application.automation.tools.sse.sdk.handler.EventLogHandler;
import com.microfocus.application.automation.tools.sse.sdk.handler.PollHandler;
import com.microfocus.application.automation.tools.sse.sdk.request.GetLabRunEntityDataRequest;
import com.microfocus.application.automation.tools.sse.sdk.request.PollSSERunRequest;

public class LabPollHandler
extends PollHandler {
    private EventLogHandler _eventLogHandler;

    public LabPollHandler(Client client, String entityId) {
        super(client, entityId);
    }

    public LabPollHandler(Client client, String entityId, int interval) {
        super(client, entityId, interval);
    }

    @Override
    protected boolean doPoll(Logger logger) throws InterruptedException {
        boolean ret = false;
        Response runEntityResponse = this.getRunEntityData();
        if (this.isOk(runEntityResponse, logger)) {
            this.setTimeslotId(runEntityResponse, logger);
            this._eventLogHandler = new EventLogHandler(this._client, this._timeslotId);
            if (!StringUtils.isNullOrEmpty(this._timeslotId)) {
                ret = super.doPoll(logger);
            }
        }
        return ret;
    }

    @Override
    protected Response getResponse() {
        return new PollSSERunRequest(this._client, this._runId).execute();
    }

    @Override
    protected void log(Logger logger) {
        this._eventLogHandler.log(logger);
    }

    @Override
    protected boolean isFinished(Response response, Logger logger) {
        boolean ret = false;
        try {
            String xml = response.toString();
            String endTime = XPathUtils.getAttributeValue(xml, "end-time");
            if (!StringUtils.isNullOrEmpty(endTime)) {
                String startTime = XPathUtils.getAttributeValue(xml, "start-time");
                String currentRunState = XPathUtils.getAttributeValue(xml, "state");
                logger.log(String.format("Timeslot %s is %s.\nRun start time: %s, Run end time: %s", this._timeslotId, currentRunState, startTime, endTime));
                ret = true;
            }
        }
        catch (Throwable cause) {
            logger.log(String.format("Failed to parse response: %s", response));
            ret = true;
        }
        return ret;
    }

    @Override
    protected boolean logRunEntityResults(Response response, Logger logger) {
        boolean ret = false;
        try {
            String xml = response.toString();
            String state = XPathUtils.getAttributeValue(xml, "state");
            String completedSuccessfully = XPathUtils.getAttributeValue(xml, "completed-successfully");
            logger.log(String.format("Run state of %s: %s, Completed successfully: %s", this._runId, state, completedSuccessfully));
            ret = true;
        }
        catch (Throwable cause) {
            logger.log(String.format("Failed to parse response: %s", response));
        }
        return ret;
    }

    private void setTimeslotId(Response runEntityResponse, Logger logger) {
        this._timeslotId = this.getTimeslotId(runEntityResponse, logger);
        if (!StringUtils.isNullOrEmpty(this._timeslotId)) {
            logger.log(String.format("Timeslot id: %s", this._timeslotId));
        }
    }

    private Response getRunEntityData() {
        return new GetLabRunEntityDataRequest(this._client, this._runId).execute();
    }

    private String getTimeslotId(Response response, Logger logger) {
        String ret = "";
        try {
            String xml = response.toString();
            ret = XPathUtils.getAttributeValue(xml, "reservation-id");
        }
        catch (Throwable cause) {
            logger.log(String.format("Failed to parse response for timeslot ID: %s", response));
        }
        return ret;
    }

    @Override
    protected Response getRunEntityResultsResponse() {
        return new GetLabRunEntityDataRequest(this._client, this._runId).execute();
    }
}

