/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.sse.sdk.handler;

import com.microfocus.application.automation.tools.sse.common.XPathUtils;
import com.microfocus.application.automation.tools.sse.sdk.Client;
import com.microfocus.application.automation.tools.sse.sdk.Logger;
import com.microfocus.application.automation.tools.sse.sdk.Response;
import com.microfocus.application.automation.tools.sse.sdk.handler.Handler;
import com.microfocus.application.automation.tools.sse.sdk.request.EventLogRequest;
import java.util.List;
import java.util.Map;

public class EventLogHandler
extends Handler {
    private String _timeslotId = "";
    private int _lastRead = -1;

    public EventLogHandler(Client client, String timeslotId) {
        super(client, timeslotId);
        this._timeslotId = timeslotId;
    }

    public boolean log(Logger logger) {
        boolean ret = false;
        Response eventLog = null;
        try {
            eventLog = this.getEventLog();
            String xml = eventLog.toString();
            List<Map<String, String>> entities = XPathUtils.toEntities(xml);
            for (Map<String, String> currEntity : entities) {
                if (!this.isNew(currEntity)) continue;
                logger.log(String.format("%s:%s", currEntity.get("creation-time"), currEntity.get("description")));
            }
            ret = true;
        }
        catch (Throwable cause) {
            logger.log(String.format("Failed to print Event Log: %s (run id: %s, reservation id: %s). Cause: %s", eventLog, this._runId, this._timeslotId, cause));
        }
        return ret;
    }

    private boolean isNew(Map<String, String> currEntity) {
        boolean ret = false;
        int currEvent = Integer.parseInt(currEntity.get("id"));
        if (currEvent > this._lastRead) {
            this._lastRead = currEvent;
            ret = true;
        }
        return ret;
    }

    private Response getEventLog() {
        return new EventLogRequest(this._client, this._timeslotId).execute();
    }
}

