/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.sse.sdk.authenticator;

import com.microfocus.application.automation.tools.sse.sdk.Base64Encoder;
import com.microfocus.application.automation.tools.sse.sdk.Client;
import com.microfocus.application.automation.tools.sse.sdk.Logger;
import com.microfocus.application.automation.tools.sse.sdk.ResourceAccessLevel;
import com.microfocus.application.automation.tools.sse.sdk.Response;
import com.microfocus.application.automation.tools.sse.sdk.authenticator.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RestAuthenticator
implements Authenticator {
    public static final String IS_AUTHENTICATED = "rest/is-authenticated";
    public static final String AUTHENTICATE_HEADER = "WWW-Authenticate";
    public static final String AUTHENTICATION_INFO = "AuthenticationInfo";
    public static final String USER_NAME = "Username";
    public static final String AUTHENTICATE_POINT = "authentication-point/authenticate";
    private String authenticationPoint;
    private Logger logger;

    @Override
    public boolean login(Client client, String username, String password, String clientType, Logger logger) {
        this.logger = logger;
        this.logger.log("Start login to ALM server...");
        if (this.isAuthenticated(client)) {
            return true;
        }
        this.prepareAuthenticationPoint(client);
        boolean ret = this.authenticate(client, this.authenticationPoint, username, password);
        if (ret) {
            ret = this.appendQCSessionCookies(client, clientType);
        }
        return ret;
    }

    private void prepareAuthenticationPoint(Client client) {
        if (this.authenticationPoint != null && !this.isAuthenticatePointRight(this.authenticationPoint, client.getServerUrl())) {
            this.authenticationPoint = null;
        }
        if (this.authenticationPoint == null) {
            this.authenticationPoint = client.getServerUrl().endsWith("/") ? client.getServerUrl() + AUTHENTICATE_POINT : client.getServerUrl() + "/authentication-point/authenticate";
        }
        this.logger.log("Try to authenticate through: " + this.authenticationPoint);
    }

    private boolean isAuthenticatePointRight(String authenticatePointStr, String serverUrlStr) {
        boolean result;
        URL authenticatePoint;
        URL serverUrl;
        try {
            serverUrl = new URL(serverUrlStr);
        }
        catch (MalformedURLException e) {
            this.logger.log(String.format("Server url %s is not a valid url.", e.getMessage()));
            return false;
        }
        try {
            authenticatePoint = new URL(authenticatePointStr);
        }
        catch (MalformedURLException e) {
            this.logger.log(String.format("Authenticate Point url %s is not a valid url.", e.getMessage()));
            return false;
        }
        boolean bl = result = serverUrl.getProtocol().equalsIgnoreCase(authenticatePoint.getProtocol()) && serverUrl.getPort() == authenticatePoint.getPort();
        if (!result) {
            this.logger.log("Authenticate point schema or port is different with server's. Please check with ALM site admin.");
        }
        return result;
    }

    private boolean authenticate(Client client, String loginUrl, String username, String password) {
        byte[] credBytes = (username + ":" + password).getBytes();
        String credEncodedString = "Basic " + Base64Encoder.encode(credBytes);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", credEncodedString);
        Response response = client.httpGet(loginUrl, null, headers, ResourceAccessLevel.PUBLIC);
        boolean ret = response.isOk();
        if (ret) {
            this.logger.log(String.format("Logged in successfully to ALM Server %s using %s", client.getServerUrl(), username));
        } else {
            this.logger.log(String.format("Login to ALM Server at %s failed. Status Code: %s", client.getServerUrl(), response.getStatusCode()));
        }
        return ret;
    }

    @Override
    public boolean logout(Client client, String username) {
        Response response = client.httpGet(client.build("authentication-point/logout"), null, null, ResourceAccessLevel.PUBLIC);
        return response.isOk();
    }

    private boolean isAuthenticated(Client client) {
        Response response = client.httpGet(client.build(IS_AUTHENTICATED), null, null, ResourceAccessLevel.PUBLIC);
        if (this.checkAuthResponse(response, client.getUsername())) {
            return true;
        }
        this.authenticationPoint = this.getAuthenticatePoint(response);
        if (this.authenticationPoint == null) {
            this.logger.log(String.format("Failed to get authenticate authenticate point. Exception %s", response.getFailure()));
        } else {
            this.authenticationPoint = this.authenticationPoint.replace("\"", "");
            this.authenticationPoint = this.authenticationPoint + "/authenticate";
            this.logger.log("Got authenticate point:" + this.authenticationPoint);
        }
        return false;
    }

    private boolean checkAuthResponse(Response response, String authUser) {
        if (response.getStatusCode() == 200) {
            if (response.getData() != null && new String(response.getData()).contains(AUTHENTICATION_INFO) && new String(response.getData()).contains(USER_NAME) && new String(response.getData()).contains(authUser)) {
                this.logger.log(String.format("Already logged in to ALM Server using %s", authUser));
                return true;
            }
            this.logger.log("Failed to check authenticate response header.");
            return false;
        }
        if (response.getStatusCode() == 401) {
            this.logger.log(String.format("User %s unauthorized.", authUser));
            return false;
        }
        this.logger.log(String.format("Failed to check authenticate status. Exception: %s", response.getFailure()));
        return false;
    }

    private String getAuthenticatePoint(Response response) {
        Map<String, List<String>> headers = response.getHeaders();
        if (headers == null || headers.size() == 0) {
            return null;
        }
        if (headers.get(AUTHENTICATE_HEADER) == null || headers.get(AUTHENTICATE_HEADER).isEmpty()) {
            return null;
        }
        String authenticateHeader = headers.get(AUTHENTICATE_HEADER).get(0);
        String[] authenticateHeaderArray = authenticateHeader.split("=");
        if (authenticateHeaderArray.length == 1) {
            return null;
        }
        return authenticateHeaderArray[1];
    }

    private boolean appendQCSessionCookies(Client client, String clientType) {
        this.logger.log("Creating session...");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        headers.put("Accept", "application/xml");
        Response response = client.httpPost(client.build("rest/site-session"), this.generateClientTypeData(clientType), headers, ResourceAccessLevel.PUBLIC);
        boolean ret = response.isOk();
        if (!ret) {
            this.logger.log(String.format("Cannot append QCSession cookies. Exception: %s", response.getFailure()));
        } else {
            this.logger.log("Session created.");
        }
        return ret;
    }

    private byte[] generateClientTypeData(String clientType) {
        String data = String.format("<session-parameters><client-type>%s</client-type></session-parameters>", clientType);
        return data.getBytes();
    }
}

