/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.sse.sdk.authenticator;

import com.microfocus.application.automation.tools.sse.sdk.Client;
import com.microfocus.application.automation.tools.sse.sdk.Logger;
import com.microfocus.application.automation.tools.sse.sdk.authenticator.ApiKeyAuthenticator;
import com.microfocus.application.automation.tools.sse.sdk.authenticator.Authenticator;
import com.microfocus.application.automation.tools.sse.sdk.authenticator.RestAuthenticator;
import java.util.ArrayList;
import java.util.List;

public class AuthenticationTool {
    private List<Authenticator> authenticators = new ArrayList<Authenticator>();
    private static AuthenticationTool instance;

    private AuthenticationTool() {
        this.authenticators.add(new RestAuthenticator());
        this.authenticators.add(new ApiKeyAuthenticator());
    }

    public static synchronized AuthenticationTool getInstance() {
        if (instance == null) {
            instance = new AuthenticationTool();
        }
        return instance;
    }

    public boolean authenticate(Client client, String username, String password, String url, String clientType, Logger logger) {
        boolean result = false;
        for (Authenticator authenticator : this.authenticators) {
            try {
                result = authenticator.login(client, username, password, clientType, logger);
                if (!result) continue;
                break;
            }
            catch (Exception e) {
                logger.error(String.format("Failed login to ALM Server URL: (%s). Exception: %s", url.endsWith("/") ? url : String.format("%s/", url), e.getMessage()));
            }
        }
        return result;
    }
}

