/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.sse.result;

import com.microfocus.application.automation.tools.common.SSEException;
import com.microfocus.application.automation.tools.sse.common.StringUtils;
import com.microfocus.application.automation.tools.sse.result.model.junit.Error;
import com.microfocus.application.automation.tools.sse.result.model.junit.Testcase;
import com.microfocus.application.automation.tools.sse.result.model.junit.Testsuite;
import com.microfocus.application.automation.tools.sse.result.model.junit.Testsuites;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JUnitParser {
    private String entityId;

    public Testsuites toModel(List<Map<String, String>> testInstanceRuns, String entityId, String entityName, String runEntityId, String url, String domain, String project) {
        this.entityId = entityId;
        Map<String, Testsuite> testSetIdToTestsuite = this.getTestSets(testInstanceRuns);
        this.addTestcases(testInstanceRuns, testSetIdToTestsuite, entityName, runEntityId, url, domain, project);
        return this.createTestsuites(testSetIdToTestsuite);
    }

    private Testsuites createTestsuites(Map<String, Testsuite> testSetIdToTestsuite) {
        Testsuites ret = new Testsuites();
        List<Testsuite> testsuites = ret.getTestsuite();
        for (Testsuite currTestsuite : testSetIdToTestsuite.values()) {
            testsuites.add(currTestsuite);
        }
        return ret;
    }

    private void addTestcases(List<Map<String, String>> testInstanceRuns, Map<String, Testsuite> testSetIdToTestsuite, String bvsName, String runEntityId, String url, String domain, String project) {
        for (Map<String, String> currEntity : testInstanceRuns) {
            this.addTestcase(testSetIdToTestsuite, currEntity, bvsName, runEntityId, url, domain, project);
        }
    }

    private void addTestcase(Map<String, Testsuite> testSetIdToTestsuite, Map<String, String> currEntity, String bvsName, String runEntityId, String url, String domain, String project) {
        testSetIdToTestsuite.get(this.getTestSetId(currEntity)).getTestcase().add(this.getTestcase(currEntity, bvsName, runEntityId, url, domain, project));
    }

    private Testcase getTestcase(Map<String, String> entity, String bvsName, String runEntityId, String url, String domain, String project) {
        Testcase ret = new Testcase();
        ret.setClassname(this.getTestSetName(entity, bvsName, runEntityId));
        ret.setName(this.getTestName(entity));
        ret.setTime(this.getTime(entity));
        ret.setType(entity.get("test-subtype"));
        new TestcaseStatusUpdater().update(ret, entity, url, domain, project);
        return ret;
    }

    private String getTestSetName(Map<String, String> entity, String bvsName, String runEntityId) {
        String ret = String.format("%s.(Unnamed test set)", bvsName);
        String testSetName = entity.get("testset-name");
        if (!StringUtils.isNullOrEmpty(testSetName)) {
            ret = String.format("%s (id:%s).%s", bvsName, this.entityId, testSetName);
        }
        return ret;
    }

    private String getTestName(Map<String, String> entity) {
        String testName = entity.get("test-config-name");
        if (StringUtils.isNullOrEmpty(testName)) {
            testName = "Unnamed test";
        }
        return String.format("%s", testName);
    }

    private String getTime(Map<String, String> entity) {
        String ret = entity.get("duration");
        if (StringUtils.isNullOrEmpty(ret)) {
            ret = "0";
        }
        return ret;
    }

    private Map<String, Testsuite> getTestSets(List<Map<String, String>> testInstanceRuns) {
        HashMap<String, Testsuite> ret = new HashMap<String, Testsuite>();
        for (Map<String, String> currEntity : testInstanceRuns) {
            String testSetId = this.getTestSetId(currEntity);
            if (ret.containsKey(testSetId)) continue;
            ret.put(testSetId, new Testsuite());
        }
        return ret;
    }

    private String getTestSetId(Map<String, String> entity) {
        return entity.get("testcycl-id");
    }

    private static class TestcaseStatusUpdater {
        private TestcaseStatusUpdater() {
        }

        public void update(Testcase testcase, Map<String, String> entity, String url, String domain, String project) {
            String errorMessage;
            String status = entity.get("status");
            testcase.setStatus(this.getJenkinsStatus(status));
            if (testcase.getStatus().equals("error") && (errorMessage = status) != null) {
                Error error = new Error();
                error.setMessage(String.format("Error: %s. %s", errorMessage, this.getTestInstanceRunLink(entity, url, domain, project)));
                testcase.getError().add(error);
            }
        }

        private String getTestInstanceRunLink(Map<String, String> entity, String url, String domain, String project) {
            String ret = "";
            String runId = entity.get("run-id");
            if (!StringUtils.isNullOrEmpty(runId)) {
                try {
                    ret = String.format("To see the test instance run in ALM, go to: td://%s.%s.%s:8080/qcbin/[TestRuns]?EntityLogicalName=run&EntityID=%s", project, domain, new URL(url).getHost(), runId);
                }
                catch (MalformedURLException ex) {
                    throw new SSEException(ex);
                }
            }
            return ret;
        }

        private String getJenkinsStatus(String status) {
            return !StringUtils.isNullOrEmpty(status) && "Passed".equals(status) ? "pass" : "error";
        }
    }
}

