/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.sse.autenvironment;

import com.microfocus.application.automation.tools.common.SSEException;
import com.microfocus.application.automation.tools.model.AUTEnvironmentResolvedModel;
import com.microfocus.application.automation.tools.sse.autenvironment.request.get.GetAutEnvironmentByIdOldApiRequest;
import com.microfocus.application.automation.tools.sse.autenvironment.request.get.GetAutEnvironmentByIdRequest;
import com.microfocus.application.automation.tools.sse.autenvironment.request.get.GetAutEnvironmentConfigurationByIdRequest;
import com.microfocus.application.automation.tools.sse.autenvironment.request.post.CreateAutEnvConfRequest;
import com.microfocus.application.automation.tools.sse.common.StringUtils;
import com.microfocus.application.automation.tools.sse.common.XPathUtils;
import com.microfocus.application.automation.tools.sse.sdk.Client;
import com.microfocus.application.automation.tools.sse.sdk.Logger;
import com.microfocus.application.automation.tools.sse.sdk.Response;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class AUTEnvironmentManager {
    public static final String ALM_AUT_ENVIRONMENT_CONFIGURATION_ID_FIELD = "id";
    private Logger logger;
    private Client client;

    public AUTEnvironmentManager(Client client, Logger logger) {
        this.client = client;
        this.logger = logger;
    }

    public String getParametersRootFolderIdByAutEnvId(String autEnvironmentId) {
        String parametersRootFolderId = null;
        Response response = new GetAutEnvironmentByIdRequest(this.client, autEnvironmentId).execute();
        if (!response.isOk() && response.getStatusCode() == 404) {
            response = new GetAutEnvironmentByIdOldApiRequest(this.client, autEnvironmentId).execute();
        }
        try {
            List<Map<String, String>> entities = XPathUtils.toEntities(response.toString());
            if (!response.isOk() || entities.size() != 1) {
                throw new SSEException(String.format("Failed to get AUT Environment with ID: [%s]", autEnvironmentId), response.getFailure());
            }
            Map<String, String> autEnvironment = entities.get(0);
            parametersRootFolderId = autEnvironment == null ? null : autEnvironment.get("root-app-param-folder-id");
        }
        catch (Throwable e) {
            this.logger.log(String.format("Failed to parse response: %s", response));
        }
        return parametersRootFolderId;
    }

    public String createNewAutEnvironmentConfiguration(String autEnvironmentId, AUTEnvironmentResolvedModel autEnvironmentModel) {
        String newConfigurationName = autEnvironmentModel.isUseExistingAutEnvConf() || StringUtils.isNullOrEmpty(autEnvironmentModel.getNewAutEnvConfName()) ? this.createTempConfigurationName() : autEnvironmentModel.getNewAutEnvConfName();
        return this.createNewAutEnvironmentConfiguration(autEnvironmentId, newConfigurationName);
    }

    private String createNewAutEnvironmentConfiguration(String autEnvironmentId, String newAutEnvConfigurationName) {
        String newAutEnvironmentConfigurationId = null;
        Response response = new CreateAutEnvConfRequest(this.client, autEnvironmentId, newAutEnvConfigurationName).execute();
        if (!response.isOk()) {
            this.logger.log(String.format("Failed to create new AUT Environment Configuration named: [%s] for AUT Environment with id: [%s]", newAutEnvConfigurationName, autEnvironmentId));
            return null;
        }
        try {
            newAutEnvironmentConfigurationId = XPathUtils.getAttributeValue(response.toString(), ALM_AUT_ENVIRONMENT_CONFIGURATION_ID_FIELD);
        }
        catch (Throwable e) {
            this.logger.log(String.format("Failed to parse response: %s", response));
        }
        return newAutEnvironmentConfigurationId;
    }

    public boolean shouldUseExistingConfiguration(AUTEnvironmentResolvedModel autEnvironmentModel) {
        return autEnvironmentModel.isUseExistingAutEnvConf() && this.isAutEnvironmentConfigurationExists(autEnvironmentModel.getExistingAutEnvConfId());
    }

    private boolean isAutEnvironmentConfigurationExists(String existingAutEnvConfId) {
        Response response = new GetAutEnvironmentConfigurationByIdRequest(this.client, existingAutEnvConfId).execute();
        if (!response.isOk() || XPathUtils.toEntities(response.toString()).size() != 1) {
            this.logger.log(String.format("Failed to get AUT Environment Configuration with ID: [%s]. Will try to create a new one", existingAutEnvConfId));
            return false;
        }
        return true;
    }

    private String createTempConfigurationName() {
        return "Configuration_" + Calendar.getInstance().getTime().toString();
    }
}

