/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.sse.autenvironment;

import com.microfocus.application.automation.tools.common.SSEException;
import com.microfocus.application.automation.tools.model.AUTEnvironmentResolvedModel;
import com.microfocus.application.automation.tools.model.AutEnvironmentParameterModel;
import com.microfocus.application.automation.tools.rest.RestClient;
import com.microfocus.application.automation.tools.sse.autenvironment.AUTEnvironmentManager;
import com.microfocus.application.automation.tools.sse.autenvironment.AUTEnvironmentParametersManager;
import com.microfocus.application.automation.tools.sse.autenvironment.AUTEnvironmnentParameter;
import com.microfocus.application.automation.tools.sse.common.StringUtils;
import com.microfocus.application.automation.tools.sse.sdk.Logger;
import com.microfocus.application.automation.tools.sse.sdk.authenticator.AuthenticationTool;
import hudson.EnvVars;
import hudson.util.VariableResolver;
import java.util.Collection;
import java.util.List;

public class AUTEnvironmentBuilderPerformer {
    private Logger logger;
    private AUTEnvironmentResolvedModel model;
    private RestClient restClient;
    private VariableResolver<String> buildVariableResolver;
    private String autEnvironmentConfigurationIdToReturn;

    public AUTEnvironmentBuilderPerformer(AUTEnvironmentResolvedModel model, VariableResolver<String> buildVariableResolver, Logger logger) {
        this.model = model;
        this.logger = logger;
        this.buildVariableResolver = buildVariableResolver;
    }

    public void start(EnvVars envVars) {
        try {
            if (AuthenticationTool.getInstance().authenticate(this.getClient(), this.model.getAlmUserName(), this.model.getAlmPassword(), this.model.getAlmServerUrl(), this.model.getClientType(), this.logger)) {
                this.logger.log(String.format("Alm server url: %s", this.model.getAlmServerUrl()));
                this.performAutOperations(envVars);
            }
        }
        catch (Throwable cause) {
            this.logger.log(String.format("Failed to update ALM AUT Environment. Cause: %s", cause.getMessage()));
            throw cause;
        }
    }

    public String getAutEnvironmentConfigurationIdToReturn() {
        return this.autEnvironmentConfigurationIdToReturn;
    }

    private void performAutOperations(EnvVars envVars) {
        String autEnvironmentId = this.model.getAutEnvironmentId();
        AUTEnvironmentManager autEnvironmentManager = new AUTEnvironmentManager(this.getClient(), this.logger);
        String parametersRootFolderId = autEnvironmentManager.getParametersRootFolderIdByAutEnvId(autEnvironmentId);
        String autEnvironmentConfigurationId = this.getAutEnvironmentConfigurationId(autEnvironmentManager, autEnvironmentId);
        this.assignValuesToAutParameters(autEnvironmentConfigurationId, parametersRootFolderId, envVars);
        this.autEnvironmentConfigurationIdToReturn = autEnvironmentConfigurationId;
    }

    private void assignValuesToAutParameters(String autEnvironmentConfigurationId, String parametersRootFolderId, EnvVars envVars) {
        List<AutEnvironmentParameterModel> autEnvironmentParameters = this.model.getAutEnvironmentParameters();
        if (autEnvironmentParameters == null || autEnvironmentParameters.size() == 0) {
            this.logger.log("There's no AUT Environment parameters to assign for this build...");
            return;
        }
        String selectedNode = (String)envVars.get((Object)"NODE_NAME");
        AUTEnvironmentParametersManager parametersManager = new AUTEnvironmentParametersManager(this.getClient(), autEnvironmentParameters, parametersRootFolderId, autEnvironmentConfigurationId, this.buildVariableResolver, this.model.getPathToJsonFile(), this.logger, selectedNode);
        Collection<AUTEnvironmnentParameter> parametersToUpdate = parametersManager.getParametersToUpdate();
        parametersManager.updateParametersValues(parametersToUpdate);
        this.logger.log("assignValuesToAutParameters");
    }

    private String getAutEnvironmentConfigurationId(AUTEnvironmentManager autEnvironmentManager, String autEnvironmentId) {
        String autEnvironmentConfigurationId;
        String string = autEnvironmentConfigurationId = autEnvironmentManager.shouldUseExistingConfiguration(this.model) ? this.model.getExistingAutEnvConfId() : autEnvironmentManager.createNewAutEnvironmentConfiguration(autEnvironmentId, this.model);
        if (StringUtils.isNullOrEmpty(autEnvironmentConfigurationId)) {
            throw new SSEException("There's no AUT Environment Configuration in order to proceed");
        }
        return autEnvironmentConfigurationId;
    }

    private RestClient getClient() {
        if (this.restClient == null) {
            this.restClient = new RestClient(this.model.getAlmServerUrl(), this.model.getAlmDomain(), this.model.getAlmProject(), this.model.getAlmUserName());
        }
        return this.restClient;
    }
}

