/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.settings;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.Secret;
import io.jenkins.cli.shaded.org.apache.commons.lang.RandomStringUtils;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Random;
import jenkins.model.GlobalConfiguration;
import org.kohsuke.stapler.DataBoundConstructor;

@Extension
public class UFTEncryptionGlobalConfiguration
extends GlobalConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Secret encKey;

    private static Secret generateKey() {
        return Secret.fromString((String)RandomStringUtils.random((int)32, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)new SecureRandom()));
    }

    public static UFTEncryptionGlobalConfiguration getInstance() throws NullPointerException {
        UFTEncryptionGlobalConfiguration config = (UFTEncryptionGlobalConfiguration)GlobalConfiguration.all().get(UFTEncryptionGlobalConfiguration.class);
        if (config == null) {
            throw new NullPointerException();
        }
        return config;
    }

    @DataBoundConstructor
    public UFTEncryptionGlobalConfiguration() {
        this.load();
    }

    @NonNull
    public String getDisplayName() {
        return "UFT Encryption Global Configuration (Should not appear)";
    }

    public String getEncKey() {
        if (this.encKey == null) {
            this.encKey = UFTEncryptionGlobalConfiguration.generateKey();
            this.save();
        }
        return this.encKey.getEncryptedValue();
    }
}

