/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.settings;

import com.microfocus.application.automation.tools.model.SvServerSettingsModel;
import com.microfocus.application.automation.tools.settings.ConfigurationMigrationUtil;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServerInfo;
import com.microfocus.sv.svconfigurator.core.impl.processor.Credentials;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.serverclient.impl.CommandExecutorFactory;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension(ordinal=1.0)
public class SvServerSettingsGlobalConfiguration
extends GlobalConfiguration
implements Serializable {
    private SvServerSettingsModel[] servers;

    public static SvServerSettingsGlobalConfiguration getInstance() {
        return (SvServerSettingsGlobalConfiguration)GlobalConfiguration.all().get(SvServerSettingsGlobalConfiguration.class);
    }

    protected XmlFile getConfigFile() {
        XmlFile xmlFile = super.getConfigFile();
        ConfigurationMigrationUtil.migrateConfigurationFileIfRequired(xmlFile, "com.microfocus.application.automation.tools.settings.SvServerSettingsBuilder.xml", "SvServerSettingsBuilder_-DescriptorImpl", "SvServerSettingsGlobalConfiguration");
        return xmlFile;
    }

    public SvServerSettingsGlobalConfiguration() {
        this.load();
    }

    private static boolean isHttpsSchema(String url) {
        try {
            return "https".equals(new URL(url).getProtocol());
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        List list = req.bindJSONToList(SvServerSettingsModel.class, formData.get("srv"));
        this.validateMandatoryFields(list);
        this.servers = list.toArray(new SvServerSettingsModel[list.size()]);
        this.save();
        return super.configure(req, formData);
    }

    private void validateMandatoryFields(List<SvServerSettingsModel> servers) throws Descriptor.FormException {
        for (SvServerSettingsModel server : servers) {
            this.validateConfiguration(this.doCheckName(server.getName()), "name");
            this.validateConfiguration(this.doCheckUrl(server.getUrl()), "url");
            this.validateConfiguration(this.doCheckUsername(server.getUsername(), server.getUrl()), "username");
            this.validateConfiguration(this.doCheckPassword(server.getPassword(), server.getUrl()), "password");
        }
    }

    private void validateConfiguration(FormValidation result, String formField) throws Descriptor.FormException {
        if (!((Object)((Object)result)).equals((Object)FormValidation.ok())) {
            throw new Descriptor.FormException("Validation of property in Service Virtualization server configuration failed: " + result.getMessage(), formField);
        }
    }

    public FormValidation doCheckUrl(@QueryParameter String value) {
        if (StringUtils.isBlank((String)value)) {
            return FormValidation.error((String)"Management Endpoint URL cannot be empty");
        }
        try {
            new URL(value);
        }
        catch (MalformedURLException e) {
            return FormValidation.error((String)("'" + value + "' is not valid URL"));
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckUsername(@QueryParameter String value, @QueryParameter(value="url") String url) {
        if (SvServerSettingsGlobalConfiguration.isHttpsSchema(url) && StringUtils.isBlank((String)value)) {
            return FormValidation.error((String)"Username is required for secured server");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckPassword(@QueryParameter String value, @QueryParameter(value="url") String url) {
        if (SvServerSettingsGlobalConfiguration.isHttpsSchema(url) && StringUtils.isBlank((String)value)) {
            return FormValidation.error((String)"Password is required for secured server");
        }
        return FormValidation.ok();
    }

    @RequirePOST
    public FormValidation doTestConnection(@QueryParameter(value="url") String url, @QueryParameter(value="trustEveryone") boolean trustEveryone, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password) {
        try {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            Credentials credentials = !StringUtils.isBlank((String)username) ? new Credentials(username, password) : null;
            ICommandExecutor commandExecutor = new CommandExecutorFactory().createCommandExecutor(new URL(url), trustEveryone, credentials);
            ServerInfo serverInfo = commandExecutor.getClient().getServerInfo();
            return FormValidation.ok((String)"Validation passed. Connected to %s server of version: %s", (Object[])new Object[]{serverInfo.getServerType(), serverInfo.getProductVersion()});
        }
        catch (Exception e) {
            return FormValidation.error((String)("Validation failed: " + e.getMessage()));
        }
    }

    public SvServerSettingsModel[] getServers() {
        return this.servers;
    }

    public void setServers(SvServerSettingsModel[] servers) {
        this.servers = servers;
    }

    public FormValidation doCheckName(@QueryParameter String value) {
        if (StringUtils.isBlank((String)value)) {
            return FormValidation.error((String)"Name cannot be empty");
        }
        return FormValidation.ok();
    }
}

