/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.settings;

import com.microfocus.application.automation.tools.sse.common.StringUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.model.GlobalConfiguration;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

@Extension(ordinal=1.0, optional=true)
public class RunnerMiscSettingsGlobalConfiguration
extends GlobalConfiguration
implements Serializable {
    public static final String DEFAULT_UFT_DATE_PATTERN1 = "dd/MM/yyyy HH:mm:ss";
    public static final String DEFAULT_UFT_DATE_PATTERN2 = "dd-MM-yyyy HH:mm:ss";
    public static final String DEFAULT_UFT_DATE_PATTERN3 = "dd.MM.yyyy HH:mm:ss";
    public static final List<String> DEFAULT_UFT_DATE_PATTERNS = Arrays.asList("dd/MM/yyyy HH:mm:ss", "dd-MM-yyyy HH:mm:ss", "dd.MM.yyyy HH:mm:ss");
    public static final String DEFAULT_BRANCHES = "master main trunk mainline";
    public static final String DEFAULT_OUTPUT_ENVIRONMENT_PARAMETERS = "BUILD_DISPLAY_NAME BUILD_TAG BUILD_URL";
    private String dateFormat;
    private String defaultBranches;
    private String outputEnvironmentParameters;
    private boolean agentToControllerEnabled;

    @DataBoundConstructor
    public RunnerMiscSettingsGlobalConfiguration(String mfDateFormat, String defaultBranches, String outputEnvironmentParameters, boolean agentToControllerEnabled) {
        this.setDateFormat(mfDateFormat);
        this.setDefaultBranches(defaultBranches);
        this.setAgentToControllerEnabled(agentToControllerEnabled);
        this.setOutputEnvironmentParameters(outputEnvironmentParameters);
    }

    public RunnerMiscSettingsGlobalConfiguration() {
        this.load();
    }

    public static RunnerMiscSettingsGlobalConfiguration getInstance() throws NullPointerException {
        RunnerMiscSettingsGlobalConfiguration config = (RunnerMiscSettingsGlobalConfiguration)GlobalConfiguration.all().get(RunnerMiscSettingsGlobalConfiguration.class);
        if (config == null) {
            throw new NullPointerException();
        }
        return config;
    }

    @NonNull
    public String getDisplayName() {
        return "Miscellaneous OpenText Plugin settings";
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getDefaultBranches() {
        return this.defaultBranches;
    }

    public void setDefaultBranches(String defaultBranches) {
        String validatedDefaultBranches = this.getValidatedDefaultBranches(defaultBranches);
        this.defaultBranches = !StringUtils.isNullOrEmpty(validatedDefaultBranches) ? validatedDefaultBranches : DEFAULT_BRANCHES;
        this.save();
    }

    public String getOutputEnvironmentParameters() {
        return this.outputEnvironmentParameters != null ? this.outputEnvironmentParameters : DEFAULT_OUTPUT_ENVIRONMENT_PARAMETERS;
    }

    public void setOutputEnvironmentParameters(String outputEnvironmentParameters) {
        this.outputEnvironmentParameters = outputEnvironmentParameters;
        this.save();
    }

    private String getValidatedDefaultBranches(String defaultBranches) {
        String[] branches = defaultBranches.split(" ");
        return Stream.of(branches).filter(branch -> !StringUtils.isNullOrEmpty(branch)).collect(Collectors.joining(" "));
    }

    public DateTimeFormatter getDateFormatter() {
        return this.dateFormat != null ? DateTimeFormatter.ofPattern(this.dateFormat) : DateTimeFormatter.ofPattern(DEFAULT_UFT_DATE_PATTERN1);
    }

    public void setDateFormat(String dateFormat) {
        if (!StringUtils.isNullOrEmpty(dateFormat)) {
            try {
                DateTimeFormatter.ofPattern(dateFormat);
                this.dateFormat = dateFormat;
            }
            catch (IllegalArgumentException ignored) {
                this.dateFormat = DEFAULT_UFT_DATE_PATTERN1;
            }
        } else {
            this.dateFormat = DEFAULT_UFT_DATE_PATTERN1;
        }
        this.save();
    }

    public boolean isAgentToControllerEnabled() {
        return this.agentToControllerEnabled;
    }

    public void setAgentToControllerEnabled(boolean agentToControllerEnabled) {
        this.agentToControllerEnabled = agentToControllerEnabled;
        this.save();
    }

    public FormValidation doCheckDateFormat(@QueryParameter String value) {
        if (!StringUtils.isNullOrEmpty(value)) {
            try {
                DateTimeFormatter.ofPattern(value);
            }
            catch (IllegalArgumentException ignored) {
                return FormValidation.error((String)"Invalid timestamp pattern specified.");
            }
            return FormValidation.ok();
        }
        return FormValidation.warning((String)"Will fallback to default pattern.");
    }

    public FormValidation doCheckDefaultBranches(@QueryParameter String value) {
        if (!StringUtils.isNullOrEmpty(value)) {
            return FormValidation.ok();
        }
        return FormValidation.warning((String)"Will fallback to default pattern.");
    }
}

