/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.settings;

import com.hp.octane.integrations.OctaneClient;
import com.hp.octane.integrations.OctaneConfiguration;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.entities.Entity;
import com.hp.octane.integrations.services.configurationparameters.factory.ConfigurationParameterFactory;
import com.hp.octane.integrations.utils.OctaneUrlParser;
import com.microfocus.application.automation.tools.model.OctaneServerSettingsModel;
import com.microfocus.application.automation.tools.octane.CIJenkinsServicesImpl;
import com.microfocus.application.automation.tools.octane.Messages;
import com.microfocus.application.automation.tools.octane.configuration.ConfigurationListener;
import com.microfocus.application.automation.tools.octane.configuration.ConfigurationValidator;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.settings.ConfigurationMigrationUtil;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.XmlFile;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension(ordinal=1.0)
public class OctaneServerSettingsGlobalConfiguration
extends GlobalConfiguration
implements Serializable {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(OctaneServerSettingsGlobalConfiguration.class);
    private volatile OctaneServerSettingsModel[] servers;
    private transient Map<String, OctaneConfiguration> octaneConfigurations = new HashMap<String, OctaneConfiguration>();

    public static OctaneServerSettingsGlobalConfiguration getInstance() {
        OctaneServerSettingsGlobalConfiguration octaneServerSettingsGlobalConfiguration = (OctaneServerSettingsGlobalConfiguration)GlobalConfiguration.all().get(OctaneServerSettingsGlobalConfiguration.class);
        if (octaneServerSettingsGlobalConfiguration == null) {
            logger.log(Level.INFO, "Getting the instance from the GlobalConfiguration failed. Trying again...");
            octaneServerSettingsGlobalConfiguration = (OctaneServerSettingsGlobalConfiguration)ExtensionList.lookupSingleton(OctaneServerSettingsGlobalConfiguration.class);
        }
        return octaneServerSettingsGlobalConfiguration;
    }

    protected XmlFile getConfigFile() {
        XmlFile xmlFile = super.getConfigFile();
        ConfigurationMigrationUtil.migrateConfigurationFileIfRequired(xmlFile, "com.microfocus.application.automation.tools.settings.OctaneServerSettingsBuilder.xml", "OctaneServerSettingsBuilder_-OctaneDescriptorImpl", "OctaneServerSettingsGlobalConfiguration");
        return xmlFile;
    }

    public OctaneServerSettingsGlobalConfiguration() {
        this.load();
        this.convertFortifyParameters();
        if (this.servers == null) {
            this.servers = new OctaneServerSettingsModel[0];
        }
        boolean shouldSave = false;
        if (this.servers.length == 1 && StringUtils.isEmpty((String)this.servers[0].getUiLocation())) {
            this.servers = new OctaneServerSettingsModel[0];
            shouldSave = true;
        }
        for (OctaneServerSettingsModel server : this.servers) {
            if (server.getInternalId() != null && !server.getInternalId().isEmpty()) continue;
            server.setInternalId(UUID.randomUUID().toString());
            shouldSave = true;
        }
        if (shouldSave) {
            this.save();
        }
    }

    private void convertFortifyParameters() {
        boolean updated = false;
        if (this.servers != null) {
            for (OctaneServerSettingsModel model : this.servers) {
                if (!this.convertFortifyParameters(model)) continue;
                updated = true;
            }
            if (updated) {
                this.save();
            }
        }
    }

    private boolean convertFortifyParameters(OctaneServerSettingsModel model) {
        if (!model.isFortifyParamsConverted()) {
            if (model.getSscBaseToken() != null && !model.getSscBaseToken().trim().isEmpty()) {
                Object params = StringUtils.isEmpty((String)model.getParameters()) ? "" : model.getParameters().trim() + System.lineSeparator();
                params = (String)params + "FORTIFY_SSC_TOKEN:" + model.getSscBaseToken().trim();
                model.setParameters((String)params);
            }
            model.setFortifyParamsConverted(true);
            return true;
        }
        return false;
    }

    public void initOctaneClients() {
        if (this.servers.length > 0) {
            ExecutorService executor = Executors.newFixedThreadPool(Math.min(10, this.servers.length));
            for (OctaneServerSettingsModel innerServerConfiguration : this.servers) {
                OctaneConfiguration octaneConfiguration = OctaneConfiguration.createWithUiLocation((String)innerServerConfiguration.getIdentity(), (String)innerServerConfiguration.getUiLocation());
                octaneConfiguration.setClient(innerServerConfiguration.getUsername());
                octaneConfiguration.setSecret(innerServerConfiguration.getPassword().getPlainText());
                octaneConfiguration.setSuspended(innerServerConfiguration.isSuspend());
                octaneConfiguration.setImpersonatedUser(innerServerConfiguration.getImpersonatedUser());
                octaneConfiguration.clearParameters();
                innerServerConfiguration.getParametersAsMap().entrySet().forEach(entry -> ConfigurationParameterFactory.addParameter((OctaneConfiguration)octaneConfiguration, (String)((String)entry.getKey()), (String)((String)entry.getValue())));
                this.octaneConfigurations.put(innerServerConfiguration.getInternalId(), octaneConfiguration);
                executor.execute(() -> OctaneSDK.addClient((OctaneConfiguration)octaneConfiguration, CIJenkinsServicesImpl.class));
            }
        }
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        Object data = formData.get("mqm");
        JSONArray jsonArray = new JSONArray();
        if (data instanceof JSONObject) {
            jsonArray.add(data);
        } else if (data instanceof JSONArray) {
            jsonArray.addAll((Collection)((JSONArray)data));
        }
        this.handleDeletedConfigurations(jsonArray);
        for (Object jsonObject : jsonArray) {
            JSONObject json = (JSONObject)jsonObject;
            OctaneServerSettingsModel newModel = (OctaneServerSettingsModel)req.bindJSON(OctaneServerSettingsModel.class, json);
            String internalId = json.getString("internalId");
            this.validateConfiguration(this.doCheckUiLocation(json.getString("uiLocation"), internalId), "Location");
            OctaneServerSettingsModel oldModel = this.getSettingsByInternalId(internalId);
            if (oldModel != null) {
                this.validateConfiguration(this.doCheckInstanceId(newModel.getIdentity()), "Plugin instance id");
                newModel.setInternalId(internalId);
            }
            this.setModel(newModel);
        }
        return super.configure(req, formData);
    }

    private void handleDeletedConfigurations(JSONArray jsonArray) {
        if (this.servers == null) {
            return;
        }
        Set foundInternalId = jsonArray.stream().map(jsonObj -> ((JSONObject)jsonObj).getString("internalId")).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        Set serversToRemove = Arrays.stream(this.servers).filter(server -> !foundInternalId.contains(server.getInternalId())).collect(Collectors.toSet());
        if (!serversToRemove.isEmpty()) {
            ArrayList<OctaneServerSettingsModel> serversToLeave = new ArrayList<OctaneServerSettingsModel>(Arrays.asList(this.servers));
            for (OctaneServerSettingsModel serverToRemove : serversToRemove) {
                logger.info("Removing client with instance Id: " + serverToRemove.getIdentity());
                serversToLeave.remove(serverToRemove);
                this.octaneConfigurations.remove(serverToRemove.getInternalId());
                try {
                    OctaneSDK.removeClient((OctaneClient)OctaneSDK.getClientByInstanceId((String)serverToRemove.getIdentity()));
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    logger.warn("Failed to remove client with instance Id: " + serverToRemove.getIdentity() + " from SDK : " + e.getMessage());
                }
            }
            this.servers = serversToLeave.toArray(new OctaneServerSettingsModel[0]);
            this.save();
        }
    }

    public void setModel(OctaneServerSettingsModel newModel) {
        try {
            OctaneUrlParser octaneUrlParser = ConfigurationValidator.parseUiLocation(newModel.getUiLocation());
            newModel.setSharedSpace(octaneUrlParser.getSharedSpace());
            newModel.setLocation(octaneUrlParser.getLocation());
        }
        catch (FormValidation fv) {
            logger.warn("tested configuration failed on Octane URL parse: " + fv.getMessage(), (Throwable)fv);
        }
        OctaneServerSettingsModel oldModel = this.getSettingsByInternalId(newModel.getInternalId());
        if (oldModel == null) {
            if (newModel.getIdentity() == null || newModel.getIdentity().isEmpty()) {
                newModel.setIdentity(UUID.randomUUID().toString());
            }
            if (newModel.getIdentityFrom() == null) {
                newModel.setIdentityFrom(System.currentTimeMillis());
            }
        } else if (oldModel.getIdentity() != null && !oldModel.getIdentity().isEmpty()) {
            newModel.setIdentityFrom(oldModel.getIdentityFrom());
        }
        OctaneServerSettingsModel[] serversBackup = this.servers;
        if (oldModel == null) {
            if (this.servers == null) {
                this.servers = new OctaneServerSettingsModel[]{newModel};
            } else if (this.servers.length == 1 && !this.servers[0].isValid()) {
                this.servers[0] = newModel;
            } else {
                OctaneServerSettingsModel[] newServers = new OctaneServerSettingsModel[this.servers.length + 1];
                System.arraycopy(this.servers, 0, newServers, 0, this.servers.length);
                newServers[this.servers.length] = newModel;
                this.servers = newServers;
            }
        } else {
            this.removeClientIfIdentityChanged(this.servers, newModel, oldModel);
        }
        OctaneConfiguration octaneConfiguration = this.octaneConfigurations.containsKey(newModel.getInternalId()) ? this.octaneConfigurations.get(newModel.getInternalId()) : OctaneConfiguration.create((String)newModel.getIdentity(), (String)newModel.getLocation(), (String)newModel.getSharedSpace());
        octaneConfiguration.setUrlAndSpace(newModel.getLocation(), newModel.getSharedSpace());
        octaneConfiguration.setClient(newModel.getUsername());
        octaneConfiguration.setSecret(newModel.getPassword().getPlainText());
        octaneConfiguration.setImpersonatedUser(newModel.getImpersonatedUser());
        octaneConfiguration.setSuspended(newModel.isSuspend());
        octaneConfiguration.clearParameters();
        newModel.getParametersAsMap().entrySet().forEach(entry -> ConfigurationParameterFactory.addParameter((OctaneConfiguration)octaneConfiguration, (String)((String)entry.getKey()), (String)((String)entry.getValue())));
        if (!this.octaneConfigurations.containsValue(octaneConfiguration)) {
            this.octaneConfigurations.put(newModel.getInternalId(), octaneConfiguration);
            try {
                OctaneSDK.addClient((OctaneConfiguration)octaneConfiguration, CIJenkinsServicesImpl.class);
            }
            catch (Exception e) {
                this.servers = serversBackup;
                throw e;
            }
        }
        if (!newModel.equals(oldModel)) {
            this.fireOnChanged(newModel, oldModel);
        }
        this.save();
    }

    private void removeClientIfIdentityChanged(OctaneServerSettingsModel[] servers, OctaneServerSettingsModel newModel, OctaneServerSettingsModel oldModel) {
        if (servers != null) {
            for (int i = 0; i < servers.length; ++i) {
                if (!newModel.getInternalId().equals(servers[i].getInternalId())) continue;
                servers[i] = newModel;
                if (newModel.getIdentity().equals(oldModel.getIdentity())) break;
                logger.info("Removing client with instance Id: " + oldModel.getIdentity());
                OctaneSDK.removeClient((OctaneClient)OctaneSDK.getClientByInstanceId((String)this.octaneConfigurations.get(oldModel.getInternalId()).getInstanceId()));
                this.octaneConfigurations.remove(newModel.getInternalId());
                break;
            }
        }
    }

    private void fireOnChanged(OctaneServerSettingsModel newConf, OctaneServerSettingsModel oldConf) {
        try {
            OctaneSDK.getClientByInstanceId((String)newConf.getIdentity()).getTasksProcessor().resetJobListCache();
        }
        catch (Exception e) {
            logger.info("Failed to resetJobListCache for client with instance Id: " + newConf.getIdentity() + ", " + e.getMessage());
        }
        try {
            OctaneSDK.getClientByInstanceId((String)newConf.getIdentity()).getConfigurationService().resetOctaneRootsCache();
        }
        catch (Exception e) {
            logger.info("Failed to resetOctaneRootsCache for client with instance Id: " + newConf.getIdentity() + ", " + e.getMessage());
        }
        ExtensionList listeners = ExtensionList.lookup(ConfigurationListener.class);
        for (ConfigurationListener listener : listeners) {
            try {
                listener.onChanged(newConf, oldConf);
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Exception t) {
                logger.warn((Object)t);
            }
        }
    }

    @RequirePOST
    public FormValidation doTestConnection(StaplerRequest req, @QueryParameter(value="uiLocation") String uiLocation, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="impersonatedUser") String impersonatedUser, @QueryParameter(value="suspend") Boolean isSuspend, @QueryParameter(value="workspace2ImpersonatedUserConf") String workspace2ImpersonatedUserConf, @QueryParameter(value="parameters") String parameters) {
        OctaneUrlParser octaneUrlParser;
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        String myImpersonatedUser = StringUtils.trim((String)impersonatedUser);
        String myUsername = StringUtils.trim((String)username);
        try {
            octaneUrlParser = ConfigurationValidator.parseUiLocation(StringUtils.trim((String)uiLocation));
        }
        catch (FormValidation fv) {
            logger.warn("tested configuration failed on Octane URL parse: " + fv.getMessage(), (Throwable)fv);
            return fv;
        }
        logger.info("test configuration to : " + octaneUrlParser.getLocation() + "?p=" + octaneUrlParser.getSharedSpace());
        ArrayList<String> fails = new ArrayList<String>();
        ConfigurationValidator.checkImpersonatedUser(fails, myImpersonatedUser);
        ConfigurationValidator.checkHoProxySettins(fails);
        List<Entity> availableWorkspaces = ConfigurationValidator.checkConfiguration(fails, octaneUrlParser.getLocation(), octaneUrlParser.getSharedSpace(), myUsername, Secret.fromString((String)password));
        Map<Long, String> workspace2ImpersonatedUser = ConfigurationValidator.checkWorkspace2ImpersonatedUserConf(workspace2ImpersonatedUserConf, availableWorkspaces, myImpersonatedUser, fails);
        ConfigurationValidator.checkParameters(parameters, myImpersonatedUser, workspace2ImpersonatedUser, fails);
        String suspendMessage = "Note that current configuration is disabled (see in Advanced section)";
        if (fails.isEmpty()) {
            Object msg = Messages.ConnectionSuccess();
            if (availableWorkspaces != null && !availableWorkspaces.isEmpty()) {
                int workspaceNumberLimit = 30;
                String titleNewLine = "&#xA;";
                String suffix = availableWorkspaces.size() > workspaceNumberLimit ? titleNewLine + "and more " + (availableWorkspaces.size() - workspaceNumberLimit) + " workspaces" : "";
                String tooltip = availableWorkspaces.stream().sorted(Comparator.comparingInt(e -> Integer.parseInt(e.getId()))).limit(workspaceNumberLimit).map(w -> w.getId() + " - " + w.getName() + this.getUserForWorkspace((Entity)w, workspace2ImpersonatedUser)).collect(Collectors.joining(titleNewLine, "Available workspaces are : " + titleNewLine, suffix));
                String icon = String.format("<img style=\"padding-left: 10px;\" src=\"plugin/hp-application-automation-tools-plugin/icons/16x16/info-blue.png\"  title=\"%s\"/>", tooltip);
                msg = (String)msg + icon;
            }
            if (isSuspend != null && isSuspend.booleanValue()) {
                msg = (String)msg + "<br/>" + suspendMessage;
            }
            return ConfigurationValidator.wrapWithFormValidation(true, (String)msg);
        }
        if (isSuspend != null && isSuspend.booleanValue() && !fails.contains("This plugin version is outdated and is not supported by ALM Octane.")) {
            fails.add(suspendMessage);
        }
        String errorMsg = "Validation failed : <ul data-aid=\"validation-errors\"><li>" + fails.stream().map(s -> StringEscapeUtils.escapeHtml((String)s)).collect(Collectors.joining("</li><li>")) + "</li></ul>";
        return ConfigurationValidator.wrapWithFormValidation(false, errorMsg);
    }

    private String getUserForWorkspace(Entity workspace, Map<Long, String> workspace2ImpersonatedUser) {
        if (workspace2ImpersonatedUser == null || workspace2ImpersonatedUser.isEmpty()) {
            return "";
        }
        Long workspaceId = Long.parseLong(workspace.getId());
        if (workspace2ImpersonatedUser.containsKey(workspaceId)) {
            return " (" + workspace2ImpersonatedUser.get(workspaceId) + ")";
        }
        return "";
    }

    public OctaneServerSettingsModel[] getServers() {
        return this.servers;
    }

    public void setServers(OctaneServerSettingsModel ... servers) {
        this.servers = servers;
        this.save();
    }

    public OctaneServerSettingsModel getSettings(String instanceId) {
        if (instanceId == null || instanceId.isEmpty()) {
            throw new IllegalArgumentException("instance ID MUST NOT be null nor empty");
        }
        OctaneServerSettingsModel result = null;
        if (this.servers != null) {
            for (OctaneServerSettingsModel setting : this.servers) {
                if (!instanceId.equals(setting.getIdentity())) continue;
                result = setting;
                break;
            }
        }
        return result;
    }

    public OctaneServerSettingsModel getSettingsByInternalId(String internalId) {
        if (internalId == null || internalId.isEmpty()) {
            return null;
        }
        OctaneServerSettingsModel result = null;
        if (this.servers != null) {
            for (OctaneServerSettingsModel setting : this.servers) {
                if (!internalId.equals(setting.getInternalId())) continue;
                result = setting;
                break;
            }
        }
        return result;
    }

    public FormValidation doCheckInstanceId(@QueryParameter String value) {
        if (value == null || value.isEmpty()) {
            return FormValidation.error((String)"Plugin Instance Id cannot be empty");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckUiLocation(@QueryParameter String value, @QueryParameter(value="internalId") String internalId) {
        FormValidation ret = FormValidation.ok();
        if (!StringUtils.isBlank((String)internalId)) {
            return ret;
        }
        if (StringUtils.isBlank((String)value)) {
            ret = FormValidation.error((String)"Location must be set");
            return ret;
        }
        OctaneUrlParser octaneUrlParser = null;
        try {
            octaneUrlParser = ConfigurationValidator.parseUiLocation(value);
        }
        catch (Exception e) {
            ret = FormValidation.error((String)"Failed to parse location.");
        }
        for (OctaneServerSettingsModel serverSettingsModel : this.servers) {
            if (octaneUrlParser == null || !serverSettingsModel.getSharedSpace().equals(octaneUrlParser.getSharedSpace()) || !serverSettingsModel.getLocation().equals(octaneUrlParser.getLocation())) continue;
            ret = FormValidation.error((String)"This Software Delivery Management server configuration was already set.");
            return ret;
        }
        return ret;
    }

    private void validateConfiguration(FormValidation result, String formField) throws Descriptor.FormException {
        if (!((Object)((Object)result)).equals((Object)FormValidation.ok())) {
            throw new Descriptor.FormException("Validation of property '" + formField + "' in Software Delivery Management server Configuration failed: " + result.getMessage(), formField);
        }
    }
}

