/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.settings;

import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import hudson.XmlFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;

public class ConfigurationMigrationUtil {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(ConfigurationMigrationUtil.class);

    private ConfigurationMigrationUtil() {
    }

    public static void migrateConfigurationFileIfRequired(XmlFile xmlFile, String oldFileName, String oldRootElementName, String newRootElementName) {
        File oldXmlFile;
        if (!xmlFile.exists() && (oldXmlFile = new File(Jenkins.get().getRootDir(), oldFileName)).exists()) {
            try {
                String configuration = FileUtils.readFileToString((File)oldXmlFile, (String)StandardCharsets.UTF_8.name());
                String newConfiguration = StringUtils.replace((String)configuration, (String)oldRootElementName, (String)newRootElementName);
                FileUtils.writeStringToFile((File)xmlFile.getFile(), (String)newConfiguration, (String)StandardCharsets.UTF_8.name());
            }
            catch (IOException e) {
                logger.error("failed to migrate configuration to new 6.6 format  " + newRootElementName + " : " + e.getMessage());
            }
        }
    }
}

