/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.settings;

import com.microfocus.application.automation.tools.model.AlmServerSettingsModel;
import com.microfocus.application.automation.tools.model.CredentialsModel;
import com.microfocus.application.automation.tools.model.SSOCredentialsModel;
import com.microfocus.application.automation.tools.settings.ConfigurationMigrationUtil;
import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.XmlFile;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension(ordinal=1.0)
public class AlmServerSettingsGlobalConfiguration
extends GlobalConfiguration
implements Serializable {
    private AlmServerSettingsModel[] installations = new AlmServerSettingsModel[0];

    public AlmServerSettingsGlobalConfiguration() {
        this.load();
    }

    public static AlmServerSettingsGlobalConfiguration getInstance() {
        return (AlmServerSettingsGlobalConfiguration)GlobalConfiguration.all().get(AlmServerSettingsGlobalConfiguration.class);
    }

    protected XmlFile getConfigFile() {
        XmlFile xmlFile = super.getConfigFile();
        ConfigurationMigrationUtil.migrateConfigurationFileIfRequired(xmlFile, "com.microfocus.application.automation.tools.settings.AlmServerSettingsBuilder.xml", "AlmServerSettingsBuilder_-DescriptorImpl", "AlmServerSettingsGlobalConfiguration");
        return xmlFile;
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        ArrayList<AlmServerSettingsModel> models = new ArrayList<AlmServerSettingsModel>();
        JSONArray jsonArray = new JSONArray();
        Object data = formData.get("inst");
        if (data instanceof JSONObject) {
            jsonArray.add(data);
        } else if (data instanceof JSONArray) {
            jsonArray.addAll((Collection)((JSONArray)data));
        }
        for (Object jsonObject : jsonArray) {
            JSONObject json = (JSONObject)jsonObject;
            Object credentialsObj = json.get("credentials");
            List<CredentialsModel> credentials = new ArrayList();
            if (credentialsObj instanceof JSONArray) {
                JSONArray credentialsObjArray = (JSONArray)credentialsObj;
                credentials = req.bindJSONToList(CredentialsModel.class, (Object)credentialsObjArray);
            } else if (credentialsObj instanceof JSONObject) {
                CredentialsModel credentialsModel = (CredentialsModel)req.bindJSON(CredentialsModel.class, (JSONObject)credentialsObj);
                credentials.add(credentialsModel);
            }
            Object ssoCredentialsObj = json.get("ssoCredentials");
            List<SSOCredentialsModel> ssoCredentials = new ArrayList();
            if (ssoCredentialsObj instanceof JSONArray) {
                JSONArray ssoCredentialsObjArray = (JSONArray)ssoCredentialsObj;
                ssoCredentials = req.bindJSONToList(SSOCredentialsModel.class, (Object)ssoCredentialsObjArray);
            } else if (ssoCredentialsObj instanceof JSONObject) {
                SSOCredentialsModel ssoCredentialsModel = (SSOCredentialsModel)req.bindJSON(SSOCredentialsModel.class, (JSONObject)ssoCredentialsObj);
                ssoCredentials.add(ssoCredentialsModel);
            }
            AlmServerSettingsModel newModel = (AlmServerSettingsModel)req.bindJSON(AlmServerSettingsModel.class, json);
            newModel.set_almCredentials(credentials);
            newModel.set_almSSOCredentials(ssoCredentials);
            if (StringUtils.isEmpty((String)newModel.getAlmServerName()) || StringUtils.isEmpty((String)newModel.getAlmServerUrl())) continue;
            models.add(newModel);
        }
        this.setInstallations(models.toArray(new AlmServerSettingsModel[0]));
        this.save();
        return super.configure(req, formData);
    }

    @RequirePOST
    public FormValidation doCheckAlmServerUrl(@QueryParameter String value) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        return this.checkQcServerURL(value, false);
    }

    public AlmServerSettingsModel[] getInstallations() {
        return this.installations;
    }

    public void setInstallations(AlmServerSettingsModel ... installations) {
        this.installations = installations;
    }

    public FormValidation doCheckAlmServerName(@QueryParameter String value) {
        if (StringUtils.isBlank((String)value)) {
            return FormValidation.error((String)"ALM server name cannot be empty");
        }
        return FormValidation.ok();
    }

    private FormValidation checkQcServerURL(String value, Boolean acceptEmpty) {
        String page = "servlet/tdservlet/TDAPI_GeneralWebTreatment";
        if (StringUtils.isBlank((String)value)) {
            if (!acceptEmpty.booleanValue()) {
                return FormValidation.error((String)"ALM server must be defined");
            }
            return FormValidation.ok();
        }
        String url = value.lastIndexOf(47) == value.length() - 1 ? value + page : value + "/" + page;
        try {
            HttpURLConnection connection = (HttpURLConnection)ProxyConfiguration.open((URL)new URL(url));
            connection.setRequestMethod("GET");
            if (connection.getResponseCode() != 200) {
                return FormValidation.error((String)connection.getResponseMessage());
            }
        }
        catch (MalformedURLException ex) {
            return FormValidation.error((String)"ALM server URL is malformed.");
        }
        catch (IOException ex) {
            return FormValidation.error((String)"Error opening a connection to the ALM server");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckAlmUsername(@QueryParameter String value) {
        if (StringUtils.isBlank((String)value)) {
            return FormValidation.error((String)"Username must be set");
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckAlmClientID(@QueryParameter String value) {
        if (StringUtils.isBlank((String)value)) {
            return FormValidation.error((String)"Client ID must be set");
        }
        return FormValidation.ok();
    }

    public Boolean hasAlmServers() {
        return this.installations.length > 0;
    }
}

